/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.ender_pack.core.registry;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import neoforge.com.cursee.ender_pack.Constants;
import neoforge.com.cursee.ender_pack.EnderPackNeoForge;
import neoforge.com.cursee.ender_pack.core.registry.ModBlockEntities;
import neoforge.com.cursee.ender_pack.core.registry.ModBlocks;
import neoforge.com.cursee.ender_pack.core.registry.ModItems;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;

public class RegistryNeoForge {
    private static final Set<Item> CREATIVE_MODE_TAB_ITEMS = new LinkedHashSet<Item>();

    public static void register(IEventBus modEventBus) {
        RegistryNeoForge.bind(Registries.BLOCK, consumer -> ModBlocks.register(consumer));
        RegistryNeoForge.bindForItems(ModItems::register);
        RegistryNeoForge.bind(Registries.BLOCK_ENTITY_TYPE, ModBlockEntities::register);
        RegistryNeoForge.bind(Registries.CREATIVE_MODE_TAB, consumer -> consumer.accept(CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)ModItems.ENDER_PACK)).title((Component)Component.translatable((String)"itemGroup.enderPack")).withTabsBefore(new ResourceKey[]{CreativeModeTabs.SPAWN_EGGS}).build(), Constants.ENDER_PACK_TAB_KEY.location()));
        modEventBus.addListener(entries -> {
            if (entries.getTabKey() == Constants.ENDER_PACK_TAB_KEY) {
                CREATIVE_MODE_TAB_ITEMS.forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)entries).accept(arg_0));
            }
        });
    }

    private static <T> void bind(ResourceKey<Registry<T>> registry, Consumer<BiConsumer<T, ResourceLocation>> source) {
        EnderPackNeoForge.EVENT_BUS.addListener(event -> {
            if (registry.equals(event.getRegistryKey())) {
                source.accept((t, rl) -> event.register(registry, rl, () -> t));
            }
        });
    }

    private static void bindForItems(Consumer<BiConsumer<Item, ResourceLocation>> source) {
        EnderPackNeoForge.EVENT_BUS.addListener(event -> {
            if (event.getRegistryKey().equals(Registries.ITEM)) {
                source.accept((t, rl) -> {
                    CREATIVE_MODE_TAB_ITEMS.add((Item)t);
                    event.register(Registries.ITEM, rl, () -> t);
                });
            }
        });
    }
}

