/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.ingame;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.render.JMRenderTypes;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.ingame.WaypointRenderer;
import journeymap.client.texture.TextureAccess;
import journeymap.client.texture.TextureCache;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.client.waypoint.PlayerPoint;
import journeymap.common.Journeymap;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.class_1041;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_124;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector4f;

public class WaypointDecorationRenderer
extends WaypointRenderer {
    @Override
    public void render(class_332 graphics) {
        this.waypointProperties = JourneymapClient.getInstance().getWaypointProperties();
        class_4597.class_4598 buffers = graphics.method_51450();
        Collection<ClientWaypointImpl> waypoints = WaypointStore.getInstance().getAll();
        List<ClientWaypointImpl> waypointsOrdered = this.waypointsToDraw(waypoints);
        waypointsOrdered.addAll(WaypointStore.getInstance().getPlayerPoints());
        if (waypointsOrdered.isEmpty()) {
            return;
        }
        class_4587 poseStack = graphics.method_51448();
        graphics.method_51452();
        class_1041 mainWindow = this.minecraft.method_22683();
        DrawUtil.sizeDisplay(mainWindow.method_4489(), mainWindow.method_4506());
        for (DrawStep.Pass pass : DrawStep.Pass.values()) {
            if (pass == DrawStep.Pass.PreObject || pass == DrawStep.Pass.PostObject || pass == DrawStep.Pass.Tooltip) continue;
            int zLevel = 0;
            for (ClientWaypointImpl waypoint : waypointsOrdered) {
                try {
                    poseStack.method_22903();
                    poseStack.method_46416(0.0f, 0.0f, (float)(++zLevel));
                    this.renderWaypoint(waypoint, graphics, pass, (class_4597)buffers);
                    poseStack.method_22909();
                }
                catch (Exception t) {
                    Journeymap.getLogger().error("Waypoint decoration failed to render for " + waypoint.getName() + ": ", (Throwable)t);
                }
            }
            buffers.method_22993();
        }
        DrawUtil.sizeDisplay(mainWindow.method_4486(), mainWindow.method_4502());
    }

    private List<ClientWaypointImpl> waypointsToDraw(Collection<ClientWaypointImpl> waypoints) {
        String playerDim = this.minecraft.field_1724.method_5770().method_27983().method_29177().toString();
        ArrayList<ClientWaypointImpl> toDraw = new ArrayList<ClientWaypointImpl>();
        double closestAngle = 0.0;
        ClientWaypointImpl closestHolder = null;
        for (ClientWaypointImpl waypoint : waypoints) {
            double angle;
            if (!this.canDrawWaypoint(waypoint, playerDim) || this.waypointProperties.shaderBeacon.get().booleanValue() && !this.waypointProperties.showRotatingBeam.get().booleanValue() && !this.waypointProperties.showStaticBeam.get().booleanValue() || !((angle = this.angleToBeacon(waypoint.getPosition())) < 180.0)) continue;
            if (closestHolder == null || angle < closestAngle) {
                if (closestHolder != null) {
                    toDraw.add(closestHolder);
                }
                closestHolder = waypoint;
                closestAngle = angle;
                continue;
            }
            toDraw.add(waypoint);
        }
        if (closestHolder != null) {
            toDraw.add(closestHolder);
        }
        return toDraw;
    }

    private double angleToBeacon(class_243 waypointVec) {
        double playerDegrees;
        double angle;
        double playerYaw;
        double yaw = Math.atan2(this.renderManager.field_4686.method_19326().method_10215() - waypointVec.field_1350, this.renderManager.field_4686.method_19326().method_10216() - waypointVec.field_1352);
        double degrees = Math.toDegrees(yaw) + 90.0;
        if (degrees < 0.0) {
            degrees += 360.0;
        }
        if ((playerYaw = (double)(this.minecraft.field_1719.method_5791() % 360.0f)) < 0.0) {
            playerYaw += 360.0;
        }
        if ((angle = Math.abs(degrees - (playerDegrees = Math.toDegrees(playerYaw = Math.toRadians(playerYaw))))) > 180.0) {
            angle -= 180.0;
        }
        return angle;
    }

    @Override
    protected void render(class_332 graphics, DrawStep.Pass pass, class_4597 buffers, ClientWaypointImpl waypoint, float partialTicks, long gameTime, float[] rgba, float fadeAlpha, double shiftX, double shiftY, double shiftZ, class_243 playerVec, class_243 waypointVec, double viewDistance, double actualDistance, double scale) {
        class_757 gameRenderer = this.minecraft.field_1773;
        Vector4f position = new Vector4f((float)shiftX, (float)shiftY, (float)shiftZ, 1.0f);
        double angle = this.angleToBeacon(waypoint.getPosition());
        Quaternionf rotation = new Quaternionf();
        this.renderManager.field_4686.method_23767().conjugate(rotation);
        position.rotate((Quaternionfc)rotation);
        position.rotateY((float)Math.PI);
        if (position.z <= 0.0f) {
            return;
        }
        Matrix4f projection = gameRenderer.method_22973(gameRenderer.method_3196(this.renderManager.field_4686, partialTicks, true));
        position.mulProject((Matrix4fc)projection);
        class_1041 mainWindow = this.minecraft.method_22683();
        int halfWidth = mainWindow.method_4489() / 2;
        int halfHeight = mainWindow.method_4506() / 2;
        double x = position.x * (float)halfWidth + (float)halfWidth;
        double y = position.y * (float)halfHeight + (float)halfHeight;
        if (pass == DrawStep.Pass.TextBG || pass == DrawStep.Pass.Text) {
            if (actualDistance > 0.5 && (angle < (double)this.waypointProperties.autoHideLabelAngle.get().intValue() || !this.waypointProperties.autoHideLabel.get().booleanValue())) {
                this.renderNameTag(waypoint, graphics, pass, buffers, x, y, fadeAlpha, actualDistance);
            }
            if (actualDistance > 0.5 && (waypoint.showDeviation() && angle < (double)this.waypointProperties.autoHideLabelAngle.get().intValue() || !this.waypointProperties.autoHideLabel.get().booleanValue() && waypoint.showDeviation())) {
                this.renderDeviation(waypoint, graphics, pass, buffers, x, y, fadeAlpha, playerVec, waypointVec);
            }
        }
        if (pass == DrawStep.Pass.Object && actualDistance > 0.1 && (!this.waypointProperties.autoHideIcon.get().booleanValue() || angle < (double)this.waypointProperties.autoHideIconAngle.get().intValue())) {
            this.renderIcon(waypoint, graphics, buffers, x, y, fadeAlpha);
        }
    }

    protected void renderIcon(ClientWaypointImpl waypoint, class_332 graphics, class_4597 buffers, double iconX, double iconY, float alpha) {
        double height;
        double width;
        class_1043 texture;
        int scale;
        int n = scale = this.waypointProperties.textureSmall.get() != false ? 2 : 4;
        if (waypoint instanceof PlayerPoint) {
            PlayerPoint playerPoint = (PlayerPoint)waypoint;
            texture = playerPoint.getTexture();
            width = 8 * scale;
            height = 8 * scale;
        } else {
            class_2960 location = waypoint.getTextureResource();
            texture = TextureCache.getWaypointIcon(location);
            if (texture == null) {
                texture = TextureCache.getWaypointIcon(TextureCache.Waypoint);
            }
            width = ((TextureAccess)texture).journeymap$getWidth() * scale;
            height = ((TextureAccess)texture).journeymap$getHeight() * scale;
        }
        double drawX = iconX - (double)((int)(width / 2.0));
        double drawY = iconY - (double)((int)(height / 2.0));
        class_1921 renderType = JMRenderTypes.getIconNoBlur((class_1044)texture);
        class_4588 vertexBuilder = buffers.getBuffer(renderType);
        DrawUtil.drawQuad(graphics, vertexBuilder, (int)waypoint.getIconColor(), alpha, drawX, drawY, width, height, 0.0, false);
    }

    protected void renderWaypointLabel(String label, ClientWaypointImpl waypoint, class_332 graphics, DrawStep.Pass pass, class_4597 buffers, double labelX, double labelY, float alpha) {
        float fontScale = this.waypointProperties.fontScale.get().floatValue();
        DrawUtil.drawBatchLabel(graphics, (class_2561)class_2561.method_43470((String)label), pass, buffers, labelX, labelY, DrawUtil.HAlign.Center, DrawUtil.VAlign.Above, -16777216, 0.75f * alpha, (int)waypoint.getSafeColor(), alpha, (double)fontScale, false, 0.0);
    }

    protected void renderNameTag(ClientWaypointImpl waypoint, class_332 graphics, DrawStep.Pass pass, class_4597 buffers, double labelX, double labelY, float alpha, double actualDistance) {
        String distanceLabel = Constants.getString("jm.waypoint.distance_meters", "%1.0f");
        String label = waypoint.getDisplayName();
        boolean showName = this.waypointProperties.showName.get() != false && label != null && label.length() > 0;
        boolean showDistance = this.waypointProperties.showDistance.get();
        if (showName || showDistance) {
            StringBuilder sb = new StringBuilder();
            if (this.waypointProperties.boldLabel.get().booleanValue()) {
                sb.append(class_124.field_1067);
            }
            if (showName) {
                sb.append(label);
            }
            if (showName && showDistance) {
                sb.append(" ");
            }
            if (showDistance) {
                sb.append(String.format(distanceLabel, actualDistance));
            }
            if (sb.length() > 0) {
                label = sb.toString();
                labelY = labelY - (double)(((TextureAccess)waypoint.getTexture()).journeymap$getHeight() >> 1) - 8.0;
                this.renderWaypointLabel(label, waypoint, graphics, pass, buffers, labelX, labelY, alpha);
            }
        }
    }

    protected void renderDeviation(ClientWaypointImpl waypoint, class_332 graphics, DrawStep.Pass pass, class_4597 buffers, double labelX, double labelY, float alpha, class_243 playerVec, class_243 waypointVec) {
        StringBuilder sb = new StringBuilder();
        class_243 vecTo = playerVec.method_1035(waypointVec);
        if (this.waypointProperties.boldLabel.get().booleanValue()) {
            sb.append(class_124.field_1067);
        }
        sb.append(String.format("x:%d, y:%d, z:%d", (int)vecTo.field_1352, (int)vecTo.field_1351, (int)vecTo.field_1350));
        labelY = labelY + (double)(((TextureAccess)waypoint.getTexture()).journeymap$getHeight() >> 1) + 35.0;
        this.renderWaypointLabel(sb.toString(), waypoint, graphics, pass, buffers, labelX, labelY, alpha);
    }
}

