/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.chop;

import ht.treechop.TreeChop;
import ht.treechop.TreeChopException;
import ht.treechop.api.IChoppableBlock;
import ht.treechop.api.IChoppingItem;
import ht.treechop.api.IFellableBlock;
import ht.treechop.api.IStrippableBlock;
import ht.treechop.api.IThwackableBlock;
import ht.treechop.api.ITreeBlock;
import ht.treechop.api.TreeData;
import ht.treechop.api.TreeDetectorBuilder;
import ht.treechop.common.block.ChoppedLogBlock;
import ht.treechop.common.chop.ChopDataImpl;
import ht.treechop.common.chop.ChopResult;
import ht.treechop.common.chop.ChopTreeResult;
import ht.treechop.common.chop.FellTreeResult;
import ht.treechop.common.config.ChopCounting;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.config.FellLeavesStrategy;
import ht.treechop.common.config.Lazy;
import ht.treechop.common.config.TreeLeavesBehavior;
import ht.treechop.common.settings.ChopSettings;
import ht.treechop.common.util.AxeAccessor;
import ht.treechop.common.util.BlockUtil;
import ht.treechop.common.util.ClassUtil;
import ht.treechop.server.Server;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import org.apache.commons.lang3.tuple.Pair;

public class ChopUtil {
    private static final Lazy<ITreeBlock> defaultDetector = new Lazy<ITreeBlock>(ConfigHandler.RELOAD, () -> new TreeDetectorBuilder().build());

    public static boolean isBlockALog(class_1937 level, class_2338 pos) {
        return ChopUtil.isBlockALog(level, pos, level.method_8320(pos));
    }

    public static boolean isBlockALog(class_1937 level, class_2338 pos, class_2680 blockState) {
        return ChopUtil.isBlockChoppable((class_1922)level, pos, blockState);
    }

    public static boolean isBlockChoppable(class_1937 level, class_2338 pos) {
        return ChopUtil.isBlockChoppable((class_1922)level, pos, level.method_8320(pos));
    }

    public static boolean isBlockChoppable(class_1922 level, class_2338 pos, class_2680 blockState) {
        return ClassUtil.getChoppableBlock(level, pos, blockState) != null;
    }

    public static boolean isBlockLeaves(class_1937 level, class_2338 pos, class_2680 state) {
        return ChopUtil.isBlockLeaves(state);
    }

    public static boolean isBlockLeaves(class_1937 level, class_2338 pos) {
        return ChopUtil.isBlockLeaves(level.method_8320(pos));
    }

    public static boolean isBlockLeaves(class_2680 blockState) {
        TreeLeavesBehavior behavior = ConfigHandler.COMMON.leavesBlocksAndBehaviors.get().get(blockState.method_26204());
        if (behavior != null) {
            return behavior.isLeaves(blockState);
        }
        return false;
    }

    public static boolean enoughChopsToFell(int chops, double support) {
        return ChopCounting.calculate((int)support) <= chops;
    }

    public static int numChopsToFell(double support) {
        return ChopCounting.calculate(Math.max(1, Double.valueOf(support).intValue()));
    }

    public static int numChopsToFell(class_1937 level, Stream<class_2338> logs) {
        double support = logs.map(pos -> ChopUtil.getSupportFactor(level, pos)).reduce(Double::sum).orElse(1.0);
        return ChopUtil.numChopsToFell(support);
    }

    public static Optional<Double> getSupportFactor(class_1937 level, Stream<class_2338> blocks) {
        return blocks.map(pos -> ChopUtil.getSupportFactor(level, pos)).reduce(Double::sum);
    }

    public static double getSupportFactor(class_1937 level, class_2338 pos) {
        return ChopUtil.getSupportFactor(level, pos, level.method_8320(pos));
    }

    private static double getSupportFactor(class_1937 level, class_2338 pos, class_2680 state) {
        double d;
        class_2248 class_22482 = level.method_8320(pos).method_26204();
        if (class_22482 instanceof IFellableBlock) {
            IFellableBlock block = (IFellableBlock)class_22482;
            d = block.getSupportFactor((class_1922)level, pos, state);
        } else {
            d = 1.0;
        }
        return d;
    }

    private static ChopResult getChopResult(class_1937 level, class_2338 origin, int numChops, boolean mustHaveLeaves, boolean breakLeaves, TreeData tree) {
        if (tree.isAProperTree(mustHaveLeaves)) {
            return ChopUtil.getChopResult(level, origin, tree, numChops, breakLeaves);
        }
        return ChopResult.IGNORED;
    }

    public static TreeData getTree(class_1937 level, class_2338 origin) {
        ITreeBlock detector = ClassUtil.getTreeBlock(ChopUtil.getLogBlock(level, origin));
        if (detector == null) {
            detector = defaultDetector.get();
        }
        TreeData tree = detector.getTree(level, origin);
        return TreeChop.platform.detectTreeEvent(level, null, origin, level.method_8320(origin), tree);
    }

    private static ChopResult getChopResult(class_1937 level, class_2338 origin, TreeData tree, int numChops, boolean breakLeaves) {
        if (tree.streamLogs().findFirst().isEmpty()) {
            return ChopResult.IGNORED;
        }
        if (tree.readyToFell(tree.getChops() + numChops)) {
            int numChopsNeeded = Math.min(10, Math.max(0, tree.numChopsNeededToFell() - tree.getChops()));
            return new FellTreeResult(level, tree, breakLeaves, tree.chop(origin, numChopsNeeded));
        }
        return new ChopTreeResult(level, tree.chop(origin, numChops));
    }

    public static int getMaxNumChops(class_1937 level, class_2338 blockPos, class_2680 blockState) {
        IChoppableBlock choppableBlock = ClassUtil.getChoppableBlock((class_1922)level, blockPos, blockState);
        return choppableBlock != null ? choppableBlock.getMaxNumChops((class_1922)level, blockPos, blockState) : 0;
    }

    public static int getNumChops(class_1937 level, class_2338 pos) {
        return ChopUtil.getNumChops(level, pos, level.method_8320(pos));
    }

    public static int getNumChops(class_1937 level, class_2338 pos, class_2680 blockState) {
        int n;
        class_2248 block = blockState.method_26204();
        if (block instanceof IChoppableBlock) {
            IChoppableBlock choppableBlock = (IChoppableBlock)block;
            n = choppableBlock.getNumChops((class_1922)level, pos, blockState);
        } else {
            n = 0;
        }
        return n;
    }

    public static int getNumChops(class_1937 level, Set<class_2338> positions) {
        return positions.stream().map(pos -> Pair.of((Object)pos, (Object)level.method_8320(pos))).map(posAndblockState -> {
            Integer n;
            class_2248 patt0$temp = ((class_2680)posAndblockState.getRight()).method_26204();
            if (patt0$temp instanceof IChoppableBlock) {
                IChoppableBlock choppableBlock = (IChoppableBlock)patt0$temp;
                n = choppableBlock.getNumChops((class_1922)level, (class_2338)posAndblockState.getLeft(), (class_2680)posAndblockState.getRight());
            } else {
                n = 0;
            }
            return n;
        }).reduce(Integer::sum).orElse(0);
    }

    public static int blockDistance(class_2338 a, class_2338 b) {
        return a.method_19455((class_2382)b);
    }

    public static int horizontalBlockDistance(class_2338 a, class_2338 b) {
        return new class_2382(a.method_10263(), 0, a.method_10260()).method_19455(new class_2382(b.method_10263(), 0, b.method_10260()));
    }

    public static boolean canChopWithTool(class_1657 player, class_1937 level, class_2338 pos) {
        return ChopUtil.canChopWithTool(player, player.method_6047(), level, pos, level.method_8320(pos));
    }

    public static boolean canChopWithTool(class_1657 player, class_1799 tool, class_1937 level, class_2338 pos, class_2680 blockState) {
        return !((Boolean)ConfigHandler.COMMON.mustUseCorrectToolForDrops.get() != false && blockState.method_29291() && !tool.method_7951(blockState) || (Boolean)ConfigHandler.COMMON.mustUseFastBreakingTool.get() != false && !(tool.method_7924(blockState) > 1.0f) || !ConfigHandler.canChopWithTool(player, tool, level, pos, blockState));
    }

    public static int getNumChopsByTool(class_1799 tool, class_2680 blockState) {
        IChoppingItem choppingItem = ClassUtil.getChoppingItem(tool.method_7909());
        if (choppingItem != null) {
            return choppingItem.getNumChops(tool, blockState);
        }
        return 1;
    }

    public static boolean playerWantsToChop(class_1657 player, ChopSettings chopSettings) {
        if (((Boolean)ConfigHandler.COMMON.enabled.get()).booleanValue() && (player != null && !player.method_7337() || chopSettings.getChopInCreativeMode())) {
            return chopSettings.getChoppingEnabled() ^ chopSettings.getSneakBehavior().shouldChangeChopBehavior((class_1297)player);
        }
        return false;
    }

    public static boolean chop(class_3222 agent, class_3218 level, class_2338 pos, class_2680 blockState, class_1799 tool, Object trigger) throws TreeChopException {
        ChopSettings chopSettings = Server.instance().getPlayerChopData((class_1657)agent).getSettings();
        if (ChopUtil.playerWantsToChop((class_1657)agent, chopSettings)) {
            int numChops = ChopUtil.getNumChopsByTool(tool, blockState);
            boolean treesMustHaveLeaves = chopSettings.getTreesMustHaveLeaves();
            return ChopUtil.chop(agent, level, pos, blockState, tool, trigger, numChops, treesMustHaveLeaves);
        }
        return false;
    }

    public static boolean chop(class_3222 agent, class_3218 level, class_2338 pos, class_2680 blockState, class_1799 tool, Object trigger, int numChops, boolean treesMustHaveLeaves) throws TreeChopException {
        try {
            return ChopUtil.chopUnsafe(agent, level, pos, blockState, tool, trigger, numChops, treesMustHaveLeaves);
        }
        catch (Exception e) {
            throw new TreeChopException(String.format("Parameters: %s, %s, %s, %s, %s, %s, %s, %s", agent, level, pos, blockState, tool, trigger, numChops, treesMustHaveLeaves), e);
        }
    }

    public static boolean chopUnsafe(class_3222 agent, class_3218 level, class_2338 pos, class_2680 blockState, class_1799 tool, Object trigger, int numChops, boolean treesMustHaveLeaves) {
        if (!ChopUtil.isBlockChoppable((class_1922)level, pos, blockState) || !ChopUtil.canChopWithTool((class_1657)agent, tool, (class_1937)level, pos, blockState)) {
            return false;
        }
        TreeData tree = ChopUtil.getTree((class_1937)level, pos);
        ChopDataImpl chopData = new ChopDataImpl(numChops, tree);
        boolean doChop = TreeChop.platform.startChopEvent(agent, level, pos, blockState, chopData, trigger);
        if (!doChop) {
            return false;
        }
        ChopResult chopResult = ChopUtil.getChopResult((class_1937)level, pos, chopData.getNumChops(), treesMustHaveLeaves, ConfigHandler.COMMON.fellLeavesStrategy.get() != FellLeavesStrategy.IGNORE, tree);
        if (chopResult != ChopResult.IGNORED) {
            chopResult.apply(pos, agent, tool);
            TreeChop.platform.finishChopEvent(agent, level, pos, blockState, chopData, chopResult);
            tool.method_7952((class_1937)level, blockState, pos, (class_1657)agent);
            boolean felled = chopResult instanceof FellTreeResult;
            if (!felled) {
                ChopUtil.thwack((class_1657)agent, (class_1937)level, pos, blockState);
            }
            return !felled;
        }
        return false;
    }

    public static void thwack(class_1657 thwacker, class_1937 level, class_2338 pos, class_2680 state) {
        IThwackableBlock thwackable = ClassUtil.getThwackableBlock(state.method_26204());
        if (thwackable != null) {
            thwackable.thwack(thwacker, level, pos, state);
        } else {
            float volume = 0.3f;
            float pitch = 1.0f;
            level.method_8396(thwacker, pos, TreeChop.CHOP_WOOD_EVENT.get(), class_3419.field_15245, 0.3f, 1.0f);
            level.method_31595(pos, state);
        }
    }

    public static class_2680 getStrippedState(class_1920 level, class_2338 pos, class_2680 state) {
        return ChopUtil.getStrippedState(level, pos, state, state);
    }

    public static class_2680 getStrippedState(class_1920 level, class_2338 pos, class_2680 state, class_2680 fallback) {
        class_2680 strippedState;
        class_2680 class_26802 = strippedState = AxeAccessor.isStripped(state.method_26204()) ? state : AxeAccessor.getStripped(state);
        if (strippedState == null && (strippedState = TreeChop.platform.getStrippedState(level, pos, state)) == null) {
            IStrippableBlock strippableBlock = ClassUtil.getStrippableBlock(state.method_26204());
            if (strippableBlock != null) {
                return strippableBlock.getStrippedState((class_1922)level, pos, state);
            }
            strippedState = ConfigHandler.inferredStrippedStates.get().get(state.method_26204());
        }
        return strippedState != null ? BlockUtil.copyStateProperties(strippedState, state) : fallback;
    }

    public static class_2680 getLogState(class_1937 level, class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof ChoppedLogBlock.MyEntity) {
            ChoppedLogBlock.MyEntity entity = (ChoppedLogBlock.MyEntity)class_25862;
            return entity.getOriginalState();
        }
        return level.method_8320(pos);
    }

    public static class_2248 getLogBlock(class_1937 level, class_2338 pos) {
        return ChopUtil.getLogBlock(level, pos, level.method_8320(pos));
    }

    public static class_2248 getLogBlock(class_1937 level, class_2338 pos, class_2680 state) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof ChoppedLogBlock.MyEntity) {
            ChoppedLogBlock.MyEntity entity = (ChoppedLogBlock.MyEntity)class_25862;
            return entity.getOriginalState().method_26204();
        }
        return state.method_26204();
    }
}

