/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.network;

import ht.treechop.TreeChop;
import ht.treechop.client.Client;
import ht.treechop.common.network.ConfirmedSetting;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class ServerConfirmSettingsPacket
implements class_8710 {
    public static final class_2960 ID = TreeChop.resource("server_confirm_settings");
    public static final class_8710.class_9154<ServerConfirmSettingsPacket> TYPE = new class_8710.class_9154(ID);
    public static final class_9139<class_2540, ServerConfirmSettingsPacket> STREAM_CODEC = class_8710.method_56484(ServerConfirmSettingsPacket::encode, ServerConfirmSettingsPacket::decode);
    private final List<ConfirmedSetting> settings;

    public ServerConfirmSettingsPacket(List<ConfirmedSetting> settings) {
        this.settings = settings;
    }

    public void encode(class_2540 buffer) {
        buffer.method_53002(this.settings.size());
        this.settings.forEach(setting -> setting.encode(buffer));
    }

    public static ServerConfirmSettingsPacket decode(class_2540 buffer) {
        int numSettings = buffer.readInt();
        List<ConfirmedSetting> settings = IntStream.range(0, numSettings).mapToObj($ -> ConfirmedSetting.decode(buffer)).collect(Collectors.toList());
        return new ServerConfirmSettingsPacket(settings);
    }

    public void handle() {
        this.settings.forEach(ServerConfirmSettingsPacket::processSingleSetting);
    }

    private static void processSingleSetting(ConfirmedSetting setting) {
        Client.getChopSettings().accept(setting.getField(), setting.getValue());
        setting.event.run(setting);
    }

    @NotNull
    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}

