/*
 * Decompiled with CFR 0.152.
 */
package ht.tuber.graph;

import ht.tuber.graph.DirectedGraph;
import ht.tuber.graph.FilteredGraph;
import ht.tuber.graph.FloodFill;
import ht.tuber.graph.FloodFillImpl;
import ht.tuber.graph.Link;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class GraphUtil {
    public static <T> FloodFill<T> flood(DirectedGraph<T> graph, T start, Function<T, Integer> heuristic) {
        return GraphUtil.flood(graph, Collections.singletonList(start), heuristic);
    }

    public static <T> FloodFill<T> flood(DirectedGraph<T> graph, Collection<T> start, Function<T, Integer> heuristic) {
        return new FloodFillImpl<T>(start, graph, heuristic);
    }

    public static <T> FloodFill<T> flood(DirectedGraph<T> graph, T start) {
        return GraphUtil.flood(graph, Collections.singleton(start), (T a) -> 0);
    }

    public static <T> FloodFill<T> flood(DirectedGraph<T> graph, Collection<T> start) {
        return GraphUtil.flood(graph, start, (T a) -> 0);
    }

    public static <T> DirectedGraph<T> filter(DirectedGraph<T> graph, Predicate<T> condition) {
        return new FilteredGraph<T>(graph, condition, condition);
    }

    public static <T> DirectedGraph<T> filter(DirectedGraph<T> graph, Predicate<T> originFilter, Predicate<T> neighborFilter) {
        return new FilteredGraph<T>(graph, originFilter, neighborFilter);
    }

    public static <T> DirectedGraph<T> filterSources(DirectedGraph<T> graph, Predicate<T> condition) {
        return new FilteredGraph<Object>(graph, condition, a -> true);
    }

    public static <T> DirectedGraph<T> filterNeighbors(DirectedGraph<T> graph, Predicate<T> condition) {
        return new FilteredGraph<Object>(graph, a -> true, condition);
    }

    public static <T> Stream<Link<T>> supportStream(DirectedGraph<T> sourceGraph, T bases) {
        return GraphUtil.supportStream(sourceGraph, Collections.singleton(bases));
    }

    public static <T> Stream<Link<T>> supportStream(DirectedGraph<T> sourceGraph, Collection<T> bases) {
        HashMap nodeValues = new HashMap();
        bases.forEach(sink -> nodeValues.put(sink, 0));
        ArrayDeque nextNodes = new ArrayDeque(bases);
        Link recycledLink = new Link();
        return Stream.iterate(nextNodes.poll(), Objects::nonNull, t -> nextNodes.poll()).flatMap(lowerNode -> {
            recycledLink.node = lowerNode;
            int hops = (Integer)nodeValues.get(lowerNode) + 1;
            return sourceGraph.getNeighbors(lowerNode).map(upperNode -> {
                Integer upperHops = nodeValues.getOrDefault(upperNode, hops + 1);
                if (upperHops >= hops) {
                    if (upperHops > hops) {
                        nodeValues.put(upperNode, hops);
                        nextNodes.add(upperNode);
                    }
                    recycledLink.neighbor = upperNode;
                    return recycledLink;
                }
                return null;
            }).takeWhile(Objects::nonNull);
        });
    }
}

