/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.veinmining.common.veinmining;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

public class VeinMiningPlayers {
    private static final long DIFF = 20L;
    private static final Map<UUID, Long> ACTIVATED_MINERS = new ConcurrentHashMap<UUID, Long>();
    private static final Map<UUID, Long> CURRENT_MINERS = new ConcurrentHashMap<UUID, Long>();
    private static final Map<class_1937, Map<class_2338, class_2338>> MINING_BLOCKS = new ConcurrentHashMap<class_1937, Map<class_2338, class_2338>>();

    public static void validate(long worldTime) {
        Iterator<Map.Entry<UUID, Long>> entries = ACTIVATED_MINERS.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<UUID, Long> entry = entries.next();
            long lastTime = entry.getValue();
            if (worldTime - lastTime <= 20L && lastTime <= worldTime) continue;
            entries.remove();
        }
    }

    public static boolean canStartVeinMining(class_1657 player) {
        return ACTIVATED_MINERS.containsKey(player.method_5667());
    }

    public static void activateVeinMining(class_1657 player, long time) {
        ACTIVATED_MINERS.put(player.method_5667(), time);
    }

    public static void deactivateVeinMining(class_1657 player) {
        ACTIVATED_MINERS.remove(player.method_5667());
    }

    public static boolean isVeinMining(class_1657 player) {
        return CURRENT_MINERS.containsKey(player.method_5667());
    }

    public static void startVeinMining(class_1657 player) {
        CURRENT_MINERS.put(player.method_5667(), player.method_37908().method_8510());
    }

    public static void stopVeinMining(class_1657 player) {
        CURRENT_MINERS.remove(player.method_5667());
    }

    public static void addMiningBlock(class_1937 level, class_2338 pos, class_2338 spawnPos) {
        MINING_BLOCKS.computeIfAbsent(level, k -> new HashMap()).put(pos, spawnPos);
    }

    public static void removeMiningBlock(class_1937 level, class_2338 pos) {
        Map<class_2338, class_2338> map = MINING_BLOCKS.get(level);
        if (map != null) {
            map.remove(pos);
        }
    }

    public static Optional<class_2338> getNewSpawnPosForDrop(class_1937 level, class_2338 pos) {
        Map<class_2338, class_2338> map = MINING_BLOCKS.get(level);
        if (map != null) {
            return Optional.ofNullable(map.get(pos));
        }
        return Optional.empty();
    }
}

