/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.box;

import net.minecraft.class_238;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.ABB;
import team.creative.creativecore.common.util.math.box.BoxUtils;
import team.creative.creativecore.common.util.math.matrix.IntMatrix3c;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.creativecore.common.util.math.utils.BooleanUtils;
import team.creative.creativecore.common.util.math.vec.Vec3d;

public enum BoxCorner {
    EUN(Facing.EAST, Facing.UP, Facing.NORTH),
    EUS(Facing.EAST, Facing.UP, Facing.SOUTH),
    EDN(Facing.EAST, Facing.DOWN, Facing.NORTH),
    EDS(Facing.EAST, Facing.DOWN, Facing.SOUTH),
    WUN(Facing.WEST, Facing.UP, Facing.NORTH),
    WUS(Facing.WEST, Facing.UP, Facing.SOUTH),
    WDN(Facing.WEST, Facing.DOWN, Facing.NORTH),
    WDS(Facing.WEST, Facing.DOWN, Facing.SOUTH);

    private static final BoxCorner[] LOOKUP;
    public static final BoxCorner[][] FACING_CORNERS;
    public final Facing x;
    public final Facing y;
    public final Facing z;
    public BoxCorner neighborOne;
    public BoxCorner neighborTwo;
    public BoxCorner neighborThree;

    private BoxCorner(Facing x, Facing y, Facing z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    private static BoxCorner lookup(Facing x, Facing y, Facing z) {
        int mask = (x.offset() > 0 ? 1 : 0) << 2 | (y.offset() > 0 ? 1 : 0) << 1 | (z.offset() > 0 ? 1 : 0);
        return LOOKUP[mask];
    }

    public static BoxCorner getCornerUnsorted(Facing a, Facing b, Facing c) {
        Facing y;
        Facing x;
        Facing facing = a.axis == Axis.X ? a : (x = b.axis == Axis.X ? b : c);
        Facing facing2 = a.axis == Axis.Y ? a : (y = b.axis == Axis.Y ? b : c);
        Facing z = a.axis == Axis.Z ? a : (b.axis == Axis.Z ? b : c);
        return BoxCorner.getCorner(x, y, z);
    }

    public static BoxCorner getCorner(Facing x, Facing y, Facing z) {
        int mask = (x.offset() > 0 ? 1 : 0) << 2 | (y.offset() > 0 ? 1 : 0) << 1 | (z.offset() > 0 ? 1 : 0);
        return LOOKUP[mask];
    }

    public static BoxCorner[] faceCorners(Facing facing) {
        return FACING_CORNERS[facing.ordinal()];
    }

    public boolean isFacing(Facing facing) {
        return this.getFacing(facing.axis) == facing;
    }

    public boolean isFacingPositive(Axis axis) {
        return this.getFacing((Axis)axis).positive;
    }

    public Facing getFacing(Axis axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Axis.X -> this.x;
            case Axis.Y -> this.y;
            case Axis.Z -> this.z;
        };
    }

    public BoxCorner transform(IntMatrix3c matrix) {
        int oz;
        int oy;
        int ox = this.x.offset();
        return BoxCorner.getCorner(Facing.get(Axis.X, matrix.getX(ox, oy = this.y.offset(), oz = this.z.offset()) > 0), Facing.get(Axis.Y, matrix.getY(ox, oy, oz) > 0), Facing.get(Axis.Z, matrix.getZ(ox, oy, oz) > 0));
    }

    public BoxCorner mirror(Axis axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Axis.X -> BoxCorner.lookup(this.x.opposite(), this.y, this.z);
            case Axis.Y -> BoxCorner.lookup(this.x, this.y.opposite(), this.z);
            case Axis.Z -> BoxCorner.lookup(this.x, this.y, this.z.opposite());
        };
    }

    public BoxCorner rotate(Rotation rotation) {
        int ox = this.x.offset();
        int oy = this.y.offset();
        int oz = this.z.offset();
        IntMatrix3c m = rotation.getMatrix();
        return BoxCorner.getCorner(Facing.get(Axis.X, m.getX(ox, oy, oz) > 0), Facing.get(Axis.Y, m.getY(ox, oy, oz) > 0), Facing.get(Axis.Z, m.getZ(ox, oy, oz) > 0));
    }

    public Vec3d get(ABB bb) {
        return new Vec3d(bb.get(this.x), bb.get(this.y), bb.get(this.z));
    }

    public void set(ABB bb, Vec3d vec) {
        vec.x = bb.get(this.x);
        vec.y = bb.get(this.y);
        vec.z = bb.get(this.z);
    }

    public Vec3d get(class_238 bb) {
        return new Vec3d(BoxUtils.get(bb, this.x), BoxUtils.get(bb, this.y), BoxUtils.get(bb, this.z));
    }

    public void set(class_238 bb, Vec3d vec) {
        vec.x = BoxUtils.get(bb, this.x);
        vec.y = BoxUtils.get(bb, this.y);
        vec.z = BoxUtils.get(bb, this.z);
    }

    public Facing facingTo(BoxCorner corner) {
        boolean sz;
        boolean sx = this.x == corner.x;
        boolean sy = this.y == corner.y;
        boolean bl = sz = this.z == corner.z;
        if (!BooleanUtils.explicitOneFalse(sx, sy, sz)) {
            return null;
        }
        if (!sx) {
            return corner.x;
        }
        if (!sy) {
            return corner.y;
        }
        return corner.z;
    }

    static {
        LOOKUP = new BoxCorner[8];
        FACING_CORNERS = new BoxCorner[][]{{EDN, EDS, WDN, WDS}, {EUN, EUS, WUN, WUS}, {EUN, EDN, WUN, WDN}, {EUS, EDS, WUS, WDS}, {WUN, WUS, WDN, WDS}, {EUN, EUS, EDN, EDS}};
        for (BoxCorner c : BoxCorner.values()) {
            int mask = (c.x.offset() > 0 ? 1 : 0) << 2 | (c.y.offset() > 0 ? 1 : 0) << 1 | (c.z.offset() > 0 ? 1 : 0);
            BoxCorner.LOOKUP[mask] = c;
        }
        for (BoxCorner c : BoxCorner.values()) {
            c.neighborOne = BoxCorner.lookup(c.x.opposite(), c.y, c.z);
            c.neighborTwo = BoxCorner.lookup(c.x, c.y.opposite(), c.z);
            c.neighborThree = BoxCorner.lookup(c.x, c.y, c.z.opposite());
        }
    }
}

