/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.compat.sereneseasons;

import java.util.function.BooleanSupplier;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.SeasonsConfig;
import sereneseasons.init.ModConfig;
import sereneseasons.init.ModTags;
import sereneseasons.season.SeasonHooks;

public class SereneSeasonsCompat {
    public static boolean shouldMelt(class_1937 level, class_2338 pos, class_6880<class_1959> biome) {
        if (!SereneSeasonsCompat.snowAndIceMeltInWarmBiomes((class_5321<class_1937>)level.method_27983(), biome)) {
            return false;
        }
        Season.SubSeason subSeason = SeasonHelper.getSeasonState((class_1937)level).getSubSeason();
        SeasonsConfig.SeasonProperties meltInfo = ModConfig.seasons.getSeasonProperties(subSeason);
        if (meltInfo == null) {
            return false;
        }
        return meltInfo.meltChance() > 0.0f && meltInfo.meltRolls() > 0 && !SereneSeasonsCompat.coldEnoughToSnow((class_4538)level, pos, biome);
    }

    public static boolean snowAndIceMeltInWarmBiomes(class_5321<class_1937> dimension, class_6880<class_1959> biome) {
        if (!ModConfig.seasons.generateSnowAndIce) {
            return false;
        }
        if (biome.method_40220(ModTags.Biomes.BLACKLISTED_BIOMES)) {
            return false;
        }
        return ModConfig.seasons.isDimensionWhitelisted(dimension);
    }

    public static boolean coldEnoughToSnow(class_4538 level, class_2338 pos, class_6880<class_1959> biome) {
        return SeasonHooks.getPrecipitationAtTickIceAndSnowHook((class_4538)level, (class_1959)((class_1959)biome.comp_349()), (class_2338)pos) == class_1959.class_1963.field_9383;
    }

    public static boolean isWinter(class_1937 level, class_2338 pos, class_6880<class_1959> biome) {
        if (!SereneSeasonsCompat.isSeasonal((class_5321<class_1937>)level.method_27983(), biome)) {
            return false;
        }
        return SeasonHelper.getSeasonState((class_1937)level).getSeason() == Season.WINTER;
    }

    public static boolean isSeasonal(class_5321<class_1937> dimension, class_6880<class_1959> biome) {
        return !biome.method_40220(ModTags.Biomes.BLACKLISTED_BIOMES) && !biome.method_40220(ModTags.Biomes.TROPICAL_BIOMES) && ModConfig.seasons.isDimensionWhitelisted(dimension);
    }

    public static boolean weatherTick(class_3218 level, BooleanSupplier action) {
        if (!ModConfig.seasons.isDimensionWhitelisted(level.method_27983())) {
            return false;
        }
        Season.SubSeason subSeason = SeasonHelper.getSeasonState((class_1937)level).getSubSeason();
        if (subSeason.getSeason() == Season.WINTER) {
            return action.getAsBoolean();
        }
        SeasonsConfig.SeasonProperties meltInfo = ModConfig.seasons.getSeasonProperties(subSeason);
        if (meltInfo == null) {
            return action.getAsBoolean();
        }
        int meltRolls = meltInfo.meltRolls();
        if (meltRolls == 0) {
            return false;
        }
        float meltChance = meltInfo.meltChance() * 0.01f;
        if (meltChance == 0.0f) {
            return false;
        }
        boolean result = false;
        for (int i = 0; i < meltRolls; ++i) {
            if (!(level.field_9229.method_43057() < meltChance) || !action.getAsBoolean()) continue;
            result = true;
        }
        return result;
    }
}

