/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.universal;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.class_241;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.ScreenDirection;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ProgressView;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.WailaExceptionHandler;

public abstract class ProgressProvider<T extends Accessor<?>>
implements IComponentProvider<T>,
IServerDataProvider<T> {
    public static ForBlock getBlock() {
        return ForBlock.INSTANCE;
    }

    public static ForEntity getEntity() {
        return ForEntity.INSTANCE;
    }

    public static void append(ITooltip tooltip, Accessor<?> accessor, IPluginConfig config) {
        List groups;
        if (!accessor.getServerData().method_10545("JadeProgress")) {
            return;
        }
        IClientExtensionProvider provider = Optional.ofNullable(class_2960.method_12829((String)accessor.getServerData().method_10558("JadeProgressUid"))).map(WailaClientRegistration.instance().progressProviders::get).orElse(null);
        if (provider == null) {
            return;
        }
        try {
            groups = provider.getClientGroups(accessor, ViewGroup.readList(accessor.getServerData(), "JadeProgress", Function.identity()));
        }
        catch (Exception e) {
            WailaExceptionHandler.handleErr(e, provider, tooltip::add);
            return;
        }
        if (groups.isEmpty()) {
            return;
        }
        IElementHelper helper = IElementHelper.get();
        boolean renderGroup = groups.size() > 1 || groups.getFirst().shouldRenderGroup();
        BoxStyle.GradientBorder boxStyle = BoxStyle.getTransparent().clone();
        boxStyle.bgColor = 0x44FFFFFF;
        ClientViewGroup.tooltip(tooltip, groups, renderGroup, (theTooltip, group) -> {
            if (renderGroup) {
                group.renderHeader((ITooltip)theTooltip);
            }
            for (ProgressView view : group.views) {
                if (view.text != null) {
                    theTooltip.add(helper.text(view.text).scale(0.75f));
                    theTooltip.setLineMargin(-1, ScreenDirection.DOWN, 0);
                }
                theTooltip.add(helper.progress(view.progress, null, view.style, boxStyle, false).size(new class_241(10.0f, 2.0f)));
            }
        });
    }

    public static void putData(Accessor<?> accessor) {
        Map.Entry entry = CommonProxy.getServerExtensionData(accessor, WailaCommonRegistration.instance().progressProviders);
        if (entry == null) {
            return;
        }
        class_2487 tag = accessor.getServerData();
        ViewGroup.saveList(tag, "JadeProgress", entry.getValue(), Function.identity());
        tag.method_10582("JadeProgressUid", entry.getKey().toString());
    }

    @Override
    public void appendTooltip(ITooltip tooltip, T accessor, IPluginConfig config) {
        ProgressProvider.append(tooltip, accessor, config);
    }

    @Override
    public void appendServerData(class_2487 data, T accessor) {
        ProgressProvider.putData(accessor);
    }

    @Override
    public boolean shouldRequestData(T accessor) {
        return WailaCommonRegistration.instance().progressProviders.hitsAny((Accessor<?>)accessor, (BiPredicate<IServerExtensionProvider<class_2487>, Accessor<?>>)((BiPredicate<IServerExtensionProvider, Accessor>)IServerExtensionProvider::shouldRequestData));
    }

    @Override
    public class_2960 getUid() {
        return JadeIds.UNIVERSAL_PROGRESS;
    }

    @Override
    public int getDefaultPriority() {
        return 1000;
    }

    @Override
    public boolean isRequired() {
        return true;
    }

    public static class ForBlock
    extends ProgressProvider<BlockAccessor> {
        private static final ForBlock INSTANCE = new ForBlock();
    }

    public static class ForEntity
    extends ProgressProvider<EntityAccessor> {
        private static final ForEntity INSTANCE = new ForEntity();
    }
}

