/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.client.world.registry;

import com.google.common.annotations.Beta;
import com.mojang.serialization.Lifecycle;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_5455;

@Virtual
@Beta
public class MutableDynamicRegistryManager
implements class_5455 {
    protected final Method registriesPutMethod;
    protected final Map<? extends class_5321<? extends class_2378<?>>, ? extends class_2378<?>> registries;

    public MutableDynamicRegistryManager() {
        this(new ArrayList());
    }

    public MutableDynamicRegistryManager(List<? extends class_2378<?>> registries) {
        this.registries = registries.stream().collect(Collectors.toMap(class_2378::method_30517, registry -> registry));
        try {
            this.registriesPutMethod = this.registries.getClass().getMethod("put", Object.class, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to access the 'put' method.", e);
        }
    }

    public final Map<? extends class_5321<? extends class_2378<?>>, ? extends class_2378<?>> getRegistries() {
        return this.registries;
    }

    public final <E> Optional<class_2378<E>> method_33310(class_5321<? extends class_2378<? extends E>> key) {
        class_2370 reg = this.registries.get(key);
        if (reg == null) {
            reg = new class_2370(key, Lifecycle.stable(), false);
            try {
                this.registriesPutMethod.invoke(this.registries, key, reg);
            }
            catch (Exception exc) {
                throw new RuntimeException("Failed to put create and store Registry instance", exc);
            }
        }
        return Optional.ofNullable(reg).map(registry -> registry);
    }

    public final Stream<class_5455.class_6892<?>> method_40311() {
        return this.registries.entrySet().stream().map(MutableDynamicRegistryManager::createEntry);
    }

    public static <T, R extends class_2378<? extends T>> class_5455.class_6892<T> createEntry(Map.Entry<? extends class_5321<? extends class_2378<?>>, R> entry) {
        return MutableDynamicRegistryManager.createEntry(entry.getKey(), (class_2378)entry.getValue());
    }

    public static <T> class_5455.class_6892<T> createEntry(class_5321<? extends class_2378<?>> key, class_2378<?> value) {
        return new class_5455.class_6892(key, value);
    }
}

