/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.hourglass;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.misc.SidedInstance;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.hourglass.HourglassTimeData;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSendHourglassDataPacket;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_4309;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;

public class HourglassTimesManager
extends class_4309 {
    private static final SidedInstance<HourglassTimesManager> INSTANCES = SidedInstance.of(HourglassTimesManager::new);
    private final Map<class_1792, HourglassTimeData> dustsMap = new Object2ObjectOpenHashMap();
    private final Set<HourglassTimeData> dusts = new HashSet<HourglassTimeData>();
    private final class_7225.class_7874 registryAccess;

    public static HourglassTimesManager getInstance(class_7225.class_7874 ra) {
        return (HourglassTimesManager)((Object)INSTANCES.get(ra));
    }

    public static HourglassTimesManager getInstance(@NotNull class_1937 level) {
        Preconditions.checkNotNull((Object)level);
        return HourglassTimesManager.getInstance((class_7225.class_7874)level.method_30349());
    }

    public HourglassTimesManager(class_7225.class_7874 registryAccess) {
        super(new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create(), "hourglass_dusts");
        this.registryAccess = registryAccess;
        INSTANCES.set(registryAccess, (Object)this);
    }

    protected void apply(Map<class_2960, JsonElement> jsonMap, class_3300 resourceManager, class_3695 profiler) {
        this.dustsMap.clear();
        ArrayList<HourglassTimeData> list = new ArrayList<HourglassTimeData>();
        class_6903 ops = ForgeHelper.conditionalOps((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)this.registryAccess, (class_4080)this);
        Codec codec = ForgeHelper.conditionalCodec(HourglassTimeData.CODEC);
        jsonMap.forEach((key, json) -> {
            try {
                Optional result = (Optional)codec.parse((DynamicOps)ops, json).getOrThrow();
                result.ifPresent(list::add);
            }
            catch (Exception e) {
                Supplementaries.LOGGER.error("Failed to parse JSON object for hourglass data {}", key, (Object)e);
            }
        });
        this.setData(list);
    }

    public void setData(List<HourglassTimeData> list) {
        this.dusts.clear();
        this.dusts.addAll(list);
    }

    public HourglassTimeData getData(class_1792 item) {
        if (this.dustsMap.isEmpty()) {
            ArrayList<HourglassTimeData> list = new ArrayList<HourglassTimeData>(this.dusts);
            list.sort(Comparator.comparing(HourglassTimeData::ordering));
            for (HourglassTimeData data : Lists.reverse(list)) {
                this.dusts.add(data);
                data.getItems().forEach(i -> {
                    if (i.comp_349() == class_1802.field_8162) {
                        Supplementaries.error();
                    } else {
                        this.dustsMap.put((class_1792)i.comp_349(), data);
                    }
                });
            }
        }
        return this.dustsMap.getOrDefault(item, HourglassTimeData.EMPTY);
    }

    public static void sendDataToClient(class_3222 player) {
        HourglassTimesManager instance = HourglassTimesManager.getInstance(player.method_37908());
        NetworkHelper.sendToClientPlayer((class_3222)player, (class_8710)new ClientBoundSendHourglassDataPacket(instance.dusts));
    }
}

