/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.dynamicpack;

import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.misc.IProgressTracker;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicClientResourceProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureCollager;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureOps;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.BlackboardTextureManager;
import net.mehvahdjukaar.supplementaries.client.GlobeManager;
import net.mehvahdjukaar.supplementaries.client.renderers.SlimedRenderTypes;
import net.mehvahdjukaar.supplementaries.client.renderers.color.ColorHelper;
import net.mehvahdjukaar.supplementaries.common.items.CannonBoatItem;
import net.mehvahdjukaar.supplementaries.common.misc.map_data.ColoredMapHandler;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.dynamicpack.ModServerDynamicResources;
import net.mehvahdjukaar.supplementaries.dynamicpack.MojangNeedsToAddMoreCopper;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_799;
import org.jetbrains.annotations.Nullable;

public class ModClientDynamicResources
extends DynamicClientResourceProvider {
    public ModClientDynamicResources() {
        super(Supplementaries.res("generated_pack"), ClientConfigs.General.DYNAMIC_ASSETS_GEN_MODE.get().toStrategy());
    }

    protected Collection<String> gatherSupportedNamespaces() {
        return List.of("minecraft");
    }

    public void reload(class_3300 manager, IProgressTracker reporter) {
        ColoredMapHandler.clearCache();
        SlimedRenderTypes.clear();
        BlackboardTextureManager.closeAll();
        super.reload(manager, reporter);
        GlobeManager.refreshColorsAndTextures(manager);
        ColorHelper.refreshBubbleColors(manager);
    }

    public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
        executor.accept((manager, sink) -> {
            this.addEndermanHead(manager, sink);
            this.addRopeArrowModel(manager, sink);
            this.addTatteredBook(manager, sink);
            this.addMissingFlagPatterns(manager, sink);
            MojangNeedsToAddMoreCopper.run(manager, sink);
        });
        executor.accept(this::addSignPostAssets);
        executor.accept(this::generateBoatTextures);
    }

    private void addMissingFlagPatterns(class_3300 manager, ResourceSink sink) {
        Map textures = manager.method_14488("textures/entity/banner", resourceLocation -> resourceLocation.method_12832().endsWith(".png") && !resourceLocation.method_12832().replace("textures/entity/banner/", "").contains("/"));
        TextureCollager collager = TextureCollager.builder((int)64, (int)64, (int)32, (int)16).copyFrom(3, 13, 16, 16).to(6, 2, 12, 12).bilinearScaling().build();
        for (class_2960 id : textures.keySet()) {
            String namespace = id.method_12836();
            if (namespace.equals("minecraft")) continue;
            String name = id.method_12832().replace("textures/entity/banner/", "");
            class_2960 newPath = Supplementaries.res("entity/banner/flags/" + id.method_12836() + "/" + name.substring(0, name.length() - 4));
            sink.addTextureIfNotPresent(manager, newPath, () -> {
                TextureImage textureImage;
                block8: {
                    TextureImage oldText = TextureImage.open((class_3300)manager, (class_2960)id.method_45134(p -> p.replace("textures/", "")));
                    try {
                        TextureImage newImage = TextureOps.createScaled((TextureImage)oldText, (float)0.5f, (float)0.25f);
                        newImage.clear();
                        collager.apply(oldText, newImage);
                        textureImage = newImage;
                        if (oldText == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (oldText != null) {
                                try {
                                    oldText.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    oldText.close();
                }
                return textureImage;
            });
        }
    }

    private void addSignPostAssets(class_3300 manager, ResourceSink sink) {
        Respriter respriter;
        TextureImage template;
        StaticResource spItemModel = StaticResource.getOrThrow((class_3300)manager, (class_2960)ResType.ITEM_MODELS.getPath(Supplementaries.res("way_sign_oak")));
        StaticResource spBlockModel = StaticResource.getOrThrow((class_3300)manager, (class_2960)ResType.BLOCK_MODELS.getPath(Supplementaries.res("way_signs/way_sign_oak")));
        ModRegistry.WAY_SIGN_ITEMS.forEach((wood, sign) -> {
            String id = Utils.getID((class_1792)sign).method_12832();
            sink.addSimilarJsonResource(manager, spItemModel, "way_sign_oak", id);
            sink.addSimilarJsonResource(manager, spBlockModel, "way_sign_oak", id);
        });
        try {
            template = TextureImage.open((class_3300)manager, (class_2960)Supplementaries.res("item/way_signs/template"));
            try {
                respriter = Respriter.of((TextureImage)template);
                ModRegistry.WAY_SIGN_ITEMS.forEach((wood, sign) -> {
                    class_2960 textureRes = Supplementaries.res("item/way_signs/" + Utils.getID((class_1792)sign).method_12832());
                    if (sink.alreadyHasTextureAtLocation(manager, textureRes)) {
                        return;
                    }
                    class_1792 signItem = wood.getItemOfThis("sign");
                    if (signItem != null) {
                        try (TextureImage vanillaSign = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstItemTextureLocation((class_3300)manager, (class_1792)signItem));
                             TextureImage signMask = TextureImage.open((class_3300)manager, (class_2960)Supplementaries.res("item/way_signs/sign_board_mask"));){
                            List targetPalette = Palette.fromAnimatedImage((TextureImage)vanillaSign, (TextureImage)signMask);
                            try (TextureImage newImage = respriter.recolor(targetPalette);){
                                try (TextureImage scribbles = ModClientDynamicResources.recolorFromVanilla(manager, vanillaSign, Supplementaries.res("item/way_signs/sign_scribbles_mask"), Supplementaries.res("item/way_signs/scribbles_template"));){
                                    TextureOps.applyOverlay((TextureImage)newImage, (TextureImage[])new TextureImage[]{scribbles});
                                }
                                catch (Exception ex) {
                                    Supplementaries.LOGGER.error("Could not properly color Sign Post item texture for {} : {}", (Object)sign, (Object)ex);
                                }
                                sink.addTexture(textureRes, newImage);
                            }
                        }
                        catch (Exception ex) {
                            Supplementaries.LOGGER.error("Could not find sign texture for wood explosionType {}. Using plank texture : {}", wood, (Object)ex);
                        }
                    } else {
                        try (TextureImage plankPalette = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)wood.planks));){
                            Palette targetPalette = SpriteUtils.extrapolateWoodItemPalette((TextureImage)plankPalette);
                            try (TextureImage newImage = respriter.recolor(targetPalette);){
                                sink.addTexture(textureRes, newImage);
                            }
                        }
                        catch (Exception ex) {
                            Supplementaries.LOGGER.error("Failed to generate Sign Post item texture for for {} : {}", (Object)sign, (Object)ex);
                        }
                    }
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            Supplementaries.LOGGER.error("Could not generate any Sign Post item texture : ", (Throwable)ex);
        }
        try {
            template = TextureImage.open((class_3300)manager, (class_2960)Supplementaries.res("block/way_signs/way_sign_oak"));
            try {
                respriter = Respriter.of((TextureImage)template);
                ModRegistry.WAY_SIGN_ITEMS.forEach((wood, sign) -> {
                    class_2960 textureRes = Supplementaries.res("block/way_signs/" + Utils.getID((class_1792)sign).method_12832());
                    if (sink.alreadyHasTextureAtLocation(manager, textureRes)) {
                        return;
                    }
                    try (TextureImage plankTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)wood.planks));){
                        Palette palette = Palette.fromImage((TextureImage)plankTexture);
                        try (TextureImage newImage = respriter.recolor(palette);){
                            sink.addTexture(textureRes, newImage);
                        }
                    }
                    catch (Exception ex) {
                        Supplementaries.LOGGER.error("Failed to generate Way Sign block texture for for {} : {}", (Object)sign, (Object)ex);
                    }
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            Supplementaries.LOGGER.error("Could not generate any Way Sign block texture : ", (Throwable)ex);
        }
    }

    private void addTatteredBook(class_3300 manager, ResourceSink sink) {
        if (CommonConfigs.Tools.ANTIQUE_INK_ENABLED.get().booleanValue()) {
            sink.appendModelOverride(manager, class_2960.method_60656((String)"written_book"), e -> e.add(new class_799(class_2960.method_60656((String)"item/written_book_tattered"), List.of(new class_799.class_5826(Supplementaries.res("antique_ink"), 1.0f)))));
            sink.appendModelOverride(manager, class_2960.method_60656((String)"filled_map"), e -> e.add(new class_799(class_2960.method_60656((String)"item/antique_map"), List.of(new class_799.class_5826(Supplementaries.res("antique_ink"), 1.0f)))));
        }
    }

    private void addRopeArrowModel(class_3300 manager, ResourceSink sink) {
        if (CommonConfigs.Tools.ROPE_ARROW_ENABLED.get().booleanValue()) {
            sink.appendModelOverride(manager, class_2960.method_60656((String)"crossbow"), e -> e.add(new class_799(class_2960.method_60656((String)"item/crossbow_rope_arrow"), List.of(new class_799.class_5826(class_2960.method_60656((String)"charged"), 1.0f), new class_799.class_5826(Supplementaries.res("rope_arrow"), 1.0f)))));
        }
    }

    private void addEndermanHead(class_3300 manager, ResourceSink sink) {
        if (CommonConfigs.Redstone.ENDERMAN_HEAD_ENABLED.get().booleanValue() && ClientConfigs.Tweaks.ENDERMAN_HEAD_VANILLA.get().booleanValue()) {
            try (TextureImage text = TextureImage.open((class_3300)manager, (class_2960)class_2960.method_60656((String)"entity/enderman/enderman"));
                 TextureImage eyeText = TextureImage.open((class_3300)manager, (class_2960)class_2960.method_60656((String)"entity/enderman/enderman_eyes"));){
                sink.addTexture(Supplementaries.res("entity/enderman_head"), text);
                sink.addTexture(Supplementaries.res("entity/enderman_head_eyes"), eyeText);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void generateBoatTextures(class_3300 manager, ResourceSink sink) {
        TextureImage template;
        StaticResource itemModel = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.ITEM_MODELS.getPath(Supplementaries.res("cannon_boat_oak")));
        ModRegistry.CANNON_BOAT_ITEMS.forEach((wood, sled) -> {
            try {
                sink.addSimilarJsonResource(manager, itemModel, "cannon_boat_oak", wood.getVariantId("cannon_boat"));
            }
            catch (Exception ex) {
                Supplementaries.LOGGER.error("Failed to generate Cannon Boat item model for {} : {}", (Object)sled, (Object)ex);
            }
        });
        try {
            template = TextureImage.open((class_3300)manager, (class_2960)class_2960.method_60656((String)"entity/boat/oak"));
            try {
                Respriter respriter = Respriter.of((TextureImage)template);
                ModRegistry.CANNON_BOAT_ITEMS.forEach((wood, sled) -> {
                    class_2960 textureRes = Supplementaries.res("entity/cannon_boat/" + wood.getTexturePath());
                    sink.addTextureIfNotPresent(manager, textureRes, () -> {
                        TextureImage textureImage;
                        block8: {
                            TextureImage plankTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)wood.planks));
                            try {
                                Palette targetPalette = Palette.fromImage((TextureImage)plankTexture);
                                textureImage = respriter.recolor(targetPalette);
                                if (plankTexture == null) break block8;
                            }
                            catch (Throwable throwable) {
                                try {
                                    if (plankTexture != null) {
                                        try {
                                            plankTexture.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                catch (Exception e) {
                                    throw new RuntimeException(e);
                                }
                            }
                            plankTexture.close();
                        }
                        return textureImage;
                    });
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            Supplementaries.LOGGER.error("Could not generate any sled entity texture : ", (Throwable)ex);
        }
        try {
            template = TextureImage.open((class_3300)manager, (class_2960)Supplementaries.res("item/cannon_boat/cannon_boat_oak"));
            try (TextureImage boatMask = TextureImage.open((class_3300)manager, (class_2960)Supplementaries.res("item/cannon_boat/mask"));){
                Palette palette = Palette.fromImage((TextureImage)template, (TextureImage)boatMask);
                Respriter respriter = Respriter.ofPalette((TextureImage)template, (Palette)palette);
                ModRegistry.CANNON_BOAT_ITEMS.forEach((wood, boat) -> {
                    class_2960 textureRes = Supplementaries.res("item/cannon_boat/" + Utils.getID((class_1792)boat).method_12832());
                    sink.addTextureIfNotPresent(manager, textureRes, () -> this.createBoatTexture(manager, (WoodType)wood, (CannonBoatItem)((Object)boat), respriter));
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            Supplementaries.LOGGER.error("Could not generate any Cannon Boat item texture : ", (Throwable)ex);
        }
    }

    @Nullable
    private TextureImage createBoatTexture(class_3300 manager, WoodType wood, CannonBoatItem cannonBoat, Respriter respriter) {
        Palette targetPalette;
        TextureImage newImage = null;
        class_1792 boat = wood.getItemOfThis("boat");
        if (boat != null) {
            try (TextureImage vanillaBoat = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstItemTextureLocation((class_3300)manager, (class_1792)boat));){
                targetPalette = Palette.fromImage((TextureImage)vanillaBoat);
                newImage = respriter.recolor(targetPalette);
            }
            catch (Exception ex) {
                Supplementaries.LOGGER.warn("Could not find boat texture for wood type {}. Using plank texture : {}", (Object)wood, (Object)ex);
            }
        }
        if (newImage == null) {
            try (TextureImage plankPalette = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)wood.planks));){
                targetPalette = SpriteUtils.extrapolateWoodItemPalette((TextureImage)plankPalette);
                newImage = respriter.recolor(targetPalette);
            }
            catch (Exception ex) {
                Supplementaries.LOGGER.error("Failed to generate Cannon Boat item texture for for {} : {}", (Object)cannonBoat, (Object)ex);
            }
        }
        return newImage;
    }

    private static void generateTagTranslations() {
        JsonObject jo = new JsonObject();
        for (Map.Entry<class_2960, class_3298> e : ModServerDynamicResources.TAG_TRANSLATION_HACK.entrySet()) {
            class_2960 id = e.getKey();
            if (!id.method_12836().equals("supplementaries")) continue;
            String path = id.method_12832();
            path = path.replace("tags/", "").replace(".json", "");
            String tr = path.substring(path.lastIndexOf("/") + 1);
            jo.addProperty("supplementaries:" + path, LangBuilder.getReadableName((String)tr));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static TextureImage recolorFromVanilla(class_3300 manager, TextureImage vanillaTexture, class_2960 vanillaMask, class_2960 templateTexture) {
        try (TextureImage scribbleMask = TextureImage.open((class_3300)manager, (class_2960)vanillaMask);){
            TextureImage textureImage;
            block14: {
                TextureImage template = TextureImage.open((class_3300)manager, (class_2960)templateTexture);
                try {
                    Respriter respriter = Respriter.of((TextureImage)template);
                    Palette palette = Palette.fromImage((TextureImage)vanillaTexture, (TextureImage)scribbleMask);
                    textureImage = respriter.recolor(palette);
                    if (template == null) break block14;
                }
                catch (Throwable throwable) {
                    if (template != null) {
                        try {
                            template.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                template.close();
            }
            return textureImage;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void addDynamicTranslations(AfterLanguageLoadEvent lang) {
        MojangNeedsToAddMoreCopper.runTranslations(lang);
        ModRegistry.WAY_SIGN_ITEMS.forEach((type, item) -> LangBuilder.addDynamicEntry((AfterLanguageLoadEvent)lang, (String)"item.supplementaries.way_sign", (BlockType)type, (class_1792)item));
        ModRegistry.CANNON_BOAT_ITEMS.forEach((type, item) -> LangBuilder.addDynamicEntry((AfterLanguageLoadEvent)lang, (String)"item.supplementaries.cannon_boat", (BlockType)type, (class_1792)item));
        String bambooSpikes = lang.getEntry("item.supplementaries.bamboo_spikes_tipped.effect");
        if (bambooSpikes == null) {
            return;
        }
        for (class_1842 p : class_7923.field_41179) {
            Optional<class_6880> holder = Optional.of(class_7923.field_41179.method_47983((Object)p));
            String key = class_1842.method_8051(holder, (String)"item.supplementaries.bamboo_spikes_tipped.effect.");
            String arrowName = lang.getEntry(class_1842.method_8051(holder, (String)"item.minecraft.tipped_arrow.effect."));
            if (arrowName == null) {
                lang.addEntry(key, String.format(bambooSpikes, LangBuilder.getReadableName((String)Utils.getID((class_1842)p).method_12832())));
                continue;
            }
            lang.addEntry(key, String.format(bambooSpikes, LangBuilder.getReadableName((String)arrowName.toLowerCase(Locale.ROOT).replace("arrow of ", ""))));
        }
    }
}

