/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.build;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import snownee.kiwi.KiwiAnnotationData;
import snownee.kiwi.build.KiwiMetadata;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.DumperOptions;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.LoaderOptions;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.TypeDescription;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.Yaml;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.constructor.Construct;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.nodes.MappingNode;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.nodes.Node;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.nodes.NodeTuple;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.nodes.SequenceNode;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.nodes.Tag;
import snownee.kiwi.shadowed.org.yaml.snakeyaml.representer.Representer;

public class KiwiMetadataParser {
    private final Yaml yaml;

    public KiwiMetadataParser() {
        Representer representer = new Representer(new DumperOptions());
        TypeDescription typeDescription = new TypeDescription(KiwiAnnotationData.class, Tag.MAP);
        representer.addTypeDescription(typeDescription);
        Constructor constructor = new Constructor(new LoaderOptions(), typeDescription);
        this.yaml = new Yaml(constructor, representer);
    }

    public String dump(KiwiMetadata metadata) {
        TreeMap<String, List<KiwiAnnotationData>> map = new TreeMap<String, List<KiwiAnnotationData>>(metadata.map());
        map.put("clientOnly", (List<KiwiAnnotationData>)metadata.clientOnly());
        return this.yaml.dump(map);
    }

    public KiwiMetadata load(InputStream is) {
        return KiwiMetadata.of(this.yaml.loadAs(is, Map.class));
    }

    public KiwiMetadata load(String s) {
        return KiwiMetadata.of(this.yaml.loadAs(s, Map.class));
    }

    private static class Constructor
    extends snownee.kiwi.shadowed.org.yaml.snakeyaml.constructor.Constructor {
        public Constructor(LoaderOptions loaderOptions, TypeDescription typeDescription) {
            super(loaderOptions);
            this.typeDefinitions.put(typeDescription.getType(), typeDescription);
        }

        @Override
        public Object getSingleData(Class<?> type) {
            Node node = this.composer.getSingleNode();
            if (node != null && !Tag.NULL.equals(node.getTag())) {
                if (Object.class != type) {
                    node.setTag(new Tag(type));
                } else if (this.rootTag != null) {
                    node.setTag(this.rootTag);
                }
                if (node instanceof MappingNode) {
                    MappingNode mappingNode = (MappingNode)node;
                    for (NodeTuple nodeTuple : mappingNode.getValue()) {
                        Node node2 = nodeTuple.getValueNode();
                        if (!(node2 instanceof SequenceNode)) continue;
                        SequenceNode sequenceNode = (SequenceNode)node2;
                        for (Node child : sequenceNode.getValue()) {
                            if (!(child instanceof MappingNode)) continue;
                            child.setType(KiwiAnnotationData.class);
                        }
                    }
                }
                return this.constructDocument(node);
            }
            Construct construct = (Construct)this.yamlConstructors.get(Tag.NULL);
            return construct.construct(node);
        }
    }
}

