/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import it.unimi.dsi.fastutil.objects.Object2IntAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.math.BigDecimal;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.class_2960;
import snownee.kiwi.KiwiCommonConfig;
import snownee.kiwi.KiwiModules;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.shadowed.com.ezylang.evalex.EvaluationException;
import snownee.kiwi.shadowed.com.ezylang.evalex.Expression;
import snownee.kiwi.shadowed.com.ezylang.evalex.config.ExpressionConfiguration;
import snownee.kiwi.shadowed.com.ezylang.evalex.data.DataAccessorIfc;
import snownee.kiwi.shadowed.com.ezylang.evalex.data.EvaluationValue;
import snownee.kiwi.shadowed.com.ezylang.evalex.functions.AbstractFunction;
import snownee.kiwi.shadowed.com.ezylang.evalex.functions.FunctionParameter;
import snownee.kiwi.shadowed.com.ezylang.evalex.operators.AbstractOperator;
import snownee.kiwi.shadowed.com.ezylang.evalex.operators.InfixOperator;
import snownee.kiwi.shadowed.com.ezylang.evalex.parser.Token;

public class KEval {
    private static final ExpressionConfiguration CONFIG = ExpressionConfiguration.builder().defaultConstants(KEval.generateConstants()).dataAccessorSupplier(DataAccessor::new).singleQuoteStringLiteralsAllowed(true).build();

    private static Map<String, EvaluationValue> generateConstants() {
        TreeMap<String, EvaluationValue> map = new TreeMap<String, EvaluationValue>(ExpressionConfiguration.StandardConstants);
        map.put("MC", EvaluationValue.numberValue(new BigDecimal(Platform.getVersionNumber("minecraft"))));
        map.put("FORGELIKE", EvaluationValue.booleanValue(Platform.getPlatformSeries() == Platform.Type.Forge));
        map.put("FABRICLIKE", EvaluationValue.booleanValue(Platform.getPlatformSeries() == Platform.Type.Fabric));
        map.put("MODLOADER", EvaluationValue.stringValue(Platform.getPlatform().name()));
        return map;
    }

    public static ExpressionConfiguration config() {
        return CONFIG;
    }

    static {
        KEval.config().getFunctionDictionary().addFunction("HAS", new HasFunction());
        KEval.config().getFunctionDictionary().addFunction("VER", new VerFunction());
        KEval.config().getOperatorDictionary().addOperator("??", new NullishCoalescingOperator());
    }

    @FunctionParameter(name="id")
    private static class HasFunction
    extends AbstractFunction {
        private HasFunction() {
        }

        @Override
        public EvaluationValue evaluate(Expression expression, Token functionToken, EvaluationValue ... parameterValues) throws EvaluationException {
            String string = parameterValues[0].getStringValue();
            if (string.startsWith("@")) {
                return EvaluationValue.booleanValue(KiwiModules.isLoaded(class_2960.method_60654((String)string.substring(1))));
            }
            return EvaluationValue.booleanValue(Platform.isModLoaded(string));
        }
    }

    @FunctionParameter(name="id")
    private static class VerFunction
    extends AbstractFunction {
        private final Object2IntMap<String> cache = new Object2IntAVLTreeMap();

        private VerFunction() {
        }

        @Override
        public EvaluationValue evaluate(Expression expression, Token functionToken, EvaluationValue ... parameterValues) throws EvaluationException {
            String string = parameterValues[0].getStringValue();
            return EvaluationValue.numberValue(new BigDecimal(this.cache.computeIfAbsent((Object)string, Platform::getVersionNumber)));
        }
    }

    @InfixOperator(precedence=2)
    private static class NullishCoalescingOperator
    extends AbstractOperator {
        private NullishCoalescingOperator() {
        }

        @Override
        public EvaluationValue evaluate(Expression expression, Token operatorToken, EvaluationValue ... operands) throws EvaluationException {
            if (operands[0].isNullValue()) {
                return operands[1];
            }
            return operands[0];
        }
    }

    private static class DataAccessor
    implements DataAccessorIfc {
        private DataAccessor() {
        }

        @Override
        public EvaluationValue getData(String variable) {
            Object o = KiwiCommonConfig.vars.get(variable);
            return new EvaluationValue(o, KEval.config());
        }

        @Override
        public void setData(String variable, EvaluationValue value) {
        }
    }
}

