/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class PostClientInitTaskExecutor {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, List<Runnable>> EVENTS = new LinkedHashMap<String, List<Runnable>>();

    protected static void executeAll() {
        EVENTS.forEach((modId, tasks) -> {
            try {
                LOGGER.info("[KONKRETE] Executing post-client-init tasks of '" + modId + "'...");
                tasks.forEach(Runnable::run);
            }
            catch (Exception ex) {
                LOGGER.error("[KONKRETE] Error while executing post-client-init tasks of '" + modId + "'!", (Throwable)ex);
            }
        });
    }

    protected static void addTask(@NotNull String modId, @NotNull Runnable task) {
        if (!EVENTS.containsKey(modId)) {
            EVENTS.put(modId, new ArrayList());
        }
        EVENTS.get(modId).add(task);
    }
}

