/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.client.renderer.BackpackEntityLayer;
import com.tiviacz.travelersbackpack.client.renderer.BackpackLayer;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.BackpackSettingsScreen;
import com.tiviacz.travelersbackpack.client.screens.HudOverlay;
import com.tiviacz.travelersbackpack.client.screens.tooltip.BackpackTooltipComponent;
import com.tiviacz.travelersbackpack.client.screens.tooltip.ClientBackpackTooltipComponent;
import com.tiviacz.travelersbackpack.commands.BackpackIconCommands;
import com.tiviacz.travelersbackpack.compat.accessories.TravelersBackpackAccessory;
import com.tiviacz.travelersbackpack.compat.polymorph.PolymorphCompat;
import com.tiviacz.travelersbackpack.compat.trinkets.TravelersBackpackTrinket;
import com.tiviacz.travelersbackpack.fluids.potion.PotionFluidVariantAttributeHandler;
import com.tiviacz.travelersbackpack.fluids.potion.PotionFluidVariantRenderHandler;
import com.tiviacz.travelersbackpack.handlers.BackpackModelLoadingPlugin;
import com.tiviacz.travelersbackpack.handlers.KeybindHandler;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModFluids;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.init.ModNetwork;
import com.tiviacz.travelersbackpack.init.ModScreenHandlerTypes;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.api.client.render.fluid.v1.SimpleFluidRenderHandler;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.LivingEntityFeatureRendererRegistrationCallback;
import net.fabricmc.fabric.api.client.rendering.v1.TooltipComponentCallback;
import net.fabricmc.fabric.api.object.builder.v1.client.model.FabricModelPredicateProviderRegistry;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRenderHandler;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributeHandler;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1007;
import net.minecraft.class_1091;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_3929;
import net.minecraft.class_5253;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_742;
import net.minecraft.class_7923;
import net.minecraft.class_916;
import net.minecraft.class_922;
import net.minecraft.class_9282;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public class TravelersBackpackClient
implements ClientModInitializer {
    public static final class_1091 STAR_MODEL = new class_1091(class_2960.method_60655((String)"travelersbackpack", (String)"item/supporter_star"), "standalone");

    public void onInitializeClient() {
        class_3929.method_17542(ModScreenHandlerTypes.BACKPACK_MENU, BackpackScreen::new);
        class_3929.method_17542(ModScreenHandlerTypes.BACKPACK_BLOCK_MENU, BackpackScreen::new);
        class_3929.method_17542(ModScreenHandlerTypes.BACKPACK_SETTINGS_MENU, BackpackSettingsScreen::new);
        TravelersBackpackClient.registerFeatureRenderers();
        TravelersBackpackClient.registerHudOverlay();
        TravelersBackpackClient.registerTooltipComponent();
        KeybindHandler.initKeybinds();
        KeybindHandler.registerListener();
        ModNetwork.initClient();
        TravelersBackpackClient.registerModelPredicate();
        TravelersBackpackClient.setupFluidRendering();
        TravelersBackpackClient.registerBackpackItemEntityRenderer();
        TravelersBackpackClient.registerClientCommands();
        if (TravelersBackpack.polymorphLoaded) {
            PolymorphCompat.registerWidget();
        }
        ModelLoadingPlugin.register((ModelLoadingPlugin)new BackpackModelLoadingPlugin());
        TravelersBackpackClient.registerItemColorProvider();
        TravelersBackpackClient.registerBlockColorProvider();
        TravelersBackpackClient.registerBackpackRenderLayers();
        if (TravelersBackpack.accessoriesLoaded) {
            TravelersBackpackAccessory.initClient();
        }
        if (TravelersBackpack.trinketsLoaded) {
            TravelersBackpackTrinket.initClient();
        }
    }

    public static void registerBackpackItemEntityRenderer() {
        EntityRendererRegistry.register(ModItems.BACKPACK_ITEM_ENTITY, class_916::new);
    }

    public static void registerItemColorProvider() {
        ColorProviderRegistry.ITEM.register((stack, tintIndex) -> {
            if (tintIndex != 0) {
                return -1;
            }
            if (stack.method_57826(class_9334.field_49644)) {
                return class_5253.class_5254.method_57174((int)((class_9282)stack.method_57824(class_9334.field_49644)).comp_2384());
            }
            return -1;
        }, (Object[])new class_1935[]{ModBlocks.STANDARD_TRAVELERS_BACKPACK});
    }

    public static void registerBlockColorProvider() {
        ColorProviderRegistry.BLOCK.register((state, view, pos, tintIndex) -> {
            BackpackBlockEntity backpack;
            if (tintIndex != 0 || pos == null) {
                return -1;
            }
            class_2586 patt0$temp = view.method_8321(pos);
            if (patt0$temp instanceof BackpackBlockEntity && (backpack = (BackpackBlockEntity)patt0$temp).getWrapper().getBackpackStack().method_57826(class_9334.field_49644)) {
                return class_5253.class_5254.method_57174((int)((class_9282)backpack.getWrapper().getBackpackStack().method_57824(class_9334.field_49644)).comp_2384());
            }
            return -1;
        }, (Object[])new class_2248[]{ModBlocks.STANDARD_TRAVELERS_BACKPACK});
    }

    public static void registerBackpackRenderLayers() {
        ArrayList<class_2248> cutout = new ArrayList<class_2248>(class_7923.field_41175.method_10220().filter(block -> block instanceof TravelersBackpackBlock).toList());
        cutout.removeIf(block -> block == ModBlocks.QUARTZ_TRAVELERS_BACKPACK);
        cutout.removeIf(block -> block == ModBlocks.SNOW_TRAVELERS_BACKPACK);
        cutout.forEach(block -> BlockRenderLayerMap.INSTANCE.putBlock(block, class_1921.method_23581()));
        BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.QUARTZ_TRAVELERS_BACKPACK, class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.SNOW_TRAVELERS_BACKPACK, class_1921.method_23583());
    }

    public static void registerFeatureRenderers() {
        LivingEntityFeatureRendererRegistrationCallback.EVENT.register((entityType, entityRenderer, registrationHelper, context) -> {
            if (entityRenderer instanceof class_1007) {
                class_1007 renderer = (class_1007)entityRenderer;
                registrationHelper.register((class_3887)new BackpackLayer((class_3883<class_742, class_591<class_742>>)renderer));
            }
            if (entityRenderer.method_4038() instanceof class_572 && entityRenderer instanceof class_922) {
                if (entityRenderer instanceof class_1007) {
                    return;
                }
                registrationHelper.register((class_3887)new BackpackEntityLayer((class_3883<class_1309, class_572<class_1309>>)entityRenderer));
            }
        });
    }

    public static void registerHudOverlay() {
        HudRenderCallback.EVENT.register(HudOverlay::renderOverlay);
    }

    public static void setupFluidRendering() {
        FluidRenderHandlerRegistry.INSTANCE.register((class_3611)ModFluids.POTION_STILL, (class_3611)ModFluids.POTION_FLOWING, (FluidRenderHandler)new SimpleFluidRenderHandler(class_2960.method_60655((String)"travelersbackpack", (String)"block/potion_still"), class_2960.method_60655((String)"travelersbackpack", (String)"block/potion_flow"), 13458603));
        FluidVariantAttributes.register((class_3611)ModFluids.POTION_STILL, (FluidVariantAttributeHandler)new PotionFluidVariantAttributeHandler());
        FluidVariantAttributes.register((class_3611)ModFluids.POTION_FLOWING, (FluidVariantAttributeHandler)new PotionFluidVariantAttributeHandler());
        FluidVariantRendering.register((class_3611)ModFluids.POTION_STILL, (FluidVariantRenderHandler)new PotionFluidVariantRenderHandler());
        FluidVariantRendering.register((class_3611)ModFluids.POTION_FLOWING, (FluidVariantRenderHandler)new PotionFluidVariantRenderHandler());
        BlockRenderLayerMap.INSTANCE.putFluids(class_1921.method_23583(), new class_3611[]{ModFluids.POTION_STILL, ModFluids.POTION_FLOWING});
    }

    public static void registerTooltipComponent() {
        TooltipComponentCallback.EVENT.register(data -> {
            if (data instanceof BackpackTooltipComponent) {
                return new ClientBackpackTooltipComponent((BackpackTooltipComponent)data);
            }
            return null;
        });
    }

    public static void registerModelPredicate() {
        FabricModelPredicateProviderRegistry.register((class_1792)ModItems.HOSE, (class_2960)class_2960.method_60655((String)"travelersbackpack", (String)"mode"), (itemStack, clientWorld, livingEntity, par) -> {
            if (itemStack.method_57826(ModDataComponents.HOSE_MODES)) {
                int mode = (Integer)((List)itemStack.method_57824(ModDataComponents.HOSE_MODES)).get(0);
                return (float)mode / 10.0f;
            }
            return 0.0f;
        });
    }

    public static void registerClientCommands() {
        ClientCommandRegistrationCallback.EVENT.register(BackpackIconCommands::new);
    }
}

