/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.compat;

import eu.pb4.graves.GravesApi;
import eu.pb4.graves.grave.GraveInventoryMask;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.DropRule;
import io.wispforest.accessories.api.events.OnDropCallback;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_9331;
import net.minecraft.class_9701;
import org.jetbrains.annotations.Nullable;

public record AccessoriesCompat() implements GraveInventoryMask
{
    private static final String TYPE_TAG = "Type";
    private static final String SLOT_TAG = "Slot";

    public static void register() {
        GravesApi.registerInventoryMask(class_2960.method_60655((String)"universal_graves", (String)"accessories"), new AccessoriesCompat());
    }

    @Override
    public void addToGrave(class_3222 player, GraveInventoryMask.ItemConsumer consumer) {
        AccessoriesCapability cap = AccessoriesCapability.get((class_1309)player);
        if (cap == null) {
            return;
        }
        cap.getContainers().forEach((s, accessoriesContainer) -> {
            DropRule defRule = accessoriesContainer.slotType() != null ? Objects.requireNonNull(accessoriesContainer.slotType()).dropRule() : DropRule.DEFAULT;
            this.addToGrave(player, consumer, (String)s, accessoriesContainer.getAccessories(), "", defRule);
            this.addToGrave(player, consumer, (String)s, accessoriesContainer.getCosmeticAccessories(), "cosmetic", defRule);
        });
    }

    private void addToGrave(class_3222 player, GraveInventoryMask.ItemConsumer consumer, String slotName, ExpandedSimpleContainer accessories, String type, DropRule defaultDropRule) {
        class_1282 dmg = player.method_6081();
        if (dmg == null) {
            dmg = player.method_48923().method_48830();
        }
        for (int i = 0; i < accessories.method_5439(); ++i) {
            class_1799 stack = accessories.method_5438(i);
            if (stack.method_7960() || !GravesApi.canAddItem(player, stack)) {
                return;
            }
            SlotReference ref = SlotReference.of((class_1309)player, (String)slotName, (int)i);
            DropRule dropRule = AccessoriesAPI.getOrDefaultAccessory((class_1799)stack).getDropRule(stack, ref, dmg);
            dropRule = ((OnDropCallback)OnDropCallback.EVENT.invoker()).onDrop(dropRule, stack, ref, dmg);
            if (dropRule == DropRule.DEFAULT) {
                dropRule = defaultDropRule;
            }
            if (dropRule == DropRule.DEFAULT) {
                dropRule = class_1890.method_60142((class_1799)stack, (class_9331)class_9701.field_51655) ? DropRule.DESTROY : DropRule.DROP;
            }
            if (dropRule != DropRule.DROP) continue;
            class_2487 nbt = new class_2487();
            nbt.method_10582(TYPE_TAG, type);
            nbt.method_10582(SLOT_TAG, slotName);
            consumer.addItem(stack.method_7972(), i, (class_2520)nbt);
            accessories.method_5447(i, class_1799.field_8037);
        }
    }

    @Override
    public boolean moveToPlayerExactly(class_3222 player, class_1799 stack, int slot, class_2520 extraData) {
        String slotId;
        String typeId = ((class_2487)extraData).method_10558(TYPE_TAG);
        ExpandedSimpleContainer inventory = this.getInventory(player, typeId, slotId = ((class_2487)extraData).method_10558(SLOT_TAG));
        if (inventory != null && inventory.method_5438(slot).method_7960()) {
            inventory.method_5447(slot, stack.method_51164());
            return true;
        }
        return false;
    }

    @Override
    public boolean moveToPlayerClosest(class_3222 player, class_1799 stack, int slot, class_2520 data) {
        String slotId;
        String type = ((class_2487)data).method_10558(TYPE_TAG);
        ExpandedSimpleContainer inventory = this.getInventory(player, type, slotId = ((class_2487)data).method_10558(SLOT_TAG));
        if (inventory != null) {
            int size = inventory.method_5439();
            for (int i = 0; i < size; ++i) {
                if (!inventory.method_5438(i).method_7960()) continue;
                inventory.method_5447(i, stack.method_51164());
                return true;
            }
        }
        return false;
    }

    @Nullable
    private ExpandedSimpleContainer getInventory(class_3222 player, String type, String slotId) {
        ExpandedSimpleContainer expandedSimpleContainer;
        AccessoriesCapability cap = AccessoriesCapability.get((class_1309)player);
        if (cap == null) {
            return null;
        }
        AccessoriesContainer slot = (AccessoriesContainer)cap.getContainers().get(slotId);
        if (slot != null) {
            String string = type;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"cosmetic"}, (Object)string, n)) {
                case 0: {
                    expandedSimpleContainer = slot.getCosmeticAccessories();
                    break;
                }
                default: {
                    expandedSimpleContainer = slot.getAccessories();
                    break;
                }
            }
        } else {
            expandedSimpleContainer = null;
        }
        return expandedSimpleContainer;
    }
}

