/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.grave;

import com.mojang.datafixers.DataFixer;
import eu.pb4.graves.GravesMod;
import eu.pb4.graves.grave.Grave;
import eu.pb4.graves.other.Location;
import eu.pb4.graves.registry.GraveGameRules;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_155;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;

public final class GraveManager
extends class_18 {
    public static GraveManager INSTANCE;
    private final HashMap<UUID, Set<Grave>> byUuid = new HashMap();
    private final HashMap<Location, Grave> byLocation = new HashMap();
    private final Long2ObjectMap<Grave> byId = new Long2ObjectOpenHashMap();
    private final HashSet<Grave> graves = new HashSet();
    private long ticker;
    private long currentGameTime = 0L;
    private long currentGraveId = 0L;
    private int protectionTime;
    private int breakingTime;

    public static class_18.class_8645<GraveManager> getType(MinecraftServer server) {
        return new class_18.class_8645(GraveManager::new, (a, b) -> GraveManager.fromNbt(a, b, server.method_3855()), null);
    }

    public void add(Grave grave) {
        if (grave.getId() == -1L) {
            grave.setId(this.requestId());
        }
        this.byUuid.computeIfAbsent(grave.getProfile().getId(), v -> new HashSet()).add(grave);
        this.byLocation.put(grave.getLocation(), grave);
        this.byId.put(grave.getId(), (Object)grave);
        this.graves.add(grave);
        this.method_80();
    }

    public void remove(Grave info) {
        if (this.graves.remove(info)) {
            Set<Grave> graveInfoList = this.byUuid.get(info.getProfile().getId());
            this.byLocation.remove(info.getLocation());
            this.byId.remove(info.getId());
            if (graveInfoList != null) {
                graveInfoList.remove(info);
                if (graveInfoList.isEmpty()) {
                    this.byUuid.remove(info.getProfile().getId());
                }
            }
            this.method_80();
        }
    }

    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 lookup) {
        class_2499 list = new class_2499();
        for (Grave grave : new ArrayList<Grave>(this.graves)) {
            if (grave.shouldNaturallyBreak()) continue;
            list.add((Object)grave.writeNbt(new class_2487(), lookup));
        }
        nbt.method_10566("Graves", (class_2520)list);
        nbt.method_10569("Version", 3);
        nbt.method_10569("GameVersion", class_155.method_16673().method_37912().method_38494());
        nbt.method_10544("CurrentGameTime", this.currentGameTime);
        nbt.method_10544("CurrentGrave", this.currentGraveId);
        return nbt;
    }

    public static GraveManager fromNbt(class_2487 nbt, class_7225.class_7874 lookup, DataFixer dataFixer) {
        GraveManager manager;
        INSTANCE = manager = new GraveManager();
        int dataVersion = nbt.method_10550("Version") == 2 ? 3700 : nbt.method_10550("GameVersion");
        manager.currentGameTime = nbt.method_10537("CurrentGameTime");
        manager.currentGraveId = nbt.method_10537("CurrentGrave");
        class_2499 graves = nbt.method_10554("Graves", 10);
        for (class_2520 graveNbt : graves) {
            Grave graveInfo = new Grave();
            graveInfo.readNbt((class_2487)graveNbt, lookup, dataFixer, dataVersion, class_155.method_16673().method_37912().method_38494());
            manager.add(graveInfo);
        }
        return manager;
    }

    public Collection<Grave> getByUuid(UUID uuid) {
        Set<Grave> graveInfoList = this.byUuid.get(uuid);
        if (graveInfoList != null) {
            graveInfoList.removeIf(Grave::shouldNaturallyBreak);
            return graveInfoList;
        }
        return Collections.emptyList();
    }

    public Grave getId(long id) {
        return (Grave)this.byId.get(id);
    }

    public Grave getByLocation(Location location) {
        return this.byLocation.get(location);
    }

    @ApiStatus.Internal
    public void moveToLocation(Grave grave, Location location) {
        this.byLocation.remove(grave.getLocation());
        this.byLocation.put(location, grave);
    }

    public Grave getByLocation(class_2960 world, class_2338 pos) {
        return this.getByLocation(new Location(world, pos.method_10062()));
    }

    public Grave getByLocation(class_1937 world, class_2338 pos) {
        return this.getByLocation(new Location(world.method_27983().method_29177(), pos.method_10062()));
    }

    public Collection<Grave> getAll() {
        return this.graves;
    }

    public void tick(MinecraftServer server) {
        ++this.ticker;
        if (this.ticker >= 20L) {
            this.ticker = 0L;
            ++this.currentGameTime;
            this.protectionTime = GraveGameRules.getProtectionTime(server);
            this.breakingTime = GraveGameRules.getBreakingTime(server);
            try {
                for (Grave grave : this.graves.toArray(new Grave[0])) {
                    grave.tick(server);
                }
            }
            catch (Exception e) {
                GravesMod.LOGGER.error("Failed to tick grave!", (Throwable)e);
            }
        }
    }

    public long getCurrentGameTime() {
        return this.currentGameTime;
    }

    public long requestId() {
        return this.currentGraveId++;
    }

    public int getProtectionTime() {
        return this.protectionTime;
    }

    public boolean isProtectionEnabled() {
        return this.protectionTime != 0;
    }

    public int getBreakingTime() {
        return this.breakingTime;
    }

    public Collection<Grave> getByPlayer(class_3222 player) {
        return this.getByUuid(player.method_5667());
    }

    public void setServer(MinecraftServer server) {
        this.protectionTime = GraveGameRules.getProtectionTime(server);
        this.breakingTime = GraveGameRules.getBreakingTime(server);
    }
}

