/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.inventory;

import com.tom.storagemod.StorageModComponents;
import com.tom.storagemod.inventory.BlockFilter;
import com.tom.storagemod.inventory.BlockFilterComponent;
import com.tom.storagemod.inventory.IInventoryAccess;
import com.tom.storagemod.inventory.IProxy;
import com.tom.storagemod.inventory.InventoryChangeTracker;
import com.tom.storagemod.util.IValidInfo;
import com.tom.storagemod.util.WorldStates;
import java.util.Set;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public interface PlatformInventoryAccess
extends IInventoryAccess {
    public static final PlatformInventoryAccess EMPTY = new PlatformInventoryAccess(){

        @Override
        public IInventoryAccess.IInventoryChangeTracker tracker() {
            return InventoryChangeTracker.NULL;
        }

        @Override
        public Storage<ItemVariant> get() {
            return Storage.empty();
        }

        @Override
        public class_1799 pullMatchingStack(class_1799 st, long max) {
            return class_1799.field_8037;
        }

        @Override
        public class_1799 pushStack(class_1799 stack) {
            return stack;
        }

        @Override
        public int getFreeSlotCount() {
            return 0;
        }

        @Override
        public IInventoryAccess getRootHandler(Set<IProxy> dejaVu) {
            return this;
        }
    };

    public Storage<ItemVariant> get();

    @Override
    default public int getFreeSlotCount() {
        Storage<ItemVariant> h = this.get();
        if (h == null) {
            return 0;
        }
        int em = 0;
        for (StorageView slot : h) {
            if (!slot.isResourceBlank()) continue;
            ++em;
        }
        return em;
    }

    @Override
    default public int getSlotCount() {
        Storage<ItemVariant> h = this.get();
        if (h == null) {
            return 0;
        }
        int cnt = 0;
        for (StorageView slot : h) {
            ++cnt;
        }
        return cnt;
    }

    public static BlockFilter getBlockFilterAt(class_1937 level, class_2338 pos, boolean make) {
        class_2586 be = level.method_8321(pos);
        if (be == null) {
            return null;
        }
        return ((BlockFilterComponent)StorageModComponents.BLOCK_FILTER.get((Object)be)).getFilter(make);
    }

    public static void removeBlockFilterAt(class_1937 level, class_2338 pos) {
        class_2586 be = level.method_8321(pos);
        if (be == null) {
            return;
        }
        ((BlockFilterComponent)StorageModComponents.BLOCK_FILTER.get((Object)be)).remove(level, pos);
    }

    public static class BlockInventoryAccess
    implements PlatformInventoryAccess {
        private BlockApiCache<Storage<ItemVariant>, class_2350> cache;
        private class_2350 d;
        private IInventoryAccess.IInventoryChangeTracker.Delegate tracker = new IInventoryAccess.IInventoryChangeTracker.Delegate();
        private long lastCheck;
        private Storage<ItemVariant> storageCache;

        @Override
        public Storage<ItemVariant> get() {
            if (this.cache == null) {
                return null;
            }
            if (this.cache.getWorld().method_8510() == this.lastCheck) {
                return this.storageCache;
            }
            Storage sv = this.cache != null ? (Storage)this.cache.find((Object)this.d) : null;
            this.lastCheck = this.cache.getWorld().method_8510();
            this.storageCache = sv;
            return sv;
        }

        @Override
        public IInventoryAccess.IInventoryChangeTracker tracker() {
            Storage<ItemVariant> itemHandler = this.get();
            if (itemHandler != null) {
                this.tracker.setDelegate(WorldStates.getTracker(itemHandler));
            } else {
                this.tracker.setDelegate(InventoryChangeTracker.NULL);
            }
            return this.tracker;
        }

        public void onLoad(class_1937 level, class_2338 p, class_2350 d, IValidInfo inventoryConnectorBlockEntity) {
            this.cache = BlockApiCache.create((BlockApiLookup)ItemStorage.SIDED, (class_3218)((class_3218)level), (class_2338)p);
            this.d = d;
        }

        public static boolean hasInventoryAt(class_1937 level, class_2338 pos, class_2680 state, class_2350 direction) {
            return ItemStorage.SIDED.find(level, pos, state, null, (Object)direction) != null;
        }

        public boolean exists() {
            return this.get() != null;
        }

        @Override
        public void markInvalid() {
            this.cache = null;
            this.storageCache = null;
        }

        @Override
        public IInventoryAccess getRootHandler(Set<IProxy> dejaVu) {
            Storage<ItemVariant> storage = this.get();
            if (storage instanceof IProxy) {
                IProxy p = (IProxy)storage;
                if (dejaVu.add(p)) {
                    return p.getRootHandler(dejaVu);
                }
                return this;
            }
            return this;
        }

        protected void onInvalid() {
        }
    }
}

