/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.inventory.filter;

import com.tom.storagemod.inventory.StoredItemStack;
import com.tom.storagemod.inventory.filter.ItemPredicate;
import com.tom.storagemod.util.Priority;
import java.util.ArrayList;
import java.util.List;

public interface IFilter {
    public ItemPredicate getItemPred();

    public boolean isKeepLast();

    public Priority getPriority();

    public static class MultiFilter
    implements IFilter,
    ItemPredicate {
        private List<IFilter> filters = new ArrayList<IFilter>();

        public MultiFilter(IFilter ... filters) {
            for (IFilter f : filters) {
                if (f instanceof MultiFilter) {
                    MultiFilter mf = (MultiFilter)f;
                    for (IFilter nf : mf.filters) {
                        this.add(nf);
                    }
                    continue;
                }
                this.add(f);
            }
        }

        private void add(IFilter nf) {
            if (!this.filters.contains(nf)) {
                this.filters.add(nf);
            }
        }

        @Override
        public ItemPredicate getItemPred() {
            return this;
        }

        @Override
        public boolean isKeepLast() {
            for (IFilter f : this.filters) {
                if (!f.isKeepLast()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Priority getPriority() {
            int s = 0;
            for (IFilter f : this.filters) {
                s += f.getPriority().getSorting();
            }
            return Priority.fromSorting(s);
        }

        @Override
        public boolean test(StoredItemStack stack) {
            for (IFilter f : this.filters) {
                if (f.getItemPred().test(stack)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void updateState() {
            for (IFilter f : this.filters) {
                f.getItemPred().updateState();
            }
        }

        public String toString() {
            return this.filters.toString();
        }
    }
}

