/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.screen;

import com.tom.storagemod.menu.InventoryLinkMenu;
import com.tom.storagemod.network.NetworkHandler;
import com.tom.storagemod.screen.IScreen;
import com.tom.storagemod.screen.PlatformContainerScreen;
import com.tom.storagemod.screen.widget.IconButton;
import com.tom.storagemod.screen.widget.ListWidget;
import com.tom.storagemod.screen.widget.ToggleButton;
import com.tom.storagemod.util.IDataReceiver;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_1661;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_5250;
import net.minecraft.class_7919;

public class InventoryLinkScreen
extends PlatformContainerScreen<InventoryLinkMenu>
implements IDataReceiver {
    private static final class_2960 gui = class_2960.method_43902((String)"toms_storage", (String)"textures/gui/inventory_link.png");
    private static final class_2960 privateChannel = class_2960.method_43902((String)"toms_storage", (String)"icons/lock_on");
    private static final class_2960 publicChannel = class_2960.method_43902((String)"toms_storage", (String)"icons/lock_off");
    private class_342 textF;
    private Map<UUID, InventoryLinkMenu.LinkChannel> connections = new HashMap<UUID, InventoryLinkMenu.LinkChannel>();
    private IconButton createBtn;
    private IconButton deleteBtn;
    private ToggleButton publicBtn;
    private List<InventoryLinkMenu.LinkChannel> sortedList = new ArrayList<InventoryLinkMenu.LinkChannel>();
    private ListHandler channelsList;
    protected float currentScroll;
    protected boolean isScrolling;
    protected boolean wasClicking;

    public InventoryLinkScreen(InventoryLinkMenu p_97741_, class_1661 p_97742_, class_2561 p_97743_) {
        super(p_97741_, p_97742_, p_97743_);
    }

    @Override
    public void receive(class_2487 tag) {
        class_2499 list = tag.method_10554("list", 10);
        InventoryLinkMenu.LinkChannel.loadAll(list, this.connections);
        if (tag.method_10545("selected")) {
            UUID sel = tag.method_25926("selected");
            InventoryLinkMenu.LinkChannel selC = this.connections.get(sel);
            if (selC != null) {
                this.channelsList.setSelected(selC);
                this.textF.method_1852(selC.displayName);
            } else {
                this.channelsList.setSelected(null);
            }
        } else {
            this.channelsList.setSelected(null);
        }
        Comparator<InventoryLinkMenu.LinkChannel> cmp = Comparator.comparing(e -> e.publicChannel);
        cmp = cmp.thenComparing(e -> e.displayName);
        this.sortedList = this.connections.values().stream().sorted(cmp).collect(Collectors.toList());
        this.update();
    }

    protected void method_2389(class_332 matrixStack, float partialTicks, int x, int y) {
        int i = (this.field_22789 - this.field_2792) / 2;
        int j = (this.field_22790 - this.field_2779) / 2;
        matrixStack.method_25302(gui, i, j, 0, 0, this.field_2792, this.field_2779);
    }

    protected void method_2388(class_332 st, int p_97809_, int p_97810_) {
        st.method_51439(this.field_22793, this.field_22785, this.field_25267, this.field_25268, 0x404040, false);
        st.method_51433(this.field_22793, class_1074.method_4662((String)"label.toms_storage.inventory_connector.beacon_level", (Object[])new Object[]{((InventoryLinkMenu)this.field_2797).beaconLvl}), this.field_25267, this.field_25268 + 10, 0x404040, false);
    }

    protected void method_25426() {
        this.method_37067();
        super.method_25426();
        this.createBtn = (IconButton)this.method_37063((class_364)new IconButton(this.field_2776 + 121, this.field_2800 + 24, (class_2561)class_2561.method_43471((String)""), class_2960.method_43902((String)"toms_storage", (String)"icons/add"), b -> {
            String name = this.textF.method_1882().trim();
            if (!name.isEmpty()) {
                this.sendEdit(null, new InventoryLinkMenu.LinkChannel(this.publicBtn.getState(), name));
            }
        }));
        this.deleteBtn = (IconButton)this.method_37063((class_364)new IconButton(this.field_2776 + 138, this.field_2800 + 24, (class_2561)class_2561.method_43471((String)""), class_2960.method_43902((String)"toms_storage", (String)"icons/deny"), b -> this.sendEdit((InventoryLinkMenu.LinkChannel)this.channelsList.getSelected(), null)));
        this.publicBtn = (ToggleButton)this.method_37063((class_364)ToggleButton.builder(this.field_2776 + 155, this.field_2800 + 24).iconOff(privateChannel).iconOn(publicChannel).build(s -> {
            InventoryLinkMenu.LinkChannel sel = (InventoryLinkMenu.LinkChannel)this.channelsList.getSelected();
            if (sel != null && sel.owner.equals(this.field_22787.field_1724.method_5667())) {
                sel.publicChannel = s;
                this.sendEdit(sel, sel);
            }
        }));
        this.publicBtn.setTooltip(class_7919.method_47407((class_2561)class_2561.method_43471((String)"tooltip.toms_storage.inv_link.private")), class_7919.method_47407((class_2561)class_2561.method_43471((String)"tooltip.toms_storage.inv_link.public")));
        this.channelsList = new ListHandler(this.field_2776 + 12, this.field_2800 + 42);
        this.channelsList.setList(() -> this.sortedList);
        this.method_37063((class_364)this.channelsList);
        Objects.requireNonNull(this.field_22793);
        this.textF = new class_342(this.field_22793, this.field_2776 + 13, this.field_2800 + 28, 105, 9, (class_2561)class_2561.method_43471((String)"narrator.toms_storage.inventory_link_channel"));
        this.textF.method_1880(50);
        this.textF.method_1858(false);
        this.textF.method_1862(true);
        this.textF.method_1868(0xFFFFFF);
        this.textF.method_1852("");
        this.textF.method_1863(t -> {
            this.channelsList.setSelected(null);
            for (Map.Entry<UUID, InventoryLinkMenu.LinkChannel> e : this.connections.entrySet()) {
                if (!e.getValue().displayName.equals(t)) continue;
                this.channelsList.setSelected(e.getValue());
                break;
            }
            this.update();
        });
        this.method_37063((class_364)this.textF);
        this.update();
    }

    private void sendEdit(InventoryLinkMenu.LinkChannel id, InventoryLinkMenu.LinkChannel ch) {
        class_2487 tag = new class_2487();
        if (id != null) {
            tag.method_25927("id", id.id);
        }
        if (ch != null) {
            ch.saveToServer(tag);
        }
        NetworkHandler.sendDataToServer(tag);
    }

    private void sendSelect(UUID id) {
        class_2487 tag = new class_2487();
        tag.method_25927("id", id);
        tag.method_10556("select", true);
        NetworkHandler.sendDataToServer(tag);
    }

    private void update() {
        InventoryLinkMenu.LinkChannel sel = (InventoryLinkMenu.LinkChannel)this.channelsList.getSelected();
        if (sel != null) {
            boolean owner;
            this.deleteBtn.field_22763 = true;
            this.publicBtn.setState(sel.publicChannel);
            this.publicBtn.field_22763 = owner = sel.owner.equals(this.field_22787.field_1724.method_5667());
            this.createBtn.field_22763 = false;
        } else {
            this.deleteBtn.field_22763 = false;
            this.publicBtn.setState(false);
            this.createBtn.field_22763 = !this.textF.method_1882().trim().isEmpty();
        }
    }

    public void method_25394(class_332 st, int mouseX, int mouseY, float partialTicks) {
        this.channelsList.preRender(mouseX, mouseY);
        super.method_25394(st, mouseX, mouseY, partialTicks);
        this.method_2380(st, mouseX, mouseY);
        this.channelsList.tooltip(st, mouseX, mouseY);
    }

    public boolean method_25404(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            this.method_25419();
            return true;
        }
        if (p_keyPressed_1_ == 258) {
            return super.method_25404(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
        }
        return !this.textF.method_25404(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) && !this.textF.method_20315() ? super.method_25404(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) : true;
    }

    public boolean method_25400(char p_charTyped_1_, int p_charTyped_2_) {
        if (this.textF.method_25400(p_charTyped_1_, p_charTyped_2_)) {
            return true;
        }
        return super.method_25400(p_charTyped_1_, p_charTyped_2_);
    }

    @Override
    public void getExclusionAreas(Consumer<IScreen.Box> consumer) {
    }

    public class ListHandler
    extends ListWidget<InventoryLinkMenu.LinkChannel> {
        public ListHandler(int x, int y) {
            super(x, y, 114, 100, 16, (class_2561)class_2561.method_43473());
        }

        @Override
        protected class_327 getFont() {
            return InventoryLinkScreen.this.field_22793;
        }

        @Override
        protected void addButton(class_339 btn) {
            InventoryLinkScreen.this.method_37063((class_364)btn);
        }

        @Override
        protected class_2561 toComponent(InventoryLinkMenu.LinkChannel data) {
            return class_2561.method_43470((String)data.displayName);
        }

        @Override
        protected void renderTooltip(class_332 graphics, InventoryLinkMenu.LinkChannel data, int mouseX, int mouseY) {
            ArrayList<class_5250> tt = new ArrayList<class_5250>();
            if (!data.ownerName.isEmpty()) {
                boolean owner = data.owner.equals(((InventoryLinkScreen)InventoryLinkScreen.this).field_22787.field_1724.method_5667());
                tt.add(class_2561.method_43469((String)("tooltip.toms_storage.inventory_connector.channel.owner" + (owner ? ".self" : "")), (Object[])new Object[]{data.ownerName}));
            } else {
                tt.add(class_2561.method_43471((String)"tooltip.toms_storage.inventory_connector.channel.owner.unknown"));
            }
            tt.add(class_2561.method_43471((String)("tooltip.toms_storage.inv_link." + (data.publicChannel ? "public" : "private"))));
            graphics.method_51437(InventoryLinkScreen.this.field_22793, tt, Optional.empty(), mouseX, mouseY);
        }

        @Override
        protected void renderEntry(class_332 st, int x, int y, int width, int height, InventoryLinkMenu.LinkChannel id, int mouseX, int mouseY, float pt) {
            st.method_52706(id.publicChannel ? publicChannel : privateChannel, x + width - 16, y, 16, 16);
        }

        @Override
        protected void selectionChanged(InventoryLinkMenu.LinkChannel to) {
            InventoryLinkScreen.this.sendSelect(to.id);
            InventoryLinkScreen.this.update();
        }
    }
}

