/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.config.entity;

import com.tristankechlo.livingthings.config.util.EntityConfig;
import com.tristankechlo.livingthings.config.util.SpawnData;
import com.tristankechlo.livingthings.config.values.BooleanValue;
import com.tristankechlo.livingthings.config.values.ListValue;
import com.tristankechlo.livingthings.config.values.NumberValue;
import java.util.List;
import net.minecraft.class_1972;
import net.minecraft.class_5321;

public final class MonkeyConfig
extends EntityConfig {
    private static final MonkeyConfig INSTANCE = new MonkeyConfig();
    public final BooleanValue canAttack = new BooleanValue("canAttack", true);
    public final NumberValue.DoubleValue health = new NumberValue.DoubleValue("health", 6.0, 1.0, 1024.0);
    public final NumberValue.DoubleValue movementSpeed = new NumberValue.DoubleValue("movementSpeed", 0.23, 0.0, 1024.0);
    public final NumberValue.DoubleValue attackDamage = new NumberValue.DoubleValue("attackDamage", 3.0, 0.0, 2048.0);
    public final NumberValue.IntegerValue maxSpawnedInChunk = new NumberValue.IntegerValue("maxSpawnedInChunk", 7, 1, 15);
    public final ListValue<SpawnData> spawnBiomes = new ListValue<SpawnData>("spawnBiomes", MonkeyConfig.createDefaultSpawns(), SpawnData::serialize, SpawnData::deserialize);

    private MonkeyConfig() {
        super("monkey");
        this.registerConfigValues(this.canAttack, this.health, this.movementSpeed, this.attackDamage, this.maxSpawnedInChunk, this.spawnBiomes);
    }

    public static MonkeyConfig get() {
        return INSTANCE;
    }

    public static boolean canAttack() {
        return MonkeyConfig.INSTANCE.canAttack.get();
    }

    public static double health() {
        return (Double)MonkeyConfig.INSTANCE.health.get();
    }

    public static double movementSpeed() {
        return (Double)MonkeyConfig.INSTANCE.movementSpeed.get();
    }

    public static double attackDamage() {
        return (Double)MonkeyConfig.INSTANCE.attackDamage.get();
    }

    public static int maxSpawnedInChunk() {
        return (Integer)MonkeyConfig.INSTANCE.maxSpawnedInChunk.get();
    }

    private static List<SpawnData> createDefaultSpawns() {
        return List.of(new SpawnData(50, 4, 7, new class_5321[]{class_1972.field_9417, class_1972.field_35114, class_1972.field_35118}), new SpawnData(25, 4, 7, new class_5321[]{class_1972.field_9440}));
    }
}

