/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.config.entity;

import com.tristankechlo.livingthings.config.util.EntityConfig;
import com.tristankechlo.livingthings.config.util.SpawnData;
import com.tristankechlo.livingthings.config.values.BooleanValue;
import com.tristankechlo.livingthings.config.values.ListValue;
import com.tristankechlo.livingthings.config.values.NumberValue;
import java.util.List;
import net.minecraft.class_1972;
import net.minecraft.class_5321;

public final class RaccoonConfig
extends EntityConfig {
    private static final RaccoonConfig INSTANCE = new RaccoonConfig();
    public final BooleanValue canAttack = new BooleanValue("canAttack", true);
    public final NumberValue.DoubleValue health = new NumberValue.DoubleValue("health", 10.0, 1.0, 1024.0);
    public final NumberValue.DoubleValue movementSpeed = new NumberValue.DoubleValue("movementSpeed", 0.23, 0.0, 1024.0);
    public final NumberValue.DoubleValue attackDamage = new NumberValue.DoubleValue("attackDamage", 2.0, 0.0, 2048.0);
    public final NumberValue.IntegerValue maxSpawnedInChunk = new NumberValue.IntegerValue("maxSpawnedInChunk", 6, 1, 15);
    public final ListValue<SpawnData> spawnBiomes = new ListValue<SpawnData>("spawnBiomes", RaccoonConfig.createDefaultSpawns(), SpawnData::serialize, SpawnData::deserialize);

    private RaccoonConfig() {
        super("raccoon");
        this.registerConfigValues(this.canAttack, this.health, this.movementSpeed, this.attackDamage, this.maxSpawnedInChunk, this.spawnBiomes);
    }

    public static RaccoonConfig get() {
        return INSTANCE;
    }

    public static boolean canAttack() {
        return RaccoonConfig.INSTANCE.canAttack.get();
    }

    public static double health() {
        return (Double)RaccoonConfig.INSTANCE.health.get();
    }

    public static double movementSpeed() {
        return (Double)RaccoonConfig.INSTANCE.movementSpeed.get();
    }

    public static double attackDamage() {
        return (Double)RaccoonConfig.INSTANCE.attackDamage.get();
    }

    public static int maxSpawnedInChunk() {
        return (Integer)RaccoonConfig.INSTANCE.maxSpawnedInChunk.get();
    }

    private static List<SpawnData> createDefaultSpawns() {
        return List.of(new SpawnData(16, 2, 5, new class_5321[]{class_1972.field_9451, class_1972.field_9409, class_1972.field_9412, class_1972.field_35112, class_1972.field_9455, class_1972.field_9475, class_1972.field_9414, class_1972.field_42720}));
    }
}

