/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.tristankechlo.livingthings.config.entity.ElephantConfig;
import com.tristankechlo.livingthings.entity.ai.BetterMeleeAttackGoal;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.init.ModItems;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1707;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1920;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_4048;
import net.minecraft.class_4051;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5398;
import net.minecraft.class_5819;
import net.minecraft.class_6019;
import net.minecraft.class_7225;
import net.minecraft.class_7248;
import net.minecraft.class_747;
import net.minecraft.class_9331;
import net.minecraft.class_9701;

public class ElephantEntity
extends class_1321
implements class_5354,
class_7248,
ILexiconEntry {
    public static final int ANGER_TIME = 10;
    private static final class_6019 rangedInteger = class_4802.method_24505((int)20, (int)39);
    private static class_2561 CONTAINER_NAME = null;
    private static final class_2940<Boolean> IS_SADDLED = class_2945.method_12791(ElephantEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> HAS_CHEST = class_2945.method_12791(ElephantEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> REMAINING_ANGER_TIME = class_2945.method_12791(ElephantEntity.class, (class_2941)class_2943.field_13327);
    protected class_1277 entityInventory;
    private int tameAmount;
    private int attackTimer;
    private UUID angerTarget;

    public ElephantEntity(class_1299<ElephantEntity> entityType, class_1937 worldIn) {
        super(entityType, worldIn);
        this.initInventory();
        this.tameAmount = 0;
    }

    public static boolean checkElephantSpawnRules(class_1299<ElephantEntity> animal, class_1936 world, class_3730 reason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_26164(LivingThingsTags.ELEPHANT_SPAWNABLE_ON) && ElephantEntity.method_39448((class_1920)world, (class_2338)pos);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(IS_SADDLED, (Object)false);
        builder.method_56912(HAS_CHEST, (Object)false);
        builder.method_56912(REMAINING_ANGER_TIME, (Object)0);
    }

    public class_1296 method_5613(class_3218 world, class_1296 parent) {
        ElephantEntity child = (ElephantEntity)ModEntityTypes.ELEPHANT.get().method_5883(this.method_37908());
        if (this.method_6181() || ((ElephantEntity)parent).method_6181()) {
            child.method_6173(true, false);
        }
        return child;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, ElephantConfig.health()).method_26868(class_5134.field_23719, ElephantConfig.movementSpeed()).method_26868(class_5134.field_23717, 16.0).method_26868(class_5134.field_23721, ElephantConfig.attackDamage());
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new BetterMeleeAttackGoal((class_1314)this, 1.2, false, ElephantConfig::canAttack));
        this.field_6201.method_6277(2, (class_1352)new class_1394((class_1314)this, 0.9));
        this.field_6201.method_6277(3, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(4, (class_1352)new class_1353((class_1429)this, 0.95));
        this.field_6201.method_6277(5, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(0, (class_1352)new NewHurtByTargetGoal((class_1314)this));
        this.field_6185.method_6277(1, (class_1352)new class_5398((class_1308)this, true));
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.method_29512(this.method_37908(), compound);
        this.setSaddled(compound.method_10577("Saddled"));
        this.setHasChest(compound.method_10577("Chested"));
        this.method_6173(compound.method_10577("Tamed"), false);
        this.tameAmount = compound.method_10550("TameAmount");
        this.entityInventory.method_7659(compound.method_10554("Inventory", 10), (class_7225.class_7874)this.method_56673());
        this.initInventory();
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        this.method_29517(compound);
        compound.method_10556("Saddled", this.isSaddled());
        compound.method_10556("Chested", this.hasChest());
        compound.method_10556("Tamed", this.method_6181());
        compound.method_10569("TameAmount", this.tameAmount);
        compound.method_10566("Inventory", (class_2520)this.entityInventory.method_7660((class_7225.class_7874)this.method_56673()));
    }

    private void initInventory() {
        class_1277 inventory = this.entityInventory;
        this.entityInventory = new class_1277(27);
        if (inventory == null) {
            return;
        }
        int invSize = Math.min(inventory.method_5439(), this.entityInventory.method_5439());
        for (int i = 0; i < invSize; ++i) {
            class_1799 itemstack = inventory.method_5438(i);
            if (itemstack.method_7960()) continue;
            this.entityInventory.method_5447(i, itemstack.method_7972());
        }
    }

    private void openInventory(class_1657 player) {
        if (!this.hasChest()) {
            return;
        }
        if (CONTAINER_NAME == null) {
            CONTAINER_NAME = ModEntityTypes.ELEPHANT.get().method_5897();
        }
        player.method_17355((class_3908)new class_747((id, playerInv, playerIn) -> new class_1707(class_3917.field_17326, id, player.method_31548(), (class_1263)this.entityInventory, 3), CONTAINER_NAME));
    }

    public void method_6722(class_1657 player) {
        this.openInventory(player);
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(LivingThingsTags.ELEPHANT_FOOD);
    }

    public boolean method_6121(class_1297 target) {
        this.method_37908().method_8421((class_1297)this, (byte)4);
        boolean flag = super.method_6121(target);
        if (flag) {
            target.method_18799(target.method_18798().method_1031(0.0, 0.7, 0.0));
        }
        return flag;
    }

    public void method_5773() {
        super.method_5773();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
    }

    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().field_9236) {
            this.method_29510((class_3218)this.method_37908(), true);
        }
    }

    public int method_5945() {
        return ElephantConfig.maxSpawnedInChunk();
    }

    protected class_243 method_52533(class_1297 rider, class_4048 dimensions, float scale) {
        return new class_243(0.0, (double)(dimensions.comp_2186() * 0.975f * scale), 0.0);
    }

    protected class_3414 method_5994() {
        return ModSounds.ELEPHANT_AMBIENT.get();
    }

    protected class_3414 method_6011(class_1282 source) {
        return ModSounds.ELEPHANT_HURT.get();
    }

    protected class_3414 method_6002() {
        return ModSounds.ELEPHANT_DEATH.get();
    }

    public void method_5711(byte id) {
        switch (id) {
            case 4: {
                this.attackTimer = 10;
                break;
            }
            case 6: {
                this.spawnParticle((class_2394)class_2398.field_11208);
                this.spawnParticle((class_2394)class_2398.field_11248);
                break;
            }
            case 7: {
                this.spawnParticle((class_2394)class_2398.field_17741);
                break;
            }
            default: {
                super.method_5711(id);
            }
        }
    }

    private void spawnParticle(class_2394 particle) {
        if (particle != null) {
            for (int i = 0; i < 10; ++i) {
                double d0 = this.field_5974.method_43059() * 0.03;
                double d1 = this.field_5974.method_43059() * 0.03;
                double d2 = this.field_5974.method_43059() * 0.03;
                this.method_37908().method_8406(particle, this.method_23322(1.5), this.method_23319() + 0.5, this.method_23325(1.5), d0, d1, d2);
            }
        }
    }

    private void doPlayerRide(class_1657 player) {
        if (!this.method_37908().method_8608()) {
            player.method_36456(this.method_36454());
            player.method_36457(this.method_36455());
            player.method_5804((class_1297)this);
        }
    }

    protected boolean method_6062() {
        return super.method_6062() && this.method_5782();
    }

    protected void method_16078() {
        super.method_16078();
        if (this.entityInventory != null) {
            for (int i = 0; i < this.entityInventory.method_5439(); ++i) {
                class_1799 itemstack = this.entityInventory.method_5438(i);
                if (itemstack.method_7960() || class_1890.method_60142((class_1799)itemstack, (class_9331)class_9701.field_51655)) continue;
                this.method_5775(itemstack);
            }
        }
        if (this.isSaddled() && this.field_5974.method_43056()) {
            this.method_5706((class_1935)class_1802.field_8175);
        }
        if (this.hasChest() && this.field_5974.method_43056()) {
            this.method_5706((class_1935)class_1802.field_8106);
        }
    }

    public void method_6091(class_243 travelVector) {
        if (this.method_5805()) {
            if (this.method_5782() && this.method_5787() && this.isSaddled()) {
                class_1309 livingentity = this.method_5642();
                this.method_36456(livingentity.method_36454());
                this.field_5982 = this.method_36454();
                this.method_36457(livingentity.method_36455() * 0.5f);
                this.method_5710(this.method_36454(), this.method_36455());
                this.field_6241 = this.field_6283 = this.method_36454();
                float sideSpeed = livingentity.field_6212 * 0.4f;
                float forwardSpeed = livingentity.field_6250 * 0.7f;
                if (forwardSpeed <= 0.0f) {
                    forwardSpeed *= 0.2f;
                }
                if (this.method_5787()) {
                    this.method_6125((float)this.method_45325(class_5134.field_23719));
                    super.method_6091(new class_243((double)sideSpeed, travelVector.field_1351, (double)forwardSpeed));
                } else if (livingentity instanceof class_1657) {
                    this.method_18799(class_243.field_1353);
                }
                this.method_29242(false);
            } else {
                super.method_6091(travelVector);
            }
        }
    }

    public boolean isTamingItem(class_1799 stack) {
        return stack.method_31573(LivingThingsTags.ELEPHANT_TAMING_FOOD);
    }

    public class_1309 method_5642() {
        class_1297 passenger = this.method_31483();
        if (passenger instanceof class_1657) {
            return (class_1657)passenger;
        }
        return null;
    }

    public boolean isSaddled() {
        return (Boolean)this.field_6011.method_12789(IS_SADDLED);
    }

    public void setSaddled(boolean saddled) {
        this.field_6011.method_12778(IS_SADDLED, (Object)saddled);
    }

    public boolean hasChest() {
        return (Boolean)this.field_6011.method_12789(HAS_CHEST);
    }

    public void setHasChest(boolean chested) {
        this.field_6011.method_12778(HAS_CHEST, (Object)chested);
    }

    public int getAttackTimer() {
        return this.attackTimer;
    }

    public int method_29507() {
        return (Integer)this.field_6011.method_12789(REMAINING_ANGER_TIME);
    }

    public void method_29514(int time) {
        this.field_6011.method_12778(REMAINING_ANGER_TIME, (Object)time);
    }

    public UUID method_29508() {
        return this.angerTarget;
    }

    public void method_29513(UUID target) {
        this.angerTarget = target;
    }

    public void method_29509() {
        this.method_29514(rangedInteger.method_35008(this.field_5974));
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_6047();
        if (stack.method_31574(ModItems.LEXICON.get())) {
            return class_1269.field_5811;
        }
        if (stack.method_7960() && this.method_6181() && !this.method_6109()) {
            if (player.method_18276() && this.hasChest()) {
                this.openInventory(player);
            } else if (this.method_5685().isEmpty() && this.isSaddled()) {
                this.doPlayerRide(player);
            }
            return class_1269.method_29236((boolean)this.method_37908().method_8608());
        }
        if (this.method_6481(stack)) {
            if (this.method_6109()) {
                int age = this.method_5618();
                this.method_6475(player, hand, stack);
                this.method_5620((int)((float)(-age / 20) * 0.1f), true);
                return class_1269.method_29236((boolean)this.method_37908().method_8608());
            }
            if (this.method_6181()) {
                if (this.method_6032() < this.method_6063()) {
                    if (!this.method_37908().method_8608()) {
                        float healAmount = 3.0f;
                        this.method_6025(healAmount);
                        this.method_6475(player, hand, stack);
                        return class_1269.field_5812;
                    }
                } else if (!this.method_37908().method_8608() && !this.method_6109() && this.method_19184()) {
                    this.method_6475(player, hand, stack);
                    this.method_6480(player);
                    return class_1269.field_5812;
                }
                return class_1269.method_29236((boolean)this.method_37908().method_8608());
            }
        } else {
            if (this.isTamingItem(stack) && !this.method_6109() && !this.method_6181()) {
                if (!this.method_37908().method_8608()) {
                    this.tameAmount += 200;
                    this.method_6475(player, hand, stack);
                    if (this.tameAmount >= 1000) {
                        this.method_6173(true, true);
                        this.method_6174(player.method_5667());
                        if (player instanceof class_3222) {
                            class_174.field_1201.method_9132((class_3222)player, (class_1429)this);
                        }
                        this.method_37908().method_8421((class_1297)this, (byte)6);
                    } else {
                        this.method_37908().method_8421((class_1297)this, (byte)7);
                    }
                }
                return class_1269.field_5812;
            }
            if (this.method_6181() && stack.method_31574(class_1802.field_8175) && !this.method_6109() && !this.isSaddled()) {
                if (!this.method_37908().method_8608()) {
                    this.method_6475(player, hand, stack);
                    this.setSaddled(true);
                    this.method_5783(ModSounds.ELEPHANT_EQUIP_SADDLE.get(), 0.9f, 0.9f);
                }
                return class_1269.method_29236((boolean)this.method_37908().method_8608());
            }
            if (this.method_6181() && this.isSaddled() && stack.method_31574(class_1802.field_8106) && !this.method_6109() && !this.hasChest()) {
                if (!this.method_37908().method_8608()) {
                    this.method_6475(player, hand, stack);
                    this.setHasChest(true);
                    this.method_5783(ModSounds.ELEPHANT_EQUIP_CHEST.get(), 0.9f, 0.9f);
                }
                return class_1269.method_29236((boolean)this.method_37908().method_8608());
            }
        }
        return class_1269.field_5811;
    }

    public boolean method_19184() {
        return this.method_6482();
    }

    @Override
    public class_2960 getLexiconEntry() {
        return LexiconEntries.ELEPHANT;
    }

    private static class NewHurtByTargetGoal
    extends class_1399 {
        public NewHurtByTargetGoal(class_1314 creatureIn) {
            super(creatureIn, new Class[0]);
        }

        protected boolean method_6328(class_1309 entity, class_4051 conditions) {
            UUID ownerID;
            if (entity instanceof class_1657 && (ownerID = ((ElephantEntity)this.field_6660).method_6139()) != null && entity.method_5667().equals(ownerID)) {
                return false;
            }
            return super.method_6328(entity, conditions);
        }
    }
}

