/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.tristankechlo.livingthings.config.entity.OwlConfig;
import com.tristankechlo.livingthings.entity.misc.IMobVariants;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.Ingredients;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1331;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1348;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1386;
import net.minecraft.class_1391;
import net.minecraft.class_1395;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1432;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7;

public class OwlEntity
extends class_1321
implements class_1432,
IMobVariants,
ILexiconEntry {
    private static final class_2940<Byte> OWL_VARIANT = class_2945.method_12791(OwlEntity.class, (class_2941)class_2943.field_13319);
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    private float flapping = 1.0f;

    public OwlEntity(class_1299<? extends OwlEntity> type, class_1937 worldIn) {
        super(type, worldIn);
        this.field_6207 = new class_1331((class_1308)this, 10, false);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_3, -1.0f);
    }

    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        OwlEntity child = (OwlEntity)ModEntityTypes.OWL.get().method_5883((class_1937)world);
        UUID uuid = this.method_6139();
        if (uuid == null && entity instanceof class_1321) {
            uuid = ((class_1321)entity).method_6139();
        }
        if (uuid != null) {
            child.method_6174(uuid);
            child.method_6173(true, false);
        }
        child.setVariant(this.getVariantFromParents((class_1296)this, entity));
        return child;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, OwlConfig.health()).method_26868(class_5134.field_23719, OwlConfig.movementSpeed()).method_26868(class_5134.field_23720, OwlConfig.flyingSpeed());
    }

    public class_1315 method_5943(class_5425 worldIn, class_1266 difficultyIn, class_3730 reason, class_1315 spawnDataIn) {
        int colorBrownWeight = (Integer)OwlConfig.get().colorBrownWeight.get();
        int colorWhiteWeight = (Integer)OwlConfig.get().colorWhiteWeight.get();
        int colorBlackWeight = (Integer)OwlConfig.get().colorBlackWeight.get();
        byte variant = this.getRandomVariant(this.field_5974, new byte[]{0, 1, 2}, new int[]{colorBrownWeight, colorWhiteWeight, colorBlackWeight});
        this.setVariant(variant);
        return super.method_5943(worldIn, difficultyIn, reason, spawnDataIn);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1374((class_1314)this, 1.25));
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.0, (Predicate)Ingredients.OWL_FOOD, false));
        this.field_6201.method_6277(4, (class_1352)new class_1353((class_1429)this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new class_1350((class_1321)this, 1.0, 5.0f, 1.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1395((class_1314)this, 1.0));
        this.field_6201.method_6277(8, (class_1352)new class_1348((class_1308)this, 1.0, 3.0f, 7.0f));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(OWL_VARIANT, (Object)0);
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10545("OwlVariant")) {
            this.setVariant(compound.method_10571("OwlVariant"));
        } else {
            this.setVariant((byte)0);
        }
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10567("OwlVariant", this.getVariant());
    }

    public void method_6007() {
        super.method_6007();
        this.calculateFlapping();
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!this.method_6181() && this.method_6481(stack)) {
            this.method_6475(player, hand, stack);
            if (this.field_5974.method_43048(5) == 0) {
                this.method_6170(player);
                this.method_24346(true);
                this.method_37908().method_8421((class_1297)this, (byte)7);
            } else {
                this.method_37908().method_8421((class_1297)this, (byte)6);
            }
            return class_1269.method_29236((boolean)this.method_37908().method_8608());
        }
        if (this.method_6181() && !this.method_6581()) {
            class_1269 result = super.method_5992(player, hand);
            if ((!result.method_23665() || this.method_6109()) && this.method_6171((class_1309)player)) {
                this.method_24346(!this.method_24345());
                return class_1269.field_5812;
            }
            return result;
        }
        return class_1269.field_5811;
    }

    private void calculateFlapping() {
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed = (float)((double)this.flapSpeed + (double)(!this.method_24828() && !this.method_5765() ? 4 : -1) * 0.3);
        this.flapSpeed = class_3532.method_15363((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.method_24828() && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping = (float)((double)this.flapping * 0.9);
        class_243 vector3d = this.method_18798();
        if (!this.method_24828() && vector3d.field_1351 < 0.0) {
            this.method_18799(vector3d.method_18805(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
    }

    public static boolean checkOwlSpawnRules(class_1299<OwlEntity> animal, class_1936 world, class_3730 reason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_26164(LivingThingsTags.OWL_SPAWNABLE_ON) && OwlEntity.method_39448((class_1920)world, (class_2338)pos);
    }

    protected class_1408 method_5965(class_1937 worldIn) {
        class_1407 navigation = new class_1407((class_1308)this, worldIn);
        navigation.method_6332(false);
        navigation.method_6354(true);
        navigation.method_6331(true);
        return navigation;
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(LivingThingsTags.OWL_FOOD);
    }

    public int method_5945() {
        return OwlConfig.maxSpawnedInChunk();
    }

    public boolean method_5747(float p_149683_, float p_149684_, class_1282 p_149685_) {
        return false;
    }

    protected class_3414 method_5994() {
        return ModSounds.OWL_AMBIENT.get();
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return ModSounds.OWL_HURT.get();
    }

    protected class_3414 method_6002() {
        return ModSounds.OWL_DEATH.get();
    }

    protected void method_5801() {
        this.method_5783(ModSounds.OWL_FLY.get(), 0.15f, 1.0f);
    }

    protected void method_6087(class_1297 entityIn) {
        if (!(entityIn instanceof class_1657)) {
            super.method_6087(entityIn);
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        this.method_24346(false);
        return super.method_5643(source, amount);
    }

    public boolean method_6581() {
        return !this.method_24828();
    }

    @Override
    public byte getVariant() {
        return (Byte)this.field_6011.method_12789(OWL_VARIANT);
    }

    @Override
    public void setVariant(byte variant) {
        this.field_6011.method_12778(OWL_VARIANT, (Object)variant);
    }

    @Override
    public class_2960 getLexiconEntry() {
        return LexiconEntries.OWL;
    }
}

