/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.cerbons_api.api.block.registry;

import com.cerbon.cerbons_api.api.item.registry.ItemRegistry;
import com.cerbon.cerbons_api.api.registry.RegistryEntry;
import com.cerbon.cerbons_api.api.registry.ResourcefulRegistries;
import com.cerbon.cerbons_api.api.registry.ResourcefulRegistry;
import com.google.common.base.Suppliers;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_4970;
import net.minecraft.class_7923;

public class BlockRegistry {
    private final ResourcefulRegistry<class_2248> blockRegistry;
    private final Supplier<ItemRegistry> itemRegistry;
    private boolean registerItemRegistry = false;

    public BlockRegistry(String modId) {
        this(modId, (Supplier<ItemRegistry>)Suppliers.memoize(() -> new ItemRegistry(modId)));
        this.registerItemRegistry = true;
    }

    public BlockRegistry(String modId, Supplier<ItemRegistry> itemRegistry) {
        this.blockRegistry = ResourcefulRegistries.create(class_7923.field_41175, modId);
        this.itemRegistry = itemRegistry;
    }

    public RegistryEntry<class_2248> registerBlockWithItem(String id) {
        return this.registerBlockWithItem(class_4970.class_2251.method_9637(), id);
    }

    public RegistryEntry<class_2248> registerBlockWithItem(class_4970.class_2251 blockProperties, String id) {
        return this.registerBlockWithItem(blockProperties, new class_1792.class_1793(), id);
    }

    public RegistryEntry<class_2248> registerBlockWithItem(class_4970.class_2251 blockProperties, class_1792.class_1793 itemProperties, String id) {
        Supplier<class_2248> block = () -> new class_2248(blockProperties);
        RegistryEntry<class_2248> blockEntry = this.registerBlock(block, id);
        this.itemRegistry.get().registerBlockItem(blockEntry, itemProperties, id);
        return blockEntry;
    }

    public RegistryEntry<class_2248> registerBlockWithItem(Supplier<class_2248> block, class_1792.class_1793 itemProperties, String id) {
        RegistryEntry<class_2248> blockEntry = this.registerBlock(block, id);
        this.itemRegistry.get().registerBlockItem(blockEntry, itemProperties, id);
        return blockEntry;
    }

    public RegistryEntry<class_2248> registerBlockWithItem(Supplier<class_2248> block, String id) {
        RegistryEntry<class_2248> blockEntry = this.registerBlock(block, id);
        this.itemRegistry.get().registerBlockItem(blockEntry, id);
        return blockEntry;
    }

    public RegistryEntry<class_2248> registerBlock(String id) {
        return this.registerBlock(class_4970.class_2251.method_9637(), id);
    }

    public RegistryEntry<class_2248> registerBlock(class_4970.class_2251 blockProperties, String id) {
        return this.registerBlock(() -> new class_2248(blockProperties), id);
    }

    public <T extends class_2248> RegistryEntry<T> registerBlock(Supplier<T> block, String id) {
        return this.blockRegistry.register(id, block);
    }

    public Collection<RegistryEntry<class_2248>> getEntries() {
        return this.blockRegistry.getEntries();
    }

    public Stream<RegistryEntry<class_2248>> stream() {
        return this.blockRegistry.stream();
    }

    public Stream<class_2248> boundStream() {
        return this.blockRegistry.boundStream();
    }

    public void register() {
        this.blockRegistry.register();
        if (this.registerItemRegistry) {
            this.itemRegistry.get().register();
        }
    }
}

