/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.cerbons_api.api.general.particle;

import com.cerbon.cerbons_api.api.general.particle.SimpleParticle;
import com.cerbon.cerbons_api.api.static_utilities.RandomUtils;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_703;

public class ClientParticleBuilder {
    private final class_2394 options;
    private Function<SimpleParticle, class_243> getVel;
    private Function<SimpleParticle, class_243> continuousPos;
    private Function<Float, class_243> color;
    private Function<Float, Integer> brightness;
    private Function<Float, Float> scale;
    private Supplier<Integer> age;
    private Function<SimpleParticle, Float> getRotation;
    private Double colorVariation;

    public ClientParticleBuilder(class_2394 options) {
        this.options = options;
    }

    public ClientParticleBuilder continuousRotation(Function<SimpleParticle, Float> rotation) {
        this.getRotation = rotation;
        return this;
    }

    public ClientParticleBuilder continuousVelocity(Function<SimpleParticle, class_243> velocity) {
        this.getVel = velocity;
        return this;
    }

    public ClientParticleBuilder continuousPosition(Function<SimpleParticle, class_243> positionProvider) {
        this.continuousPos = positionProvider;
        return this;
    }

    public ClientParticleBuilder color(Function<Float, class_243> color) {
        this.color = color;
        return this;
    }

    public ClientParticleBuilder color(class_243 color) {
        this.color = f -> color;
        return this;
    }

    public ClientParticleBuilder rotation(float rotation) {
        this.getRotation = p -> Float.valueOf(rotation);
        return this;
    }

    public ClientParticleBuilder brightness(int brightness) {
        this.brightness = f -> brightness;
        return this;
    }

    public ClientParticleBuilder scale(Function<Float, Float> scale) {
        this.scale = scale;
        return this;
    }

    public ClientParticleBuilder scale(float scale) {
        this.scale = f -> Float.valueOf(scale);
        return this;
    }

    public ClientParticleBuilder age(Supplier<Integer> age) {
        this.age = age;
        return this;
    }

    public ClientParticleBuilder age(int age) {
        this.age = () -> age;
        return this;
    }

    public ClientParticleBuilder age(int min, int max) {
        this.age = () -> RandomUtils.range(min, max);
        return this;
    }

    public ClientParticleBuilder colorVariation(double variation) {
        this.colorVariation = variation;
        return this;
    }

    public void build(class_243 pos, class_243 vel) {
        class_310 client = class_310.method_1551();
        class_4184 camera = client.field_1773.method_19418();
        if (camera.method_19332()) {
            class_703 particle = client.field_1713.method_3056(this.options, pos.field_1352, pos.field_1351, pos.field_1350, vel.field_1352, vel.field_1351, vel.field_1350);
            if (particle == null) {
                return;
            }
            if (this.scale != null) {
                particle.method_3087(this.scale.apply(Float.valueOf(0.0f)).floatValue());
            }
            if (this.color != null) {
                class_243 clr = this.color.apply(Float.valueOf(0.0f));
                particle.method_3084((float)clr.field_1352, (float)clr.field_1351, (float)clr.field_1350);
            }
            if (this.age != null) {
                particle.method_3077(this.age.get().intValue());
            }
            if (particle instanceof SimpleParticle) {
                SimpleParticle simpleParticle = (SimpleParticle)particle;
                if (this.brightness != null) {
                    simpleParticle.setBrightnessOverride(this.brightness);
                }
                if (this.color != null) {
                    simpleParticle.setColorOverride(this.color);
                }
                if (this.scale != null) {
                    simpleParticle.setScaleOverride(this.scale);
                }
                if (this.getVel != null) {
                    simpleParticle.setVelocityOverride(this.getVel);
                }
                if (this.continuousPos != null) {
                    simpleParticle.setPositionOverride(this.continuousPos);
                }
                if (this.colorVariation != null) {
                    simpleParticle.setColorVariation(this.colorVariation);
                }
                if (this.getRotation != null) {
                    simpleParticle.setRotationOverride(this.getRotation);
                }
            }
        }
    }
}

