/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.cerbons_api.api.item.registry;

import com.cerbon.cerbons_api.api.item.enums.ToolType;
import com.cerbon.cerbons_api.api.registry.RegistryEntry;
import com.cerbon.cerbons_api.api.registry.ResourcefulRegistries;
import com.cerbon.cerbons_api.api.registry.ResourcefulRegistry;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1743;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1810;
import net.minecraft.class_1821;
import net.minecraft.class_1829;
import net.minecraft.class_1831;
import net.minecraft.class_1832;
import net.minecraft.class_2248;
import net.minecraft.class_4174;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class ItemRegistry {
    private final ResourcefulRegistry<class_1792> itemRegistry;

    public ItemRegistry(String modId) {
        this.itemRegistry = ResourcefulRegistries.create(class_7923.field_41178, modId);
    }

    public Map<class_1738.class_8051, RegistryEntry<class_1738>> registerFullArmorSet(class_6880<class_1741> material, int durabilityFactor) {
        return this.registerFullArmorSet(material, List.of(Integer.valueOf(durabilityFactor), Integer.valueOf(durabilityFactor), Integer.valueOf(durabilityFactor), Integer.valueOf(durabilityFactor)));
    }

    public Map<class_1738.class_8051, RegistryEntry<class_1738>> registerFullArmorSet(class_6880<class_1741> material, List<Integer> durabilityFactors) {
        return this.registerFullArmorSet(material, properties -> properties, durabilityFactors);
    }

    public Map<class_1738.class_8051, RegistryEntry<class_1738>> registerFullArmorSet(class_6880<class_1741> material, UnaryOperator<class_1792.class_1793> itemProperties, List<Integer> durabilityFactors) {
        Preconditions.checkArgument((durabilityFactors != null && durabilityFactors.size() == 4 ? 1 : 0) != 0, (Object)"Expected durability array of length 4 (helmet, chest, legs, boots)");
        return ImmutableMap.of((Object)class_1738.class_8051.field_41934, this.registerArmor(class_1738.class_8051.field_41934, material, itemProperties, durabilityFactors.get(0)), (Object)class_1738.class_8051.field_41935, this.registerArmor(class_1738.class_8051.field_41935, material, itemProperties, durabilityFactors.get(1)), (Object)class_1738.class_8051.field_41936, this.registerArmor(class_1738.class_8051.field_41936, material, itemProperties, durabilityFactors.get(2)), (Object)class_1738.class_8051.field_41937, this.registerArmor(class_1738.class_8051.field_41937, material, itemProperties, durabilityFactors.get(3)));
    }

    public RegistryEntry<class_1738> registerArmor(class_1738.class_8051 armorType, class_6880<class_1741> material, int durabilityFactor) {
        return this.registerArmor(armorType, material, properties -> properties, durabilityFactor);
    }

    public RegistryEntry<class_1738> registerArmor(class_1738.class_8051 armorType, class_6880<class_1741> material, UnaryOperator<class_1792.class_1793> itemProperties, int durabilityFactor) {
        String materialName = material.method_40230().map(resourceKey -> resourceKey.method_29177().method_12832()).orElseThrow();
        return this.registerItem(() -> new class_1738(material, armorType, (class_1792.class_1793)itemProperties.apply(new class_1792.class_1793().method_7895(armorType.method_56690(durabilityFactor)))), materialName + "_" + armorType.method_15434());
    }

    public RegistryEntry<class_1831> registerSimpleTool(ToolType toolType, class_1832 tier, float attackDamage, float attackSpeed, String id) {
        return this.registerSimpleTool(toolType, tier, properties -> properties, attackDamage, attackSpeed, id);
    }

    public RegistryEntry<class_1831> registerSimpleTool(ToolType toolType, class_1832 tier, UnaryOperator<class_1792.class_1793> itemProperties, float attackDamage, float attackSpeed, String id) {
        return switch (toolType) {
            default -> throw new MatchException(null, null);
            case ToolType.SWORD -> this.registerItem(() -> new class_1829(tier, (class_1792.class_1793)itemProperties.apply(new class_1792.class_1793().method_57348(class_1829.method_57394((class_1832)tier, (int)((int)attackDamage), (float)attackSpeed)))), id);
            case ToolType.PICKAXE -> this.registerItem(() -> new class_1810(tier, (class_1792.class_1793)itemProperties.apply(new class_1792.class_1793().method_57348(class_1810.method_57346((class_1832)tier, (float)attackDamage, (float)attackSpeed)))), id);
            case ToolType.AXE -> this.registerItem(() -> new class_1743(tier, (class_1792.class_1793)itemProperties.apply(new class_1792.class_1793().method_57348(class_1743.method_57346((class_1832)tier, (float)attackDamage, (float)attackSpeed)))), id);
            case ToolType.SHOVEL -> this.registerItem(() -> new class_1821(tier, (class_1792.class_1793)itemProperties.apply(new class_1792.class_1793().method_57348(class_1821.method_57346((class_1832)tier, (float)attackDamage, (float)attackSpeed)))), id);
            case ToolType.HOE -> this.registerItem(() -> new class_1794(tier, (class_1792.class_1793)itemProperties.apply(new class_1792.class_1793().method_57348(class_1794.method_57346((class_1832)tier, (float)attackDamage, (float)attackSpeed)))), id);
        };
    }

    public RegistryEntry<class_1792> registerFood(class_4174 foodProperties, String id) {
        return this.registerFood(foodProperties, properties -> properties, id);
    }

    public RegistryEntry<class_1792> registerFood(class_4174 foodProperties, UnaryOperator<class_1792.class_1793> itemProperties, String id) {
        return this.registerItem((class_1792.class_1793)itemProperties.apply(new class_1792.class_1793().method_19265(foodProperties)), id);
    }

    public RegistryEntry<class_1747> registerBlockItem(Supplier<class_2248> block, String id) {
        return this.registerBlockItem(block, new class_1792.class_1793(), id);
    }

    public RegistryEntry<class_1747> registerBlockItem(Supplier<class_2248> block, class_1792.class_1793 itemProperties, String id) {
        return this.registerBlockItem(id, () -> new class_1747((class_2248)block.get(), itemProperties));
    }

    public RegistryEntry<class_1747> registerBlockItem(String id, Supplier<class_1747> blockItem) {
        return this.registerItem(blockItem, id);
    }

    public RegistryEntry<class_1792> registerItem(String id) {
        return this.registerItem(new class_1792.class_1793(), id);
    }

    public RegistryEntry<class_1792> registerItem(class_1792.class_1793 itemProperties, String id) {
        return this.registerItem(() -> new class_1792(itemProperties), id);
    }

    public <T extends class_1792> RegistryEntry<T> registerItem(Supplier<T> item, String id) {
        return this.itemRegistry.register(id, item);
    }

    public Collection<RegistryEntry<class_1792>> getEntries() {
        return this.itemRegistry.getEntries();
    }

    public Stream<RegistryEntry<class_1792>> stream() {
        return this.itemRegistry.stream();
    }

    public Stream<class_1792> boundStream() {
        return this.itemRegistry.boundStream();
    }

    public void register() {
        this.itemRegistry.register();
    }
}

