/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.cerbons_api.api.static_utilities;

import com.cerbon.cerbons_api.api.general.math.ReferencedAxisRotator;
import com.cerbon.cerbons_api.api.static_utilities.VecUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class MathUtils {
    public static boolean withinDistance(class_243 pos1, class_243 pos2, double distance) {
        if (distance < 0.0) {
            throw new IllegalArgumentException("Distance cannot be negative");
        }
        return pos1.method_1025(pos2) < Math.pow(distance, 2.0);
    }

    public static boolean movingTowards(class_243 center, class_243 pos, class_243 direction) {
        class_243 directionTo = MathUtils.unNormedDirection(pos, center);
        return direction.method_1026(directionTo) > 0.0;
    }

    public static class_243 unNormedDirection(class_243 source, class_243 target) {
        return target.method_1020(source);
    }

    public static void lineCallback(class_243 start, class_243 end, int points, BiConsumer<class_243, Integer> callback) {
        class_243 dir = end.method_1020(start).method_1021(1.0 / (double)(points - 1));
        class_243 pos = start;
        for (int i = 0; i < points; ++i) {
            callback.accept(pos, i);
            pos = pos.method_1019(dir);
        }
    }

    public static void circleCallback(double radius, int points, class_243 axis, Consumer<class_243> callback) {
        double degrees = Math.PI * 2 / (double)points;
        double axisYaw = MathUtils.directionToYaw(axis);
        ReferencedAxisRotator rotator = new ReferencedAxisRotator(VecUtils.yAxis, axis);
        for (int i = 0; i < points; ++i) {
            double radians = (double)i * degrees;
            class_243 offset = VecUtils.rotateVector(new class_243(Math.sin(radians), 0.0, Math.cos(radians)).method_1021(radius), VecUtils.yAxis, -axisYaw);
            class_243 rotated = rotator.rotate(offset);
            callback.accept(rotated);
        }
    }

    public static Collection<class_243> circlePoints(double radius, int points, class_243 axis) {
        ArrayList<class_243> vectors = new ArrayList<class_243>();
        MathUtils.circleCallback(radius, points, axis, vectors::add);
        return vectors;
    }

    public static boolean willAABBFit(class_238 aabb, class_243 movement, Predicate<class_238> collision) {
        AtomicBoolean collided = new AtomicBoolean(false);
        int points = (int)Math.ceil(movement.method_1033() / aabb.method_995());
        MathUtils.lineCallback(class_243.field_1353, movement, points, (vec3, integer) -> {
            if (collision.test(aabb.method_997(vec3))) {
                collided.set(true);
            }
        });
        return !collided.get();
    }

    public static float directionToPitch(class_243 direction) {
        double x = direction.field_1352;
        double z = direction.field_1350;
        double y = direction.field_1351;
        double h = Math.sqrt(x * x + z * z);
        return (float)Math.toDegrees(-class_3532.method_15349((double)y, (double)h));
    }

    public static double directionToYaw(class_243 direction) {
        double x = direction.method_10216();
        double z = direction.method_10215();
        return Math.toDegrees(class_3532.method_15349((double)z, (double)x));
    }

    public static class_243 lerpVec(float partialTicks, class_243 vec1, class_243 vec2) {
        double x = class_3532.method_16436((double)partialTicks, (double)vec1.field_1352, (double)vec2.field_1352);
        double y = class_3532.method_16436((double)partialTicks, (double)vec1.field_1351, (double)vec2.field_1351);
        double z = class_3532.method_16436((double)partialTicks, (double)vec1.field_1350, (double)vec2.field_1350);
        return new class_243(x, y, z);
    }

    public static class_243 axisOffset(class_243 direction, class_243 offset) {
        class_243 forward = direction.method_1029();
        class_243 side = forward.method_1036(VecUtils.yAxis).method_1029();
        class_243 up = side.method_1036(forward).method_1029();
        return forward.method_1021(offset.field_1352).method_1019(side.method_1021(offset.field_1350)).method_1019(up.method_1021(offset.field_1351));
    }

    public static boolean facingSameDirection(class_243 direction1, class_243 direction2) {
        return direction1.method_1026(direction2) > 0.0;
    }

    public static int consecutiveSum(int firstNumber, int lastNumber) {
        return (lastNumber - firstNumber + 1) * (firstNumber + lastNumber) / 2;
    }

    public static float roundedStep(float n, List<Float> steps, boolean floor) {
        ArrayList<Float> sortableSteps = new ArrayList<Float>(steps);
        if (floor) {
            sortableSteps.sort(Collections.reverseOrder());
            for (Float step : sortableSteps) {
                if (!(step.floatValue() <= n)) continue;
                return step.floatValue();
            }
            return ((Float)sortableSteps.get(0)).floatValue();
        }
        Collections.sort(sortableSteps);
        for (Float step : sortableSteps) {
            if (!(step.floatValue() > n)) continue;
            return step.floatValue();
        }
        return ((Float)sortableSteps.get(sortableSteps.size() - 1)).floatValue();
    }

    public static List<class_243> buildBlockCircle(double radius) {
        int intRadius = (int)radius;
        double radiusSq = radius * radius;
        ArrayList<class_243> points = new ArrayList<class_243>();
        for (int x = -intRadius; x <= intRadius; ++x) {
            for (int z = -intRadius; z <= intRadius; ++z) {
                class_243 pos = new class_243((double)x, 0.0, (double)z);
                if (!(pos.method_1027() <= radiusSq)) continue;
                points.add(pos);
            }
        }
        return points;
    }

    public static List<class_2338> getBlocksInLine(class_2338 startPos, class_2338 endPos) {
        int zs;
        int x1 = startPos.method_10263();
        int y1 = startPos.method_10264();
        int z1 = startPos.method_10260();
        int x2 = endPos.method_10263();
        int y2 = endPos.method_10264();
        int z2 = endPos.method_10260();
        ArrayList<class_2338> points = new ArrayList<class_2338>();
        points.add(startPos);
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int dz = Math.abs(z2 - z1);
        int xs = x2 > x1 ? 1 : -1;
        int ys = y2 > y1 ? 1 : -1;
        int n = zs = z2 > z1 ? 1 : -1;
        if (dx >= dy && dx >= dz) {
            int p1 = 2 * dy - dx;
            int p2 = 2 * dz - dx;
            while (x1 != x2) {
                x1 += xs;
                if (p1 >= 0) {
                    y1 += ys;
                    p1 -= 2 * dx;
                }
                if (p2 >= 0) {
                    z1 += zs;
                    p2 -= 2 * dx;
                }
                p1 += 2 * dy;
                p2 += 2 * dz;
                points.add(new class_2338(x1, y1, z1));
            }
        } else if (dy >= dx && dy >= dz) {
            int p1 = 2 * dx - dy;
            int p2 = 2 * dz - dy;
            while (y1 != y2) {
                y1 += ys;
                if (p1 >= 0) {
                    x1 += xs;
                    p1 -= 2 * dy;
                }
                if (p2 >= 0) {
                    z1 += zs;
                    p2 -= 2 * dy;
                }
                p1 += 2 * dx;
                p2 += 2 * dz;
                points.add(new class_2338(x1, y1, z1));
            }
        } else {
            int p1 = 2 * dy - dz;
            int p2 = 2 * dx - dz;
            while (z1 != z2) {
                z1 += zs;
                if (p1 >= 0) {
                    y1 += ys;
                    p1 -= 2 * dz;
                }
                if (p2 >= 0) {
                    x1 += xs;
                    p2 -= 2 * dz;
                }
                p1 += 2 * dy;
                p2 += 2 * dx;
                points.add(new class_2338(x1, y1, z1));
            }
        }
        return points;
    }

    public static float ratioLerp(float time, float ratio, float maxAge, float partialTicks) {
        assert (ratio <= 1.0f);
        assert (ratio >= 0.0f);
        assert (maxAge > 0.0f);
        float currentTime = class_3532.method_15363((float)((time + partialTicks) / maxAge), (float)0.0f, (float)1.0f);
        return Math.max(0.0f, currentTime - ratio) / (1.0f - ratio);
    }
}

