/*
 * Decompiled with CFR 0.152.
 */
package malte0811.ferritecore.fastmap;

import com.google.common.base.Preconditions;
import malte0811.ferritecore.fastmap.FastMapKey;
import net.minecraft.class_2769;
import net.minecraft.class_3532;

public class BinaryFastMapKey<T extends Comparable<T>>
extends FastMapKey<T> {
    private final byte firstBitInValue;
    private final byte firstBitAfterValue;

    public BinaryFastMapKey(class_2769<T> property, int mapFactor) {
        super(property);
        Preconditions.checkArgument((boolean)class_3532.method_15352((int)mapFactor));
        int addedFactor = class_3532.method_15339((int)this.numValues());
        Preconditions.checkState((this.numValues() <= addedFactor ? 1 : 0) != 0);
        Preconditions.checkState((addedFactor < 2 * this.numValues() ? 1 : 0) != 0);
        int setBitInBaseFactor = class_3532.method_15351((int)mapFactor);
        int setBitInAddedFactor = class_3532.method_15351((int)addedFactor);
        Preconditions.checkState((setBitInBaseFactor + setBitInAddedFactor <= 31 ? 1 : 0) != 0);
        this.firstBitInValue = (byte)setBitInBaseFactor;
        this.firstBitAfterValue = (byte)(setBitInBaseFactor + setBitInAddedFactor);
    }

    @Override
    public T getValue(int mapIndex) {
        int clearAbove = mapIndex & this.lowestNBits(this.firstBitAfterValue);
        return this.byInternalIndex(clearAbove >>> this.firstBitInValue);
    }

    @Override
    public int replaceIn(int mapIndex, Comparable<?> newValue) {
        int newPartialIndex = this.toPartialMapIndex(newValue);
        if (newPartialIndex < 0) {
            return -1;
        }
        int keepMask = ~this.lowestNBits(this.firstBitAfterValue) | this.lowestNBits(this.firstBitInValue);
        return keepMask & mapIndex | newPartialIndex;
    }

    @Override
    public int toPartialMapIndex(Comparable<?> value) {
        int internalIndex = this.getInternalIndex(value);
        if (internalIndex < 0 || internalIndex >= this.numValues()) {
            return -1;
        }
        return internalIndex << this.firstBitInValue;
    }

    @Override
    public int getFactorToNext() {
        return 1 << this.firstBitAfterValue - this.firstBitInValue;
    }

    private int lowestNBits(byte n) {
        if (n >= 32) {
            return -1;
        }
        return (1 << n) - 1;
    }
}

