/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.pickaxetrims.shared;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.LootEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.architectury.utils.value.IntValue;
import dev.foxgirl.pickaxetrims.shared.PickaxeTrim;
import dev.foxgirl.pickaxetrims.shared.PickaxeTrimsConfig;
import dev.foxgirl.pickaxetrims.shared.effect.CryingObsidianMultiBreakEffect;
import dev.foxgirl.pickaxetrims.shared.effect.LapisGlowEffect;
import dev.foxgirl.pickaxetrims.shared.effect.RedstoneVeinMineEffect;
import java.util.function.Consumer;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_73;
import net.minecraft.class_7696;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7924;
import net.minecraft.class_8052;
import net.minecraft.class_9331;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PickaxeTrimsImpl
implements TickEvent.Server,
BlockEvent.Break,
LootEvent.ModifyLootTable {
    private static PickaxeTrimsImpl INSTANCE;
    @NotNull
    public final PickaxeTrimsConfig config;
    @NotNull
    private final DeferredRegister<class_9331<?>> registryComponentType;
    @NotNull
    private final DeferredRegister<class_1792> registryItem;
    @NotNull
    private final DeferredRegister<class_1761> registryItemGroup;
    @NotNull
    private final @NotNull RegistrySupplier<@NotNull class_9331<PickaxeTrim>> trimComponentType;
    @NotNull
    private final @NotNull RegistrySupplier<@NotNull class_8052> smithingTemplateItem;
    @NotNull
    private final @NotNull RegistrySupplier<@NotNull class_1761> itemGroup;
    private CryingObsidianMultiBreakEffect cryingObsidianEffect;
    private RedstoneVeinMineEffect redstoneEffect;
    private LapisGlowEffect lapisEffect;

    public static PickaxeTrimsImpl getInstance() {
        return INSTANCE;
    }

    @NotNull
    public class_9331<PickaxeTrim> getTrimComponentType() {
        return (class_9331)this.trimComponentType.get();
    }

    @NotNull
    public class_8052 getSmithingTemplateItem() {
        return (class_8052)this.smithingTemplateItem.get();
    }

    @NotNull
    public class_1761 getItemGroup() {
        return (class_1761)this.itemGroup.get();
    }

    @NotNull
    public class_5321<class_1761> getItemGroupKey() {
        return class_5321.method_29179((class_5321)this.itemGroup.getRegistryKey(), (class_2960)this.itemGroup.getId());
    }

    public PickaxeTrimsImpl() {
        INSTANCE = this;
        this.config = PickaxeTrimsConfig.loadConfig();
        this.registryComponentType = DeferredRegister.create((String)"pickaxetrims", (class_5321)class_7924.field_49659);
        this.registryItem = DeferredRegister.create((String)"pickaxetrims", (class_5321)class_7924.field_41197);
        this.registryItemGroup = DeferredRegister.create((String)"pickaxetrims", (class_5321)class_7924.field_44688);
        this.trimComponentType = this.registryComponentType.register(class_2960.method_60655((String)"pickaxetrims", (String)"trim"), () -> class_9331.method_57873().method_57881(PickaxeTrim.CODEC).method_57882(PickaxeTrim.PACKET_CODEC).method_59871().method_57880());
        this.smithingTemplateItem = this.registryItem.register(class_2960.method_60655((String)"pickaxetrims", (String)"fracture_armor_trim_smithing_template"), () -> class_8052.method_48419((class_2960)class_2960.method_60655((String)"pickaxetrims", (String)"fracture"), (class_7696[])new class_7696[0]));
        this.itemGroup = this.registryItemGroup.register(class_2960.method_60655((String)"pickaxetrims", (String)"pickaxe_trims_tab"), () -> CreativeTabRegistry.create((class_2561)class_2561.method_43471((String)"itemGroup.pickaxetrims"), () -> PickaxeTrim.set(new class_1799((class_1935)class_1802.field_22024), PickaxeTrim.TrimType.EMERALD)));
    }

    public void initialize() {
        this.registryComponentType.register();
        this.registryItem.register();
        this.registryItemGroup.register();
        LootEvent.MODIFY_LOOT_TABLE.register((Object)this);
        TickEvent.SERVER_POST.register((Object)this);
        BlockEvent.BREAK.register((Object)this);
        this.cryingObsidianEffect = new CryingObsidianMultiBreakEffect();
        this.redstoneEffect = new RedstoneVeinMineEffect();
        this.lapisEffect = new LapisGlowEffect();
    }

    public void forEachStackForItemGroup(@NotNull @NotNull Consumer<@NotNull class_1799> consumer) {
        for (PickaxeTrim.PickaxeType pickaxeType : PickaxeTrim.PickaxeType.VALUES) {
            for (PickaxeTrim.TrimType trimType : PickaxeTrim.TrimType.VALUES) {
                consumer.accept(PickaxeTrim.set(new class_1799((class_1935)pickaxeType.getItem()), trimType));
            }
        }
        consumer.accept(new class_1799((class_1935)this.getSmithingTemplateItem()));
    }

    private boolean shouldModifyLootTable(class_5321<class_52> key) {
        return this.config.smithingTemplateLootTables.contains(key.method_29177().toString());
    }

    private int getLootTableEmptyEntryWeight() {
        return Math.max(0, 1 - (int)(1.0f / this.config.smithingTemplateLootProbability));
    }

    public void modifyLootTable(class_5321<class_52> key, LootEvent.LootTableModificationContext context, boolean builtin) {
        if (this.shouldModifyLootTable(key)) {
            context.addPool(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_73.method_401().method_437(this.getLootTableEmptyEntryWeight())).method_351((class_79.class_80)class_77.method_411((class_1935)this.getSmithingTemplateItem()).method_437(1)));
        }
    }

    public void tick(@NotNull MinecraftServer server) {
        this.cryingObsidianEffect.onTickEnd(server);
        this.redstoneEffect.onTickEnd(server);
        this.lapisEffect.onTickEnd(server);
    }

    public EventResult breakBlock(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 state, @NotNull class_3222 player, @Nullable IntValue xp) {
        PickaxeTrim.TrimType trimType = PickaxeTrim.getTrimType(player.method_6047());
        if (trimType != null) {
            switch (trimType) {
                case CRYING_OBSIDIAN: {
                    this.cryingObsidianEffect.onBlockBreak(level, pos, state, player);
                    break;
                }
                case REDSTONE: {
                    this.redstoneEffect.onBlockBreak(level, pos, state, player);
                    break;
                }
                case LAPIS_LAZULI: {
                    this.lapisEffect.onBlockBreak(level, pos, state, player);
                    break;
                }
            }
        }
        return EventResult.pass();
    }
}

