/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.pickaxetrims.shared.effect;

import dev.foxgirl.pickaxetrims.shared.OreDetectUtil;
import dev.foxgirl.pickaxetrims.shared.PickaxeTrimsImpl;
import dev.foxgirl.pickaxetrims.shared.effect.AbstractEffect;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1606;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public final class LapisGlowEffect
extends AbstractEffect {
    private final Map<class_2338, ShulkerEntityState> activeShulkers = new HashMap<class_2338, ShulkerEntityState>();

    private void highlightBlock(class_3222 player, class_2338 pos, class_2248 block) {
        this.activeShulkers.computeIfAbsent(pos, __ -> new ShulkerEntityState(player.method_51469(), pos, block)).resetTicks();
    }

    private void highlightBlocks(class_3222 player, class_2248 expectedBlock) {
        int radius = PickaxeTrimsImpl.getInstance().config.lapisGlowRadius;
        double radiusSquaredDistance = radius * radius;
        class_2338 playerPos = player.method_24515().method_10084();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    class_2248 actualBlock;
                    class_2338 blockPos = playerPos.method_10069(x, y, z);
                    if (!(blockPos.method_10262((class_2382)playerPos) <= radiusSquaredDistance) || (actualBlock = player.method_37908().method_8320(blockPos).method_26204()) != expectedBlock) continue;
                    this.highlightBlock(player, blockPos, expectedBlock);
                }
            }
        }
    }

    @Override
    public void onTickEnd(@NotNull MinecraftServer server) {
        this.activeShulkers.values().removeIf(ShulkerEntityState::update);
    }

    @Override
    public void onBlockBreak(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 state, @NotNull class_3222 player) {
        class_2248 block = state.method_26204();
        if (OreDetectUtil.isOreBlock(block)) {
            this.highlightBlocks(player, block);
        }
    }

    private static final class ShulkerEntityState {
        private final class_3218 world;
        private final class_2338 pos;
        private final class_2248 block;
        private int ticks;
        private final class_1606 entity;

        public ShulkerEntityState(class_3218 world, class_2338 pos, class_2248 block) {
            this.world = world;
            this.pos = pos;
            this.block = block;
            this.resetTicks();
            this.entity = new class_1606(class_1299.field_6109, (class_1937)world);
            this.entity.method_23327((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5);
            this.entity.method_6092(new class_1293(class_1294.field_5905, -1, 0, false, false));
            this.updateEntityFlags();
            world.method_8649((class_1297)this.entity);
        }

        private void resetTicks() {
            this.ticks = (int)(20.0f * PickaxeTrimsImpl.getInstance().config.lapisGlowSeconds);
        }

        private void updateEntityFlags() {
            this.entity.method_5684(true);
            this.entity.method_5977(true);
            this.entity.method_5648(true);
            this.entity.method_5834(true);
        }

        private boolean update() {
            if (this.ticks-- <= 0 || this.world.method_8320(this.pos).method_26204() != this.block) {
                this.entity.method_5650(class_1297.class_5529.field_26999);
                return true;
            }
            this.updateEntityFlags();
            return false;
        }
    }
}

