/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalbonemeal.world.level.block.behavior;

import com.google.common.collect.Lists;
import fuzs.universalbonemeal.world.level.block.behavior.BoneMealBehavior;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2222;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2472;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class CoralBehavior
implements BoneMealBehavior {
    private static Map<class_2248, class_2248> plantToBlock;

    public boolean method_9651(class_4538 level, class_2338 blockPos, class_2680 blockState) {
        return level.method_23753(blockPos).method_40220(class_6908.field_37380);
    }

    public boolean method_9650(class_1937 level, class_5819 random, class_2338 blockPos, class_2680 blockState) {
        return (double)random.method_43057() < 0.4;
    }

    public void method_9652(class_3218 level, class_5819 random, class_2338 blockPos, class_2680 blockState) {
        this.place(level, blockPos, blockState, random);
    }

    private boolean place(class_3218 level, class_2338 blockPos, class_2680 blockState, class_5819 randomSource) {
        level.method_8650(blockPos, false);
        this.dissolve();
        if (this.placeFeature((class_1936)level, randomSource, blockPos, this.getBlockEquivalent(blockState, randomSource).method_9564())) {
            return true;
        }
        level.method_8652(blockPos, blockState, 3);
        return false;
    }

    public static void invalidate() {
        plantToBlock = null;
    }

    private void dissolve() {
        if (plantToBlock == null) {
            IdentityHashMap<class_2248, class_2248> map = new IdentityHashMap<class_2248, class_2248>();
            for (class_6880 holder : class_7923.field_41175.method_40286(class_3481.field_15483)) {
                class_2248 block = this.getBlockEquivalent((class_2248)holder.comp_349());
                if (block == null) continue;
                map.put((class_2248)holder.comp_349(), block);
            }
            plantToBlock = map;
        }
    }

    @Nullable
    private class_2248 getBlockEquivalent(class_2248 block) {
        String name = class_7923.field_41175.method_10221((Object)block).method_12832();
        name = name.substring(0, name.indexOf("_coral"));
        for (class_6880 holder : class_7923.field_41175.method_40286(class_3481.field_15461)) {
            if (!class_7923.field_41175.method_10221((Object)((class_2248)holder.comp_349())).method_12832().contains(name)) continue;
            return (class_2248)holder.comp_349();
        }
        return null;
    }

    private class_2248 getBlockEquivalent(class_2680 blockState, class_5819 random) {
        class_2248 block = plantToBlock.get(blockState.method_26204());
        if (block != null) {
            return block;
        }
        return class_7923.field_41175.method_40266(class_3481.field_15461).flatMap(holders -> holders.method_40243(random)).map(class_6880::comp_349).orElseThrow();
    }

    private boolean placeFeature(class_1936 level, class_5819 random, class_2338 pos, class_2680 blockState) {
        class_2338.class_2339 mutable = pos.method_25503();
        int trunkHeight = random.method_43048(3) + 1;
        if (!this.isValidPosition(level, pos, trunkHeight)) {
            return false;
        }
        for (int j = 0; j < trunkHeight; ++j) {
            if (!this.placeCoralBlock(level, random, (class_2338)mutable, blockState, j == trunkHeight - 1)) {
                return j != 0;
            }
            mutable.method_10098(class_2350.field_11036);
        }
        class_2338 blockpos = mutable.method_10062();
        int arms = random.method_43048(3) + 2;
        ArrayList list = Lists.newArrayList((Iterable)class_2350.class_2353.field_11062);
        Collections.shuffle(list);
        for (class_2350 direction : list.subList(0, arms)) {
            mutable.method_10101((class_2382)blockpos);
            mutable.method_10098(direction);
            int armLength = random.method_43048(5) + 2;
            int i1 = 0;
            for (int j1 = 0; j1 < armLength && this.placeCoralBlock(level, random, (class_2338)mutable, blockState, true); ++j1) {
                mutable.method_10098(class_2350.field_11036);
                if (j1 != 0 && (++i1 < 2 || !(random.method_43057() < 0.25f))) continue;
                mutable.method_10098(direction);
                i1 = 0;
            }
        }
        return true;
    }

    private boolean isValidPosition(class_1936 level, class_2338 blockPos, int height) {
        int i = blockPos.method_10264();
        if (i >= level.method_31607() + 1 && i + height + 1 < level.method_31600()) {
            class_2338.class_2339 mutable = new class_2338.class_2339();
            for (int j = 0; j <= height + 4; ++j) {
                int k = j < height ? 0 : (j - height) / 2 + 1;
                for (int l = -k; l <= k; ++l) {
                    for (int i1 = -k; i1 <= k; ++i1) {
                        class_2680 blockstate1 = level.method_8320((class_2338)mutable.method_25504((class_2382)blockPos, l, j, i1));
                        if (this.isCoralReplaceable(blockstate1)) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    private boolean isCoralReplaceable(class_2680 blockState) {
        return blockState.method_27852(class_2246.field_10382) || blockState.method_26164(class_3481.field_15461) || blockState.method_26164(class_3481.field_15488) || blockState.method_26164(class_3481.field_15476);
    }

    private boolean placeCoralBlock(class_1936 level, class_5819 random, class_2338 pos, class_2680 blockState, boolean decorateTop) {
        class_2338 blockpos = pos.method_10084();
        class_2680 blockstate = level.method_8320(pos);
        if (this.isCoralReplaceable(blockstate) && this.isCoralReplaceable(level.method_8320(blockpos))) {
            level.method_8652(pos, blockState, 3);
            if (decorateTop) {
                if (random.method_43057() < 0.25f) {
                    class_7923.field_41175.method_40266(class_3481.field_15488).flatMap(holders -> holders.method_40243(random)).map(class_6880::comp_349).ifPresent(p_204720_ -> level.method_8652(blockpos, p_204720_.method_9564(), 2));
                } else if (random.method_43057() < 0.05f) {
                    level.method_8652(blockpos, (class_2680)class_2246.field_10476.method_9564().method_11657((class_2769)class_2472.field_11472, (Comparable)Integer.valueOf(random.method_43048(4) + 1)), 2);
                }
            }
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                class_2338 blockpos1;
                if (!(random.method_43057() < 0.2f) || !level.method_8320(blockpos1 = pos.method_10093(direction)).method_27852(class_2246.field_10382)) continue;
                class_7923.field_41175.method_40266(class_3481.field_15476).flatMap(holders -> holders.method_40243(random)).map(class_6880::comp_349).ifPresent(block -> {
                    class_2680 blockstate1 = block.method_9564();
                    if (blockstate1.method_28498((class_2769)class_2222.field_9933)) {
                        blockstate1 = (class_2680)blockstate1.method_11657((class_2769)class_2222.field_9933, (Comparable)direction);
                    }
                    level.method_8652(blockpos1, blockstate1, 2);
                });
            }
            return true;
        }
        return false;
    }
}

