/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.api.model.modifier.item;

import com.supermartijn642.fusion.api.model.modifier.item.ItemPredicate;
import com.supermartijn642.fusion.api.util.Either;
import com.supermartijn642.fusion.model.modifiers.item.predicates.AndItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.CountItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.DurabilityItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.EnchantmentItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.NotItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.OrItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.PotionItemPredicate;
import java.util.Arrays;
import net.minecraft.class_1842;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class DefaultItemPredicates {
    public static ItemPredicate and(ItemPredicate ... predicates) {
        return new AndItemPredicate(Arrays.asList(predicates));
    }

    public static ItemPredicate or(ItemPredicate ... predicates) {
        return new OrItemPredicate(Arrays.asList(predicates));
    }

    public static ItemPredicate not(ItemPredicate predicate) {
        return new NotItemPredicate(predicate);
    }

    public static ItemPredicate count(int count) {
        return DefaultItemPredicates.count(count, count);
    }

    public static ItemPredicate count(int min, int max) {
        return new CountItemPredicate(Either.left(min), Either.left(max));
    }

    public static ItemPredicate count(int min, float maxPercentage) {
        return new CountItemPredicate(Either.left(min), Either.right(Float.valueOf(maxPercentage)));
    }

    public static ItemPredicate count(float minPercentage, int max) {
        return new CountItemPredicate(Either.right(Float.valueOf(minPercentage)), Either.left(max));
    }

    public static ItemPredicate count(float minPercentage, float maxPercentage) {
        return new CountItemPredicate(Either.right(Float.valueOf(minPercentage)), Either.right(Float.valueOf(maxPercentage)));
    }

    public static ItemPredicate durability(int min, int max) {
        return new DurabilityItemPredicate(Either.left(min), Either.left(max));
    }

    public static ItemPredicate durability(int min, float maxPercentage) {
        return new DurabilityItemPredicate(Either.left(min), Either.right(Float.valueOf(maxPercentage)));
    }

    public static ItemPredicate durability(float minPercentage, int max) {
        return new DurabilityItemPredicate(Either.right(Float.valueOf(minPercentage)), Either.left(max));
    }

    public static ItemPredicate durability(float minPercentage, float maxPercentage) {
        return new DurabilityItemPredicate(Either.right(Float.valueOf(minPercentage)), Either.right(Float.valueOf(maxPercentage)));
    }

    public static ItemPredicate enchantment(class_2960 enchantment) {
        return DefaultItemPredicates.enchantment(enchantment, 1, 255);
    }

    public static ItemPredicate enchantment(class_2960 enchantment, int level) {
        return DefaultItemPredicates.enchantment(enchantment, level, level);
    }

    public static ItemPredicate enchantment(class_2960 enchantment, int minLevel, int maxLevel) {
        return new EnchantmentItemPredicate(enchantment, minLevel, maxLevel);
    }

    public static ItemPredicate potion(class_1842 potion) {
        return DefaultItemPredicates.potion((class_6880<class_1842>)class_7923.field_41179.method_47983((Object)potion));
    }

    public static ItemPredicate potion(class_6880<class_1842> potion) {
        return new PotionItemPredicate(potion);
    }
}

