/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.dungeon;

import jeresources.config.Settings;
import jeresources.entry.DungeonEntry;
import jeresources.jei.BlankJEIRecipeCategory;
import jeresources.jei.JEIConfig;
import jeresources.jei.dungeon.DungeonTooltip;
import jeresources.jei.dungeon.DungeonWrapper;
import jeresources.reference.Resources;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class DungeonCategory
extends BlankJEIRecipeCategory<DungeonEntry> {
    protected static final int Y_FIRST_ITEM = 44;
    protected static final int X_FIRST_ITEM = 6;
    protected static int SPACING_Y;
    protected static int SPACING_X;
    protected static int ITEMS_PER_PAGE;

    public static void reloadSettings() {
        ITEMS_PER_PAGE = Settings.ITEMS_PER_COLUMN * Settings.ITEMS_PER_ROW * 2;
        SPACING_X = 166 / (Settings.ITEMS_PER_ROW * 2);
        SPACING_Y = 80 / Settings.ITEMS_PER_COLUMN;
    }

    public DungeonCategory() {
        super((IDrawable)JEIConfig.getJeiHelpers().getGuiHelper().createDrawable(Resources.Gui.Jei.TABS, 16, 0, 16, 16), new DungeonWrapper());
        DungeonCategory.reloadSettings();
    }

    @NotNull
    public class_2561 getTitle() {
        return class_2561.method_43471((String)"jer.dungeon.title");
    }

    @NotNull
    public IDrawable getBackground() {
        return Resources.Gui.Jei.DUNGEON;
    }

    @NotNull
    public RecipeType<DungeonEntry> getRecipeType() {
        return JEIConfig.DUNGEON_TYPE;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull DungeonEntry recipe, @NotNull IFocusGroup focuses) {
        int x = 6;
        int y = 44;
        int slots = Math.min(recipe.amountOfItems((IFocus<class_1799>)((IFocus)focuses.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK).findFirst().orElse(null))), ITEMS_PER_PAGE);
        for (int i = 0; i < slots; ++i) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).addTooltipCallback((IRecipeSlotTooltipCallback)new DungeonTooltip(recipe)).addItemStacks(recipe.getItems((IFocus<class_1799>)((IFocus)focuses.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK).findFirst().orElse(null)), i, slots));
            if ((x += SPACING_X) < 6 + SPACING_X * Settings.ITEMS_PER_ROW * 2) continue;
            x = 6;
            y += SPACING_Y;
        }
        ((DungeonWrapper)this.recipeCategoryExtension).resetLid();
    }
}

