/*
 * Decompiled with CFR 0.152.
 */
package jeresources.registry;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import jeresources.config.Settings;
import jeresources.entry.EnchantmentEntry;
import jeresources.util.RegistryHelper;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class EnchantmentRegistry {
    private Set<EnchantmentEntry> enchantments = new HashSet<EnchantmentEntry>();
    private static EnchantmentRegistry instance;

    public static EnchantmentRegistry getInstance() {
        if (instance == null) {
            instance = new EnchantmentRegistry();
            return instance;
        }
        return instance;
    }

    public EnchantmentRegistry() {
        for (class_6880 class_68802 : EnchantmentRegistry.getEnchants()) {
            if (class_68802 == null) continue;
            this.enchantments.add(new EnchantmentEntry((class_6880<class_1887>)class_68802));
        }
        this.removeAll(Settings.excludedEnchants);
    }

    public Set<EnchantmentEntry> getEnchantments(class_1799 itemStack) {
        HashSet<EnchantmentEntry> set = new HashSet<EnchantmentEntry>();
        for (EnchantmentEntry enchantmentEntry : this.enchantments) {
            if (!enchantmentEntry.getEnchantment().method_60046(itemStack)) continue;
            set.add(enchantmentEntry);
        }
        return set;
    }

    private void excludeFormRegistry(class_6880<class_1887> enchantment) {
        this.enchantments.removeIf(enchantmentEntry -> enchantmentEntry.getEnchantment().comp_2686().getString().equals(((class_1887)enchantment.comp_349()).comp_2686().getString()));
    }

    private void excludeFormRegistry(String sEnchantment) {
        for (class_6880 class_68802 : EnchantmentRegistry.getEnchants()) {
            if (class_68802 == null || !((class_1887)class_68802.comp_349()).comp_2686().getString().toLowerCase().contains(sEnchantment.toLowerCase())) continue;
            this.excludeFormRegistry((class_6880<class_1887>)class_68802);
        }
    }

    public void removeAll(String[] excludedEnchants) {
        for (String enchant : excludedEnchants) {
            this.excludeFormRegistry(enchant);
        }
    }

    private static Set<class_6880.class_6883<class_1887>> getEnchants() {
        return RegistryHelper.getRegistry(class_7924.field_41265).method_40270().collect(Collectors.toSet());
    }
}

