/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.mehvahdjukaar.amendments.common.block.ModCauldronBlock;
import net.mehvahdjukaar.amendments.common.network.ClientBoundPlaySplashParticlesMessage;
import net.mehvahdjukaar.amendments.common.recipe.CauldronRecipeUtils;
import net.mehvahdjukaar.amendments.common.recipe.FluidAndItemCraftResult;
import net.mehvahdjukaar.amendments.common.recipe.FluidAndItemsCraftResult;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.events.behaviors.CauldronConversion;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.amendments.reg.ModTags;
import net.mehvahdjukaar.moonlight.api.block.ILightable;
import net.mehvahdjukaar.moonlight.api.fluids.MLBuiltinSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.misc.InvPlacer;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3922;
import net.minecraft.class_5556;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;

public final class CommonCauldronCode {
    public static void entityInside(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity, Supplier<Double> heightProvider) {
        boolean shouldCheckFluid;
        boolean canFluidExtinguish = true;
        boolean bl = shouldCheckFluid = !entity.field_5957 || entity.method_5809();
        if (shouldCheckFluid && CommonCauldronCode.getFluidOrWater(state, pos, (class_1936)level).is(ModTags.CANT_EXTINGUISH)) {
            canFluidExtinguish = false;
        }
        if (canFluidExtinguish) {
            entity.field_5957 = true;
        }
        if (level.field_9236) {
            return;
        }
        if (((Boolean)state.method_11654((class_2769)ModCauldronBlock.BOILING)).booleanValue() && entity instanceof class_1309) {
            entity.method_5643(new class_1282(ModRegistry.BOILING_DAMAGE.getHolder(level)), 1.0f);
        }
        if (entity.method_5809() && canFluidExtinguish) {
            CommonCauldronCode.playExtinguishSound(level, pos, entity);
            if (!(state.method_26204() instanceof class_5556)) {
                CommonCauldronCode.extinguishLikeSuperLayeredCauldron(level, pos, entity);
            }
        }
        CommonCauldronCode.attemptInWorldCrafting(state, level, pos, entity, heightProvider);
    }

    private static void extinguishLikeSuperLayeredCauldron(class_1937 level, class_2338 pos, class_1297 entity) {
        class_2586 class_25862;
        entity.method_5646();
        if (entity.method_36971(level, pos) && (class_25862 = level.method_8321(pos)) instanceof LiquidCauldronBlockTile) {
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)class_25862;
            te.consumeOneLayer();
            level.method_33596(entity, (class_6880)class_5712.field_28733, pos);
        }
    }

    private static void playExtinguishSound(class_1937 level, class_2338 pos, class_1297 entity) {
        level.method_8396(null, pos, class_3417.field_15222, entity.method_5634(), 0.7f, 1.6f + (level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.4f);
    }

    public static class_2680 updateBoilingState(class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 neighborPos, class_2680 newState, class_2338 currentPos) {
        if (direction == class_2350.field_11033) {
            SoftFluidStack fluidStack = CommonCauldronCode.getFluidOrWater(newState, currentPos, level);
            boolean isFire = CommonCauldronCode.shouldBoil(neighborState, fluidStack, level, neighborPos);
            newState = (class_2680)newState.method_11657((class_2769)ModCauldronBlock.BOILING, (Comparable)Boolean.valueOf(isFire));
        }
        return newState;
    }

    private static SoftFluidStack getFluidOrWater(class_2680 newState, class_2338 pos, class_1936 level) {
        class_2586 class_25862;
        if (newState.method_26204() instanceof ModCauldronBlock && (class_25862 = level.method_8321(pos)) instanceof LiquidCauldronBlockTile) {
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)class_25862;
            return te.getSoftFluidTank().getFluid();
        }
        return SoftFluidStack.of((class_6880)MLBuiltinSoftFluids.WATER.getHolder((class_7225.class_7874)level.method_30349()), (int)((Integer)newState.method_11654((class_2769)class_5556.field_27206)));
    }

    public static boolean shouldBoil(class_2680 belowState, SoftFluidStack fluid, class_1936 level, class_2338 pos) {
        if (!belowState.method_26164(ModTags.HEAT_SOURCES) || fluid.is(ModTags.CANT_BOIL)) {
            return false;
        }
        if (belowState.method_28498((class_2769)class_3922.field_17352)) {
            return (Boolean)belowState.method_11654((class_2769)class_3922.field_17352);
        }
        class_2248 class_22482 = belowState.method_26204();
        if (class_22482 instanceof ILightable) {
            ILightable il = (ILightable)class_22482;
            return il.isLitUp(belowState, (class_1922)level, pos);
        }
        return true;
    }

    public static void onEntityFallOnContent(class_1937 level, class_2680 state, class_1297 entity, double height) {
        if (entity instanceof class_1542) {
            class_1542 ie = (class_1542)entity;
            ie.method_6988();
        }
        if (!level.field_9236) {
            CommonCauldronCode.playSplashEffects(entity, height);
        }
    }

    public static void playBubblingAnimation(class_1937 level, class_2338 pos, double surface, class_5819 rand, int color, int light) {
        class_2400 type = (class_2400)ModRegistry.BOILING_PARTICLE.get();
        int count = 2;
        CommonCauldronCode.addSurfaceParticles((class_2394)type, level, pos, count, surface, rand, color, (float)pos.method_10264() + 0.3125f, light);
        if (level.field_9229.method_43048(4) == 0) {
            level.method_8486((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_3417.field_15161, class_3419.field_15245, 0.4f + level.field_9229.method_43057() * 0.2f, 0.35f + level.field_9229.method_43057() * 0.2f, false);
        }
    }

    public static void addSurfaceParticles(class_2394 type, class_1937 level, class_2338 pos, int count, double surface, class_5819 rand, float r, float g, float b) {
        for (int i = 0; i < count; ++i) {
            double x = (double)pos.method_10263() + 0.1875 + (double)rand.method_43057() * 0.625;
            double y = (double)pos.method_10264() + surface;
            double z = (double)pos.method_10260() + 0.1875 + (double)rand.method_43057() * 0.625;
            level.method_8406(type, x, y, z, (double)r, (double)g, (double)b);
        }
    }

    public static void playSplashEffects(class_1297 entity, double waterHeight) {
        entity.method_32876((class_6880)class_5712.field_28160);
        class_1937 level = entity.method_37908();
        class_1297 feetEntity = entity.method_5782() && entity.method_5642() != null ? entity.method_5642() : entity;
        float offset = feetEntity == entity ? 0.2f : 0.9f;
        class_243 movement = feetEntity.method_18798();
        float speed = Math.min(1.0f, (float)Math.sqrt(movement.field_1352 * movement.field_1352 * 0.2 + movement.field_1351 * movement.field_1351 + movement.field_1350 * movement.field_1350 * 0.2) * offset);
        class_2338 pos = class_2338.method_49638((class_2374)entity.method_19538());
        class_243 hitPos = new class_243(entity.method_23317(), (double)pos.method_10264() + waterHeight, entity.method_23321());
        class_5819 rand = level.field_9229;
        if (speed < 0.25f) {
            level.method_43128(null, hitPos.method_10216(), hitPos.method_10214(), hitPos.method_10215(), entity.method_5625(), entity.method_5634(), speed, 1.0f + (rand.method_43057() - rand.method_43057()) * 0.4f);
        } else {
            level.method_43128(null, hitPos.method_10216(), hitPos.method_10214(), hitPos.method_10215(), entity.method_5672(), entity.method_5634(), speed, 1.0f + (rand.method_43057() - rand.method_43057()) * 0.4f);
        }
        ClientBoundPlaySplashParticlesMessage particlePacket = new ClientBoundPlaySplashParticlesMessage(hitPos, speed, feetEntity.method_17681());
        NetworkHelper.sendToAllClientPlayersTrackingEntityAndSelf((class_1297)entity, (Message)particlePacket);
    }

    private static void attemptInWorldCrafting(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity, Supplier<Double> heightProvider) {
        if (!CommonConfigs.CAULDRON_HAND_CRAFTING.get().booleanValue()) {
            return;
        }
        if (!(entity instanceof class_1542)) {
            return;
        }
        class_1542 ie = (class_1542)entity;
        ie.method_6982(ie.field_7202 + 1);
        List entities = level.method_18467(class_1542.class, new class_238((double)pos.method_10263() + 0.125, (double)((float)pos.method_10264() + 0.375f), (double)pos.method_10260() + 0.125, (double)pos.method_10263() + 0.875, (double)pos.method_10264() + heightProvider.get(), (double)pos.method_10260() + 0.875));
        ArrayList<class_1799> ingredients = new ArrayList<class_1799>();
        for (class_1542 e : entities) {
            ingredients.add(e.method_6983());
        }
        SoftFluidStack cauldronFluid = CommonCauldronCode.getFluidOrWater(state, pos, (class_1936)level);
        FluidAndItemCraftResult craftResult = CauldronRecipeUtils.craft(level, (Boolean)state.method_11654((class_2769)ModCauldronBlock.BOILING), 3, cauldronFluid, ingredients);
        if (craftResult == null) {
            return;
        }
        SoftFluidStack resultFluid = craftResult.resultFluid();
        if (cauldronFluid.is(MLBuiltinSoftFluids.WATER) && cauldronFluid.getCount() == 3 && resultFluid.getCount() == 3 && PlatHelper.getPlatform().isForge()) {
            resultFluid.setCount(4);
        }
        CommonCauldronCode.playCraftSound(pos, level, cauldronFluid, resultFluid);
        CauldronConversion.setCorrectCauldronStateAndTile(state, level, pos, resultFluid);
        level.method_33596(entity, (class_6880)class_5712.field_28733, pos);
        CommonCauldronCode.spawnResultItems(level, pos, List.of(craftResult.craftedItem()));
        for (class_1542 e : entities) {
            if (!e.method_6983().method_7960()) continue;
            e.method_31472();
        }
    }

    private static void spawnResultItems(class_1937 level, class_2338 pos, List<class_1799> itemStacks) {
        if (itemStacks.isEmpty()) {
            return;
        }
        for (class_1799 item : itemStacks) {
            class_1542 iteEntity = new class_1542(level, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.25, (double)pos.method_10260() + 0.5, item);
            iteEntity.method_6988();
            iteEntity.method_18800(level.field_9229.method_43059() * 0.01, 0.375, level.field_9229.method_43059() * 0.01);
            level.method_8649((class_1297)iteEntity);
        }
    }

    public static boolean attemptPlayerCrafting(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, int tankCapacity, SoftFluidStack currentFluid) {
        if (!CommonConfigs.CAULDRON_HAND_CRAFTING.get().booleanValue()) {
            return false;
        }
        class_1799 playerStack = player.method_5998(hand);
        FluidAndItemsCraftResult result = CauldronRecipeUtils.craftMultiple(level, (Boolean)state.method_11654((class_2769)ModCauldronBlock.BOILING), tankCapacity, currentFluid, List.of(playerStack));
        if (result != null) {
            CommonCauldronCode.playCraftSound(pos, level, currentFluid, result.resultFluid());
            CauldronConversion.setCorrectCauldronStateAndTile(state, level, pos, result.resultFluid());
            CommonCauldronCode.onPlayerCrafted(level, pos, player, hand, playerStack, result.craftedItems());
            return true;
        }
        return false;
    }

    private static void onPlayerCrafted(class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_1799 playerItem, List<class_1799> craftedItems) {
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        player.method_7259(class_3468.field_15372.method_14956((Object)playerItem.method_7909()));
        class_174.field_24478.method_23889(serverPlayer, pos, playerItem);
        for (class_1799 crafted : craftedItems) {
            Utils.addItemOrDrop((class_1657)player, (class_1799)crafted, (InvPlacer)InvPlacer.handOrExistingOrAny((class_1268)hand));
        }
    }

    private static void playCraftSound(class_2338 pos, class_1937 level, SoftFluidStack oldStack, SoftFluidStack newStack) {
        if (oldStack.fluid() != newStack.fluid()) {
            level.method_8396(null, pos, class_3417.field_14978, class_3419.field_15245, 0.9f, 0.6f);
        } else {
            level.method_8396(null, pos, class_3417.field_14834, class_3419.field_15245, 1.0f, 1.3f);
        }
    }
}

