/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.recipe;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.amendments.common.recipe.CauldronRecipe;
import net.mehvahdjukaar.amendments.common.recipe.FluidAndItemCraftResult;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList;
import net.mehvahdjukaar.moonlight.api.fluids.MLBuiltinSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3532;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public class CauldronCraftingContainer
implements class_9695 {
    private final List<class_1799> originalItems;
    private final class_2371<class_1799> items;
    private final SoftFluidStack fluid;
    private final int fluidContainerSize;
    private final Multimap<FluidContainerList.Category, class_1799> equivalentFluidContainers;
    private final int dimension;
    private final int fluidPosition;
    private final boolean isBoiling;
    private static final FluidContainerList.Category DUMMY_WATER_BOWL_CATEGORY = (FluidContainerList.Category)class_156.method_656(() -> {
        JsonElement j = JsonParser.parseString((String)("{\n    \"capacity\":" + SoftFluid.BOWL_COUNT + ",        \"empty\": \"minecraft:bowl\",\n        \"filled\": [\n        \"minecraft:mushroom_stew\"\n        ]\n    }\n"));
        return (FluidContainerList.Category)((Pair)FluidContainerList.Category.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)j).getOrThrow()).getFirst();
    });

    private CauldronCraftingContainer(int fluidContainerSize, SoftFluidStack fluidStack, Collection<class_1799> items, int fluidPosition, boolean isBoiling) {
        this.dimension = class_3532.method_15384((double)Math.sqrt(items.size() + 1));
        this.originalItems = List.copyOf(items);
        this.items = class_2371.method_10213((int)(this.dimension * this.dimension), (Object)class_1799.field_8037);
        this.fluid = fluidStack;
        this.equivalentFluidContainers = fluidStack.toAllPossibleFilledItems();
        if (fluidStack.is(MLBuiltinSoftFluids.WATER)) {
            this.equivalentFluidContainers.put((Object)DUMMY_WATER_BOWL_CATEGORY, (Object)class_1802.field_8428.method_7854());
        }
        this.fluidPosition = fluidPosition;
        Preconditions.checkArgument((fluidPosition <= items.size() ? 1 : 0) != 0);
        this.fluidContainerSize = fluidContainerSize;
        this.isBoiling = isBoiling;
    }

    public static CauldronCraftingContainer surround8(boolean boiling, int fluidContainerSize, SoftFluidStack fluid, class_1799 item) {
        return new CauldronCraftingContainer(fluidContainerSize, fluid, List.of(item, item, item, item, item, item, item, item), 4, boiling);
    }

    public static CauldronCraftingContainer of(boolean boiling, int fluidContainerSize, SoftFluidStack fluid, class_1799 ... items) {
        return new CauldronCraftingContainer(fluidContainerSize, fluid, List.of(items), items.length, boiling);
    }

    public static CauldronCraftingContainer of(boolean boiling, int fluidContainerSize, SoftFluidStack fluid, Collection<class_1799> items) {
        return new CauldronCraftingContainer(fluidContainerSize, fluid, items, items.size(), boiling);
    }

    public int method_59983() {
        return this.items.size();
    }

    public boolean method_59987() {
        return this.items.isEmpty();
    }

    public class_1799 method_59984(int slot) {
        if (slot >= this.method_59983()) {
            return class_1799.field_8037;
        }
        return (class_1799)this.items.get(slot);
    }

    public SoftFluidStack getFluid() {
        return this.fluid;
    }

    public int getMaxAllowedFluidCount() {
        return this.fluidContainerSize;
    }

    protected class_9694 makeCraftingInput() {
        return class_9694.method_59986((int)this.dimension, (int)this.dimension, this.items);
    }

    @Nullable
    public FluidAndItemCraftResult craftWithCauldronRecipes(class_1937 level) {
        for (int j = 0; j < this.originalItems.size(); ++j) {
            this.items.set(j, (Object)this.originalItems.get(j));
        }
        List recipes = level.method_8433().method_17877(ModRegistry.CAULDRON_RECIPE_TYPE.get(), (class_9695)this, level);
        for (class_8786 h : recipes) {
            CauldronRecipe r = (CauldronRecipe)h.comp_1933();
            if (!r.matches(this, level)) continue;
            FluidAndItemCraftResult resultFluid = r.assembleFluid(this, (class_7225.class_7874)level.method_30349());
            class_2371 remainingItems = r.method_8111(this);
            if (!remainingItems.stream().allMatch(class_1799::method_7960)) continue;
            return resultFluid;
        }
        return null;
    }

    @Nullable
    public FluidAndItemCraftResult craftWithCraftingRecipes(class_1937 level) {
        for (Map.Entry cont : this.equivalentFluidContainers.entries()) {
            FluidContainerList.Category category = (FluidContainerList.Category)cont.getKey();
            class_1799 fluidInBottle = (class_1799)cont.getValue();
            this.setupFluidItem(fluidInBottle);
            class_9694 input = this.makeCraftingInput();
            List recipes = level.method_8433().method_17877(class_3956.field_17545, (class_9695)input, level);
            for (class_8786 h : recipes) {
                class_1799 craftedItem;
                int newFluidCount;
                class_3955 r = (class_3955)h.comp_1933();
                if (!r.method_8115((class_9695)input, level) || (newFluidCount = this.fluid.getCount() - category.getCapacity()) < 0 || newFluidCount > this.fluidContainerSize || (craftedItem = r.method_8116((class_9695)input, (class_7225.class_7874)level.method_30349())).method_7960()) continue;
                class_2371 remainingItems = r.method_8111((class_9695)input);
                class_1792 emptyContainer = category.getEmptyContainer();
                if (remainingItems.stream().allMatch(class_1799::method_7960)) {
                    FluidContainerList.Category catt;
                    if (fluidInBottle.method_31574(class_1802.field_8150)) {
                        return FluidAndItemCraftResult.of(craftedItem, this.fluid.copyWithCount(newFluidCount));
                    }
                    Pair equivalentFluid = SoftFluidStack.fromItem((class_1799)craftedItem);
                    if (equivalentFluid == null || (catt = (FluidContainerList.Category)equivalentFluid.getSecond()).getEmptyContainer() != emptyContainer) continue;
                    SoftFluidStack f = (SoftFluidStack)equivalentFluid.getFirst();
                    return FluidAndItemCraftResult.of(class_1799.field_8037, f.copyWithCount(this.fluid.getCount()));
                }
                if (!remainingItems.stream().allMatch(i -> i.method_7960() || i.method_7909() == emptyContainer)) continue;
                return FluidAndItemCraftResult.of(craftedItem, this.fluid.copyWithCount(newFluidCount));
            }
        }
        return null;
    }

    private void setupFluidItem(class_1799 filledFluidBottle) {
        this.items.clear();
        int j = 0;
        for (class_1799 item : this.originalItems) {
            if (j == this.fluidPosition) {
                ++j;
            }
            this.items.set(j, (Object)item);
            ++j;
        }
        this.items.set(this.fluidPosition, (Object)filledFluidBottle);
    }

    public boolean isBoiling() {
        return this.isBoiling;
    }
}

