/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.mehvahdjukaar.amendments.common.recipe.CauldronCraftingContainer;
import net.mehvahdjukaar.amendments.common.recipe.FluidAndItemCraftResult;
import net.mehvahdjukaar.amendments.common.recipe.SoftFluidIngredient;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.misc.BiggerStreamCodecs;
import net.minecraft.class_1662;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class CauldronRecipe
implements class_1860<CauldronCraftingContainer> {
    private final String group;
    private final class_2371<class_1856> inputItems;
    private final SoftFluidIngredient inputFluid;
    private final Optional<SoftFluidIngredient> outputFluid;
    private final class_1799 outputItem;
    private final boolean requireBoiling;
    private final int fluidAmountDifference;
    private static final Codec<class_2371<class_1856>> ING_LIST_CODEC = class_1856.field_46096.listOf().flatXmap(list -> {
        Object[] ingredients = (class_1856[])list.stream().filter(ingredient -> !ingredient.method_8103()).toArray(class_1856[]::new);
        if (ingredients.length == 0) {
            return DataResult.error(() -> "No ingredients for cauldron recipe");
        }
        return DataResult.success((Object)class_2371.method_10212((Object)class_1856.field_9017, (Object[])ingredients));
    }, DataResult::success);

    protected CauldronRecipe(String group, SoftFluidIngredient inputFluid, class_2371<class_1856> inputItems, Optional<SoftFluidIngredient> outputFluid, class_1799 outputItem, int fluidAmountDifference, boolean requireBoiling) {
        this.group = group;
        this.inputItems = inputItems;
        this.inputFluid = inputFluid;
        this.outputItem = outputItem;
        this.outputFluid = outputFluid;
        this.fluidAmountDifference = fluidAmountDifference;
        this.requireBoiling = requireBoiling;
    }

    public class_1865<?> method_8119() {
        return ModRegistry.CAULDRON_RECIPE_SERIALIZER.get();
    }

    public class_3956<?> method_17716() {
        return ModRegistry.CAULDRON_RECIPE_TYPE.get();
    }

    public String method_8112() {
        return this.group;
    }

    public class_1799 method_8110(class_7225.class_7874 registries) {
        return this.outputItem;
    }

    public class_2371<class_1856> method_8117() {
        return this.inputItems;
    }

    public boolean matches(CauldronCraftingContainer inv, class_1937 level) {
        if (this.requireBoiling && !inv.isBoiling()) {
            return false;
        }
        class_1662 stackedContents = new class_1662();
        int i = 0;
        for (int j = 0; j < inv.method_59983(); ++j) {
            class_1799 itemStack = inv.method_59984(j);
            if (itemStack.method_7960()) continue;
            ++i;
            stackedContents.method_20478(itemStack, 1);
        }
        SoftFluidStack tankFluid = inv.getFluid();
        int newCount = tankFluid.getCount() + this.fluidAmountDifference;
        if (!this.inputFluid.matches(tankFluid) || newCount < 0 || newCount > inv.getMaxAllowedFluidCount()) {
            return false;
        }
        return i == this.inputItems.size() && stackedContents.method_7402((class_1860)this, null);
    }

    @Deprecated
    public class_1799 assemble(CauldronCraftingContainer input, class_7225.class_7874 registries) {
        return this.method_8110(registries);
    }

    public FluidAndItemCraftResult assembleFluid(CauldronCraftingContainer container, class_7225.class_7874 registries) {
        SoftFluidStack tankFluid = container.getFluid();
        class_1799 craftedItem = this.outputItem.method_7972();
        SoftFluidStack outputFluidStack = this.outputFluid.map(SoftFluidIngredient::createStack).orElseGet(() -> SoftFluidStack.empty((class_7225.class_7874)registries));
        SoftFluidStack newTankFluid = outputFluidStack.isEmpty() ? tankFluid : outputFluidStack;
        newTankFluid.setCount(tankFluid.getCount() + this.fluidAmountDifference);
        return FluidAndItemCraftResult.of(craftedItem, newTankFluid);
    }

    public boolean method_8113(int width, int height) {
        return width * height >= this.inputItems.size();
    }

    public static class Serializer
    implements class_1865<CauldronRecipe> {
        public static final MapCodec<CauldronRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("group").forGetter(recipe -> recipe.group), (App)SoftFluidIngredient.CODEC.fieldOf("input_fluid").forGetter(recipe -> recipe.inputFluid), (App)ING_LIST_CODEC.fieldOf("input_items").forGetter(recipe -> recipe.inputItems), (App)SoftFluidIngredient.CODEC.optionalFieldOf("output_fluid").forGetter(recipe -> recipe.outputFluid), (App)class_1799.field_24671.optionalFieldOf("output_item", (Object)class_1799.field_8037).forGetter(recipe -> recipe.outputItem), (App)Codec.INT.optionalFieldOf("fluid_amount_difference", (Object)0).forGetter(recipe -> recipe.fluidAmountDifference), (App)Codec.BOOL.optionalFieldOf("require_boiling", (Object)false).orElse((Object)false).forGetter(recipe -> recipe.requireBoiling)).apply((Applicative)instance, CauldronRecipe::new));
        public static final class_9139<class_9129, CauldronRecipe> STREAM_CODEC = BiggerStreamCodecs.composite((class_9139)class_9135.field_48554, CauldronRecipe::method_8112, SoftFluidIngredient.STREAM_CODEC, r -> r.inputFluid, (class_9139)class_1856.field_48355.method_56433(class_9135.method_56363()).method_56432(l -> class_2371.method_10212((Object)class_1856.field_9017, (Object[])l.toArray(new class_1856[0])), Function.identity()), r -> r.inputItems, (class_9139)class_9135.method_56382(SoftFluidIngredient.STREAM_CODEC), r -> r.outputFluid, (class_9139)class_1799.field_48349, r -> r.outputItem, (class_9139)class_9135.field_48550, r -> r.fluidAmountDifference, (class_9139)class_9135.field_48547, r -> r.requireBoiling, CauldronRecipe::new);

        public MapCodec<CauldronRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, CauldronRecipe> method_56104() {
            return STREAM_CODEC;
        }
    }
}

