/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.config.v3.serialization;

import fuzs.puzzleslib.api.data.v2.tags.AbstractTagAppender;
import fuzs.puzzleslib.api.init.v3.registry.RegistryHelper;
import fuzs.puzzleslib.impl.config.serialization.EnumProvider;
import fuzs.puzzleslib.impl.config.serialization.RegistryProvider;
import fuzs.puzzleslib.impl.core.CommonFactories;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3495;
import net.minecraft.class_5321;

public interface KeyedValueProvider<T> {
    public static <T> KeyedValueProvider<T> registryEntries(class_5321<? extends class_2378<? super T>> registryKey) {
        return new RegistryProvider(registryKey);
    }

    public static <T extends Enum<T>> KeyedValueProvider<T> enumConstants(Class<T> enumClazz) {
        return KeyedValueProvider.enumConstants(enumClazz, "minecraft");
    }

    public static <T extends Enum<T>> KeyedValueProvider<T> enumConstants(Class<T> enumClazz, String modId) {
        return new EnumProvider<T>(enumClazz, modId);
    }

    @SafeVarargs
    public static <T> List<String> toString(class_5321<? extends class_2378<? super T>> registryKey, T ... entries) {
        return KeyedValueProvider.toString(KeyedValueProvider.registryEntries(registryKey), entries);
    }

    public static <T> AbstractTagAppender<T> tagAppender(class_5321<? extends class_2378<? super T>> registryKey) {
        class_2378 registry = RegistryHelper.findNullableBuiltInRegistry(registryKey);
        Function<Object, class_5321> keyExtractor = registry != null ? t -> RegistryHelper.getResourceKeyOrThrow(registry, t) : null;
        return CommonFactories.INSTANCE.getTagAppender(new class_3495(), keyExtractor);
    }

    @SafeVarargs
    public static <T extends Enum<T>> List<String> toString(Class<T> enumClazz, T ... entries) {
        return KeyedValueProvider.toString(enumClazz, (String)"minecraft", entries);
    }

    @SafeVarargs
    public static <T extends Enum<T>> List<String> toString(Class<T> enumClazz, String modId, T ... entries) {
        return KeyedValueProvider.toString(KeyedValueProvider.enumConstants(enumClazz, modId), entries);
    }

    @SafeVarargs
    public static <T> List<String> toString(KeyedValueProvider<T> valueProvider, T ... entries) {
        return Stream.of(entries).peek(Objects::requireNonNull).map(valueProvider::getKey).filter(Objects::nonNull).map(class_2960::toString).collect(Collectors.toList());
    }

    public Optional<T> getValue(class_2960 var1);

    public class_2960 getKey(T var1);

    public Stream<Map.Entry<class_2960, T>> stream();

    public Stream<T> streamValues();

    public String name();
}

