/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.beardifier;

import com.yungnickyoung.minecraft.yungsapi.mixin.accessor.BeardifierAccessor;
import com.yungnickyoung.minecraft.yungsapi.mixin.accessor.NoiseChunkAccessor;
import com.yungnickyoung.minecraft.yungsapi.world.structure.YungJigsawStructure;
import com.yungnickyoung.minecraft.yungsapi.world.structure.jigsaw.element.YungJigsawPoolElement;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.adaptations.EnhancedTerrainAdaptation;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.aquiferoverride.AquiferOverride;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.aquiferoverride.AquiferOverrideMask;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.aquiferoverride.AquiferOverrideMaskSupplier;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.beardifier.EnhancedBeardifierData;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.beardifier.EnhancedBeardifierRigid;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.beardifier.EnhancedJigsawJunction;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.List;
import net.minecraft.class_1923;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_3780;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_5138;
import net.minecraft.class_5817;
import net.minecraft.class_6568;
import net.minecraft.class_6910;

public class EnhancedBeardifierHelper {
    public static class_5817 forStructuresInChunk(class_5138 structureManager, class_1923 chunkPos, class_5817 original) {
        ObjectArrayList enhancedBeardifierRigidList = new ObjectArrayList(10);
        ObjectArrayList enhancedJunctionList = new ObjectArrayList(10);
        int chunkMinBlockX = chunkPos.method_8326();
        int chunkMinBlockZ = chunkPos.method_8328();
        List structureStarts = structureManager.method_41035(chunkPos, structure -> structure instanceof YungJigsawStructure);
        for (class_3449 structureStart : structureStarts) {
            EnhancedTerrainAdaptation structureTerrainAdaptation = ((YungJigsawStructure)structureStart.method_16656()).enhancedTerrainAdaptation;
            int kernelRadius = structureTerrainAdaptation.getKernelRadius();
            for (class_3443 structurePiece2 : structureStart.method_14963()) {
                YungJigsawPoolElement yungElement;
                class_3790 poolPiece;
                class_3784 class_37842;
                if (!(structurePiece2 instanceof class_3790) || !((class_37842 = (poolPiece = (class_3790)structurePiece2).method_16644()) instanceof YungJigsawPoolElement) || !(yungElement = (YungJigsawPoolElement)class_37842).getEnhancedTerrainAdaptation().isPresent()) continue;
                kernelRadius = Math.max(kernelRadius, yungElement.getEnhancedTerrainAdaptation().get().getKernelRadius());
            }
            int maxKernelRadius = kernelRadius;
            if (maxKernelRadius <= 0) continue;
            List<class_3443> nearbyPieces = structureStart.method_14963().stream().filter(structurePiece -> structurePiece.method_16654(chunkPos, maxKernelRadius)).toList();
            for (class_3443 nearbyPiece : nearbyPieces) {
                if (nearbyPiece instanceof class_3790) {
                    YungJigsawPoolElement yungElement;
                    class_3790 poolElementPiece = (class_3790)nearbyPiece;
                    class_3785.class_3786 projection = poolElementPiece.method_16644().method_16624();
                    EnhancedTerrainAdaptation pieceTerrainAdaptation = structureTerrainAdaptation;
                    class_3784 class_37843 = poolElementPiece.method_16644();
                    if (class_37843 instanceof YungJigsawPoolElement && (yungElement = (YungJigsawPoolElement)class_37843).getEnhancedTerrainAdaptation().isPresent()) {
                        pieceTerrainAdaptation = yungElement.getEnhancedTerrainAdaptation().get();
                    }
                    if (pieceTerrainAdaptation == EnhancedTerrainAdaptation.NONE) continue;
                    int pieceKernelRadius = pieceTerrainAdaptation.getKernelRadius();
                    if (projection == class_3785.class_3786.field_16687) {
                        enhancedBeardifierRigidList.add((Object)new EnhancedBeardifierRigid(poolElementPiece.method_14935(), pieceTerrainAdaptation, poolElementPiece.method_16646(), poolElementPiece.method_16888()));
                    }
                    for (class_3780 jigsawJunction : poolElementPiece.method_16645()) {
                        int sourceX = jigsawJunction.method_16610();
                        int sourceZ = jigsawJunction.method_16609();
                        if (sourceX <= chunkMinBlockX - pieceKernelRadius || sourceZ <= chunkMinBlockZ - pieceKernelRadius || sourceX >= chunkMinBlockX + 15 + pieceKernelRadius || sourceZ >= chunkMinBlockZ + 15 + pieceKernelRadius) continue;
                        enhancedJunctionList.add((Object)new EnhancedJigsawJunction(jigsawJunction, pieceTerrainAdaptation));
                    }
                    continue;
                }
                if (structureTerrainAdaptation == EnhancedTerrainAdaptation.NONE) continue;
                enhancedBeardifierRigidList.add((Object)new EnhancedBeardifierRigid(nearbyPiece.method_14935(), structureTerrainAdaptation, 0, class_2470.field_11467));
            }
        }
        class_5817 newBeardifier = new class_5817(((BeardifierAccessor)original).getPieceIterator(), ((BeardifierAccessor)original).getJunctionIterator());
        EnhancedBeardifierData enhancedBeardifier = (EnhancedBeardifierData)newBeardifier;
        enhancedBeardifier.setEnhancedPieceIterator((ObjectListIterator<EnhancedBeardifierRigid>)enhancedBeardifierRigidList.iterator());
        enhancedBeardifier.setEnhancedJunctionIterator((ObjectListIterator<EnhancedJigsawJunction>)enhancedJunctionList.iterator());
        return newBeardifier;
    }

    public static double computeDensity(class_6910.class_6912 ctx, double density, EnhancedBeardifierData data) {
        EnhancedTerrainAdaptation pieceTerrainAdaptation;
        int x = ctx.comp_371();
        int y = ctx.comp_372();
        int z = ctx.comp_373();
        AquiferOverride aquiferOverride = AquiferOverride.NONE;
        while (data.getEnhancedPieceIterator() != null && data.getEnhancedPieceIterator().hasNext()) {
            EnhancedBeardifierRigid rigid = (EnhancedBeardifierRigid)data.getEnhancedPieceIterator().next();
            class_3341 pieceBoundingBox = rigid.pieceBoundingBox();
            pieceTerrainAdaptation = rigid.pieceTerrainAdaptation();
            class_2470 pieceRotation = rigid.rotation();
            pieceBoundingBox = pieceBoundingBox.method_19311(0, (int)pieceTerrainAdaptation.getBottomOffset(), 0);
            class_2350.class_2351 xPaddingDirection = pieceRotation.method_10503(class_2350.field_11034).method_10166();
            int xPadding = xPaddingDirection == class_2350.class_2351.field_11048 ? pieceTerrainAdaptation.getPadding().x() : pieceTerrainAdaptation.getPadding().z();
            int zPadding = xPaddingDirection == class_2350.class_2351.field_11048 ? pieceTerrainAdaptation.getPadding().z() : pieceTerrainAdaptation.getPadding().x();
            pieceBoundingBox = pieceBoundingBox.method_59718(xPadding, 0, zPadding);
            if (pieceTerrainAdaptation.getPadding().top() != 0) {
                pieceBoundingBox = new class_3341(pieceBoundingBox.method_35415(), pieceBoundingBox.method_35416(), pieceBoundingBox.method_35417(), pieceBoundingBox.method_35418(), pieceBoundingBox.method_35419() + pieceTerrainAdaptation.getPadding().top(), pieceBoundingBox.method_35420());
            }
            if (pieceTerrainAdaptation.getPadding().bottom() != 0) {
                pieceBoundingBox = new class_3341(pieceBoundingBox.method_35415(), pieceBoundingBox.method_35416() - pieceTerrainAdaptation.getPadding().bottom(), pieceBoundingBox.method_35417(), pieceBoundingBox.method_35418(), pieceBoundingBox.method_35419(), pieceBoundingBox.method_35420());
            }
            int xDistanceToBoundingBox = Math.max(0, Math.max(pieceBoundingBox.method_35415() - x, x - pieceBoundingBox.method_35418()));
            int yDistanceToBoundingBox = Math.max(0, Math.max(pieceBoundingBox.method_35416() - y, y - pieceBoundingBox.method_35419()));
            int zDistanceToBoundingBox = Math.max(0, Math.max(pieceBoundingBox.method_35417() - z, z - pieceBoundingBox.method_35420()));
            int yDistanceToPieceBottom = y - pieceBoundingBox.method_35416();
            double densityFactor = 0.0;
            if (pieceTerrainAdaptation != EnhancedTerrainAdaptation.NONE) {
                densityFactor = pieceTerrainAdaptation.computeDensityFactor(xDistanceToBoundingBox, yDistanceToBoundingBox, zDistanceToBoundingBox, yDistanceToPieceBottom) * 0.8;
            }
            density += densityFactor;
            if (densityFactor == 0.0 || pieceTerrainAdaptation.getAquiferOverride() == AquiferOverride.NONE) continue;
            aquiferOverride = pieceTerrainAdaptation.getAquiferOverride();
        }
        data.getEnhancedPieceIterator().back(Integer.MAX_VALUE);
        while (data.getEnhancedJunctionIterator() != null && data.getEnhancedJunctionIterator().hasNext()) {
            EnhancedJigsawJunction enhancedJigsawJunction = (EnhancedJigsawJunction)data.getEnhancedJunctionIterator().next();
            class_3780 jigsawJunction = enhancedJigsawJunction.jigsawJunction();
            pieceTerrainAdaptation = enhancedJigsawJunction.pieceTerrainAdaptation();
            int groundY = jigsawJunction.method_16611() + (int)pieceTerrainAdaptation.getBottomOffset();
            int xDistanceToJunction = x - jigsawJunction.method_16610();
            int yDistanceToJunction = y - groundY;
            int zDistanceToJunction = z - jigsawJunction.method_16609();
            double densityFactor = pieceTerrainAdaptation.computeDensityFactor(xDistanceToJunction, yDistanceToJunction, zDistanceToJunction, yDistanceToJunction) * 0.4;
            density += densityFactor;
            if (densityFactor == 0.0 || pieceTerrainAdaptation.getAquiferOverride() == AquiferOverride.NONE) continue;
            aquiferOverride = pieceTerrainAdaptation.getAquiferOverride();
        }
        data.getEnhancedJunctionIterator().back(Integer.MAX_VALUE);
        if (aquiferOverride != AquiferOverride.NONE) {
            EnhancedBeardifierHelper.updateAquiferOverrideMask(data, aquiferOverride, x, y, z);
        }
        return density;
    }

    private static void updateAquiferOverrideMask(EnhancedBeardifierData data, AquiferOverride aquiferOverride, int x, int y, int z) {
        class_6568 noiseChunk = data.getNoiseChunk();
        NoiseChunkAccessor noiseChunkAccessor = (NoiseChunkAccessor)noiseChunk;
        AquiferOverrideMaskSupplier aquiferOverrideMaskSupplier = (AquiferOverrideMaskSupplier)noiseChunk;
        int chunkHeight = noiseChunkAccessor.getNoiseSettings().comp_174();
        int minY = noiseChunkAccessor.getNoiseSettings().comp_173();
        AquiferOverrideMask aquiferOverrideMask = aquiferOverrideMaskSupplier.getOrCreateAquiferOverrideMask(() -> new AquiferOverrideMask(chunkHeight, minY));
        aquiferOverrideMask.set(x, y, z);
        aquiferOverrideMask.setAquiferOverride(aquiferOverride);
    }
}

