/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.adorable_eggs.mixin;

import com.cerbon.adorable_eggs.AdorableEggs;
import com.cerbon.adorable_eggs.block.custom.EggBlock;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_9275;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1826.class})
public class SpawnEggItemMixin
extends class_1792 {
    public SpawnEggItemMixin(class_1792.class_1793 properties) {
        super(properties);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        super.method_7851(stack, context, tooltipComponents, tooltipFlag);
        if (AdorableEggs.config.isPlaceEggsEnabled) {
            class_310 client = class_310.method_1551();
            class_746 player = client.field_1724;
            if (player == null) {
                return;
            }
            if (player.method_7337()) {
                tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.minecraft.spawn_egg.creative_tooltip"));
            } else {
                tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.minecraft.spawn_egg.survival_tooltip"));
            }
        }
    }

    @Inject(method={"useOn"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getBlockEntity(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/entity/BlockEntity;", ordinal=0)}, cancellable=true)
    private void useOnSpawner(class_1838 context, CallbackInfoReturnable<class_1269> cir) {
        class_1657 player = context.method_8036();
        if (player != null && !player.method_7337() && context.method_8045().method_8320(context.method_8037()).method_27852(class_2246.field_10260)) {
            cir.setReturnValue((Object)class_1269.field_5814);
        }
    }

    @Inject(method={"useOn"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;getCollisionShape(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/phys/shapes/VoxelShape;")}, cancellable=true)
    private void useOn(class_1838 context, CallbackInfoReturnable<class_1269> cir) {
        class_1657 player = context.method_8036();
        if (player == null || !AdorableEggs.config.isPlaceEggsEnabled || this.getBlock() == null) {
            return;
        }
        if (player.method_7337() && player.method_5715() || !player.method_7337()) {
            cir.setReturnValue((Object)this.place(new class_1750(context)));
        }
    }

    @Inject(method={"getColor"}, at={@At(value="RETURN")}, cancellable=true)
    private void getColor(int tintIndex, CallbackInfoReturnable<Integer> cir) {
        if (EggBlock.SPAWN_EGG_TO_BLOCK_EGG.get((class_1826)this) != null) {
            cir.setReturnValue((Object)0xFFFFFF);
        }
    }

    @Unique
    public class_1269 place(class_1750 context) {
        if (!this.getBlock().method_45382(context.method_8045().method_45162())) {
            return class_1269.field_5814;
        }
        if (!context.method_7716()) {
            return class_1269.field_5814;
        }
        class_1750 blockPlaceContext = this.updatePlacementContext(context);
        if (blockPlaceContext == null) {
            return class_1269.field_5814;
        }
        class_2680 blockState = this.getPlacementState(blockPlaceContext);
        if (blockState == null) {
            return class_1269.field_5814;
        }
        if (!this.placeBlock(blockPlaceContext, blockState)) {
            return class_1269.field_5814;
        }
        class_2338 blockPos = blockPlaceContext.method_8037();
        class_1937 level = blockPlaceContext.method_8045();
        class_1657 player = blockPlaceContext.method_8036();
        class_1799 itemStack = blockPlaceContext.method_8041();
        class_2680 blockState2 = level.method_8320(blockPos);
        if (blockState2.method_27852(blockState.method_26204())) {
            blockState2 = this.updateBlockStateFromTag(blockPos, level, itemStack, blockState2);
            this.updateCustomBlockEntityTag(blockPos, level, player, itemStack, blockState2);
            SpawnEggItemMixin.updateBlockEntityComponents(level, blockPos, itemStack);
            blockState2.method_26204().method_9567(level, blockPos, blockState2, (class_1309)player, itemStack);
            if (player instanceof class_3222) {
                class_174.field_1191.method_23889((class_3222)player, blockPos, itemStack);
            }
        }
        class_2498 soundType = blockState2.method_26231();
        level.method_8396(player, blockPos, this.getPlaceSound(blockState2), class_3419.field_15245, (soundType.method_10597() + 1.0f) / 2.0f, soundType.method_10599() * 0.8f);
        level.method_43276((class_6880)class_5712.field_28164, blockPos, class_5712.class_7397.method_43286((class_1297)player, (class_2680)blockState2));
        itemStack.method_57008(1, (class_1309)player);
        return class_1269.method_29236((boolean)level.field_9236);
    }

    @Unique
    @Nullable
    public class_1750 updatePlacementContext(class_1750 context) {
        return context;
    }

    @Unique
    private static void updateBlockEntityComponents(class_1937 level, class_2338 poa, class_1799 stack) {
        class_2586 blockEntity = level.method_8321(poa);
        if (blockEntity != null) {
            blockEntity.method_58683(stack);
            blockEntity.method_5431();
        }
    }

    @Unique
    private class_2680 updateBlockStateFromTag(class_2338 pos, class_1937 level, class_1799 stack, class_2680 state) {
        class_9275 blockItemStateProperties = (class_9275)stack.method_57825(class_9334.field_49623, (Object)class_9275.field_49284);
        if (blockItemStateProperties.method_57414()) {
            return state;
        }
        class_2680 blockState = blockItemStateProperties.method_57415(state);
        if (blockState != state) {
            level.method_8652(pos, blockState, 2);
        }
        return blockState;
    }

    @Unique
    protected boolean updateCustomBlockEntityTag(class_2338 pos, class_1937 level, @Nullable class_1657 player, class_1799 stack, class_2680 state) {
        return class_1747.method_7714((class_1937)level, (class_1657)player, (class_2338)pos, (class_1799)stack);
    }

    @Unique
    protected boolean placeBlock(class_1750 context, class_2680 state) {
        return context.method_8045().method_8652(context.method_8037(), state, 11);
    }

    @Nullable
    protected class_2680 getPlacementState(class_1750 context) {
        class_2680 blockState = this.getBlock().method_9605(context);
        return blockState != null && this.canPlace(context, blockState) ? blockState : null;
    }

    @Unique
    protected class_2248 getBlock() {
        return (class_2248)EggBlock.SPAWN_EGG_TO_BLOCK_EGG.get((Object)this);
    }

    @Unique
    protected boolean canPlace(class_1750 context, class_2680 state) {
        class_1657 player = context.method_8036();
        class_3726 collisionContext = player == null ? class_3726.method_16194() : class_3726.method_16195((class_1297)player);
        return (!this.mustSurvive() || state.method_26184((class_4538)context.method_8045(), context.method_8037())) && context.method_8045().method_8628(state, context.method_8037(), collisionContext);
    }

    @Unique
    protected boolean mustSurvive() {
        return true;
    }

    @Unique
    protected class_3414 getPlaceSound(class_2680 state) {
        return state.method_26231().method_10598();
    }
}

