/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core;

import java.util.function.Function;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_3611;
import net.minecraft.class_5250;
import net.minecraft.class_5321;

public class TextComponents {
    public static TextComponentBuilder empty() {
        return TextComponents.string("");
    }

    public static TextComponentBuilder string(String text) {
        return new TextComponentBuilder(class_2561.method_43470((String)text));
    }

    public static TextComponentBuilder number(int number) {
        return new TextComponentBuilder(class_2561.method_43470((String)Integer.toString(number)));
    }

    public static TextComponentBuilder number(double number, int decimals) {
        return new TextComponentBuilder(class_2561.method_43470((String)String.format("%." + decimals + "f", number)));
    }

    public static TextComponentBuilder number(double number) {
        return new TextComponentBuilder(class_2561.method_43470((String)Double.toString(number)));
    }

    public static TextComponentBuilder translation(String translationKey, Object ... arguments) {
        return new TextComponentBuilder(class_2561.method_43469((String)translationKey, (Object[])arguments));
    }

    public static TextComponentBuilder translation(String translationKey) {
        return new TextComponentBuilder(class_2561.method_43471((String)translationKey));
    }

    public static TextComponentBuilder fromTextComponent(class_5250 textComponent) {
        return new TextComponentBuilder(textComponent);
    }

    public static TextComponentBuilder fromTextComponent(class_2561 textComponent) {
        return TextComponents.fromTextComponent(textComponent.method_27662());
    }

    public static String format(class_2561 textComponent) {
        return textComponent.getString();
    }

    public static TextComponentBuilder block(class_2248 block) {
        return TextComponents.translation(block.method_9539());
    }

    public static TextComponentBuilder blockState(class_2680 state) {
        return TextComponents.block(state.method_26204());
    }

    public static TextComponentBuilder item(class_1792 item) {
        return TextComponents.translation(item.method_7876());
    }

    public static TextComponentBuilder itemStack(class_1799 stack) {
        return TextComponents.fromTextComponent(stack.method_7964().method_27662());
    }

    public static TextComponentBuilder itemVariant(ItemVariant variant) {
        return TextComponents.itemStack(variant.toStack());
    }

    public static TextComponentBuilder fluid(class_3611 fluid) {
        return TextComponents.blockState(fluid.method_15785().method_15759());
    }

    public static TextComponentBuilder fluidVariant(FluidVariant variant) {
        return TextComponents.fluid(variant.getFluid());
    }

    public static TextComponentBuilder entity(class_1297 entity) {
        return TextComponents.fromTextComponent(entity.method_16914() ? entity.method_5797() : entity.method_5476());
    }

    public static TextComponentBuilder dimension(class_5321<class_1937> dimension) {
        Object dimensionName = dimension.method_29177().method_12832();
        dimensionName = ((String)dimensionName).substring(Math.min(((String)dimensionName).length() - 1, Math.max(0, ((String)dimensionName).indexOf(47) + 1))).toLowerCase();
        dimensionName = ((String)dimensionName).substring(0, 1).toUpperCase() + ((String)dimensionName).substring(1);
        for (int i = 0; i < ((String)dimensionName).length() - 1; ++i) {
            if (((String)dimensionName).charAt(i) != '_' || !Character.isAlphabetic(((String)dimensionName).charAt(i + 1))) continue;
            dimensionName = ((String)dimensionName).substring(0, i) + " " + (String)(i + 2 < ((String)dimensionName).length() ? ((String)dimensionName).substring(i + 1, i + 2).toUpperCase() + ((String)dimensionName).substring(i + 2) : ((String)dimensionName).substring(i + 1).toUpperCase());
        }
        return TextComponents.string((String)dimensionName);
    }

    public static TextComponentBuilder dimension(class_1937 world) {
        return TextComponents.dimension((class_5321<class_1937>)world.method_27983());
    }

    public static class TextComponentBuilder {
        private final TextComponentBuilder parent;
        private final class_5250 textComponent;

        private TextComponentBuilder(class_5250 textComponent, TextComponentBuilder parent) {
            this.textComponent = textComponent;
            this.parent = parent;
        }

        private TextComponentBuilder(class_5250 textComponent) {
            this(textComponent, null);
        }

        public TextComponentBuilder formatting(class_124 color) {
            this.updateStyle(style -> style.method_10977(color));
            return this;
        }

        public TextComponentBuilder color(class_124 color) {
            return this.formatting(color);
        }

        public TextComponentBuilder bold() {
            this.updateStyle(style -> style.method_10982(Boolean.valueOf(true)));
            return this;
        }

        public TextComponentBuilder italic() {
            this.updateStyle(style -> style.method_10978(Boolean.valueOf(true)));
            return this;
        }

        public TextComponentBuilder underline() {
            this.updateStyle(style -> style.method_30938(Boolean.valueOf(true)));
            return this;
        }

        public TextComponentBuilder strikethrough() {
            this.updateStyle(style -> style.method_36140(Boolean.valueOf(true)));
            return this;
        }

        public TextComponentBuilder obfuscate() {
            this.updateStyle(style -> style.method_36141(Boolean.valueOf(true)));
            return this;
        }

        public TextComponentBuilder reset() {
            this.updateStyle(style -> class_2583.field_24360.method_10982(Boolean.valueOf(false)).method_10978(Boolean.valueOf(false)).method_30938(Boolean.valueOf(false)).method_36140(Boolean.valueOf(false)).method_36141(Boolean.valueOf(false)));
            return this;
        }

        private void updateStyle(Function<class_2583, class_2583> updater) {
            this.textComponent.method_10862(updater.apply(this.textComponent.method_10866()));
        }

        public TextComponentBuilder string(String text) {
            return this.append(class_2561.method_43470((String)text));
        }

        public TextComponentBuilder translation(String translationKey, Object ... arguments) {
            return this.append(class_2561.method_43469((String)translationKey, (Object[])arguments));
        }

        public TextComponentBuilder translation(String translationKey) {
            return this.append(class_2561.method_43471((String)translationKey));
        }

        public TextComponentBuilder append(class_5250 textComponent) {
            this.textComponent.method_10852((class_2561)textComponent);
            return new TextComponentBuilder(textComponent, this);
        }

        public class_5250 get() {
            return this.parent == null ? this.textComponent : this.parent.get();
        }

        public String format() {
            return TextComponents.format((class_2561)this.get());
        }
    }
}

