/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.custom_nether_portals.cursedness;

import com.leclowndu93150.custom_nether_portals.CNPBlocks;
import com.leclowndu93150.custom_nether_portals.block.HorizontalNetherPortalBlock;
import com.leclowndu93150.custom_nether_portals.utils.HashSetQueue;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_4970;

public class HorizontalPortalShape {
    private static final int MIN_SIZE = 1;
    public static final int MAX_SIZE = 21;
    private static final class_4970.class_4973 FRAME = (state, level, pos) -> state.method_27852(class_2246.field_10540) || state.method_27852(class_2246.field_22423);
    private final class_1936 level;
    private final class_2338 firePos;
    private class_2350.class_2351 axis = class_2350.class_2351.field_11048;
    private int numPortalBlocks = 0;
    private boolean valid = false;
    private final HashSet<class_2338> validPortalPositions = new HashSet();
    private final HashSet<class_2338> framePositions = new HashSet();

    public static Optional<HorizontalPortalShape> findEmptyPortalShape(class_1936 level, class_2338 firePos) {
        return HorizontalPortalShape.findPortalShape(level, firePos, shape -> shape.isValid() && shape.numPortalBlocks == 0);
    }

    public static Optional<HorizontalPortalShape> findPortalShape(class_1936 level, class_2338 firePos, Predicate<HorizontalPortalShape> predicate) {
        HorizontalPortalShape shape = new HorizontalPortalShape(level, firePos);
        return predicate.test(shape) ? Optional.of(shape) : Optional.empty();
    }

    public HorizontalPortalShape(class_1936 level, class_2338 firePos) {
        this.level = level;
        this.firePos = firePos;
        this.valid = this.checkAreaForPortalValidity();
    }

    private boolean checkAreaForPortalValidity() {
        this.validPortalPositions.clear();
        this.framePositions.clear();
        HashSetQueue<class_2338> positionsToCheck = new HashSetQueue<class_2338>();
        HashSet<class_2338> visitedPositions = new HashSet<class_2338>();
        List<class_2350> horizontalDirections = List.of(class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039);
        positionsToCheck.push(this.firePos);
        while (!positionsToCheck.isEmpty()) {
            class_2338 pos = (class_2338)positionsToCheck.pop();
            if (visitedPositions.contains(pos)) continue;
            visitedPositions.add(pos);
            class_2680 state = this.level.method_8320(pos);
            if (HorizontalPortalShape.isValidPortalBlock(state) && pos.method_10264() == this.firePos.method_10264()) {
                this.validPortalPositions.add(pos);
                if (this.validPortalPositions.size() > 441) {
                    return false;
                }
                if (state.method_27852(class_2246.field_10316) || state.method_26204() instanceof HorizontalNetherPortalBlock) {
                    ++this.numPortalBlocks;
                }
                for (class_2350 dir : horizontalDirections) {
                    class_2338 neighborPos = pos.method_10093(dir);
                    if (visitedPositions.contains(neighborPos)) continue;
                    positionsToCheck.push(neighborPos);
                }
                continue;
            }
            if (FRAME.test(state, (class_1922)this.level, pos) && pos.method_10264() == this.firePos.method_10264()) {
                this.framePositions.add(pos);
                continue;
            }
            if (pos.method_10264() == this.firePos.method_10264() && HorizontalPortalShape.isValidPortalBlock(state)) continue;
            return false;
        }
        if (!this.hasCompleteFrame()) {
            return false;
        }
        this.determineAxis();
        return this.validPortalPositions.size() >= 1;
    }

    private boolean hasCompleteFrame() {
        for (class_2338 portalPos : this.validPortalPositions) {
            for (class_2350 dir : class_2350.class_2353.field_11062) {
                class_2338 checkPos = portalPos.method_10093(dir);
                if (this.validPortalPositions.contains(checkPos) || this.framePositions.contains(checkPos)) continue;
                return false;
            }
        }
        return true;
    }

    private void determineAxis() {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (class_2338 pos : this.validPortalPositions) {
            minX = Math.min(minX, pos.method_10263());
            maxX = Math.max(maxX, pos.method_10263());
            minZ = Math.min(minZ, pos.method_10260());
            maxZ = Math.max(maxZ, pos.method_10260());
        }
        int xSpan = maxX - minX + 1;
        int zSpan = maxZ - minZ + 1;
        this.axis = xSpan >= zSpan ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051;
    }

    private static boolean isValidPortalBlock(class_2680 state) {
        return state.method_26215() || state.method_26164(class_3481.field_21952) || state.method_27852(class_2246.field_10316) || state.method_26204() instanceof HorizontalNetherPortalBlock || state.method_27852(class_2246.field_22423) || state.method_45474();
    }

    public boolean isValid() {
        return this.valid;
    }

    public void createPortalBlocks() {
        if (!this.valid || CNPBlocks.HORIZONTAL_NETHER_PORTAL == null) {
            return;
        }
        class_2680 portalState = (class_2680)CNPBlocks.HORIZONTAL_NETHER_PORTAL.method_9564().method_11657(HorizontalNetherPortalBlock.AXIS, (Comparable)this.axis);
        this.validPortalPositions.forEach(pos -> this.level.method_8652(pos, portalState, 18));
    }

    public boolean isComplete() {
        return this.valid && this.validPortalPositions.size() == this.numPortalBlocks;
    }
}

