/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.custom_nether_portals.mixin;

import com.leclowndu93150.custom_nether_portals.utils.HashSetQueue;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2423;
import net.minecraft.class_2424;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2424.class})
public abstract class PortalShapeMixin {
    @Unique
    private boolean customShapes$valid = false;
    @Unique
    HashSet<class_2338> customShapes$validPortalPositions = new HashSet();
    @Unique
    int customShapes$portalBlockCount = 0;
    @Final
    @Shadow
    private class_1936 field_11318;
    @Final
    @Shadow
    private class_2350 field_11314;
    @Final
    @Shadow
    private class_2350.class_2351 field_11317;

    @Inject(method={"isEmpty"}, at={@At(value="HEAD")}, cancellable=true)
    private static void isEmpty(class_2680 state, CallbackInfoReturnable<Boolean> cir) {
        if (state.method_27852(class_2246.field_22423)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void constructor(class_1936 level, class_2338 startPos, class_2350.class_2351 axis, CallbackInfo ci) {
        this.customShapes$valid = this.customShapes$checkAreaForPortalValidity(startPos, axis);
    }

    @Unique
    private boolean customShapes$checkAreaForPortalValidity(class_2338 startPos, class_2350.class_2351 axis) {
        this.customShapes$validPortalPositions.clear();
        HashSet<class_2338> validFrameBlocks = new HashSet<class_2338>();
        HashSetQueue<class_2338> positionsToCheck = new HashSetQueue<class_2338>();
        boolean minSizeFound = true;
        List<class_2350> directions = List.of(class_2350.field_11033, class_2350.field_11036, this.field_11314.method_10153(), this.field_11314);
        positionsToCheck.push(startPos);
        while (!positionsToCheck.isEmpty()) {
            class_2338 pos = (class_2338)positionsToCheck.pop();
            if (this.customShapes$validPortalPositions.contains(pos) || validFrameBlocks.contains(pos)) continue;
            boolean isOrCanBePortal = this.customShapes$isValidPosForPortalBlock(pos);
            boolean isFrameBlock = this.customShapes$isValidFrameBlock(pos);
            if (!isOrCanBePortal && !isFrameBlock) {
                return false;
            }
            if (isOrCanBePortal) {
                this.customShapes$validPortalPositions.add(pos);
                if (this.customShapes$validPortalPositions.size() > 1000) {
                    return false;
                }
                if (this.field_11318.method_8320(pos).method_27852(class_2246.field_10316)) {
                    ++this.customShapes$portalBlockCount;
                }
                if (!minSizeFound && (this.customShapes$validPortalPositions.contains(pos.method_10084()) || this.customShapes$validPortalPositions.contains(pos.method_10074()))) {
                    minSizeFound = true;
                }
                directions.forEach(direction -> {
                    class_2338 neighborPos = pos.method_10093(direction);
                    if (!this.customShapes$validPortalPositions.contains(neighborPos) && !validFrameBlocks.contains(neighborPos)) {
                        positionsToCheck.push(neighborPos);
                    }
                });
                continue;
            }
            validFrameBlocks.add(pos);
        }
        return minSizeFound;
    }

    @Unique
    private boolean customShapes$isValidPosForPortalBlock(class_2338 pos) {
        class_2680 state = this.field_11318.method_8320(pos);
        return (state.method_26215() || state.method_27852(class_2246.field_10036) || state.method_27852(class_2246.field_10316) || state.method_27852(class_2246.field_22423)) && !this.field_11318.method_31606(pos);
    }

    @Unique
    private boolean customShapes$isValidFrameBlock(class_2338 pos) {
        class_2680 state = this.field_11318.method_8320(pos);
        return (state.method_27852(class_2246.field_10540) || state.method_27852(class_2246.field_22423)) && !this.field_11318.method_31606(pos);
    }

    @Inject(method={"createPortalBlocks"}, at={@At(value="HEAD")}, cancellable=true)
    private void createPortal(CallbackInfo ci) {
        class_2680 blockState = (class_2680)class_2246.field_10316.method_9564().method_11657((class_2769)class_2423.field_11310, (Comparable)this.field_11317);
        this.customShapes$validPortalPositions.forEach(pos -> this.field_11318.method_8652(pos, blockState, 18));
        ci.cancel();
    }

    @Inject(method={"isValid"}, at={@At(value="HEAD")}, cancellable=true)
    private void isValid(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)this.customShapes$valid);
    }

    @Inject(method={"isComplete"}, at={@At(value="HEAD")}, cancellable=true)
    private void isComplete(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)(this.customShapes$valid && this.customShapes$validPortalPositions.size() == this.customShapes$portalBlockCount ? 1 : 0));
    }
}

