/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.events;

import java.util.function.BooleanSupplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.server.MinecraftServer;
import net.xalcon.torchmaster.Torchmaster;
import net.xalcon.torchmaster.config.ITorchmasterConfig;
import net.xalcon.torchmaster.events.EventResult;
import net.xalcon.torchmaster.events.EventResultContainer;
import net.xalcon.torchmaster.platform.Services;

public class TorchmasterEventHandler {
    private static boolean isIntentionalSpawn(class_3730 spawnType) {
        switch (spawnType) {
            case field_16466: 
            case field_16470: 
            case field_16473: 
            case field_16468: 
            case field_16465: 
            case field_16461: 
            case field_16462: 
            case field_16467: {
                return true;
            }
        }
        return false;
    }

    private static boolean isNaturalSpawn(class_3730 spawnType) {
        switch (spawnType) {
            default: {
                return true;
            }
            case field_16466: 
            case field_16470: 
            case field_16473: 
            case field_16468: 
            case field_16465: 
            case field_16461: 
            case field_16462: 
            case field_16467: 
            case field_16469: 
            case field_16474: 
            case field_16471: 
            case field_16463: 
            case field_16460: 
        }
        return false;
    }

    public static void onCheckSpawn(class_3730 spawnType, class_1297 entity, class_243 location, EventResultContainer container) {
        ITorchmasterConfig config = Services.PLATFORM.getConfig();
        Torchmaster.LOG.debug("CheckSpawn - Reason: {}, Type: {}, Pos: {}/{}/{}", new Object[]{spawnType, class_1299.method_5890((class_1299)entity.method_5864()), location.field_1352, location.field_1351, location.field_1350});
        if (TorchmasterEventHandler.isIntentionalSpawn(spawnType)) {
            return;
        }
        if (!config.getAggressiveSpawnChecks() && container.getResult() == EventResult.ALLOW) {
            return;
        }
        if (config.getBlockOnlyNaturalSpawns() && !TorchmasterEventHandler.isNaturalSpawn(spawnType)) {
            return;
        }
        class_1937 level = entity.method_5770();
        Torchmaster.getRegistryForLevel(level).ifPresent(reg -> {
            if (reg.shouldBlockEntity(entity, entity.method_5770(), spawnType)) {
                container.setResult(EventResult.DENY);
                Torchmaster.LOG.debug("Blocking spawn of {}", (Object)class_1299.method_5890((class_1299)entity.method_5864()));
            } else {
                Torchmaster.LOG.debug("Allowed spawn of {}", (Object)class_1299.method_5890((class_1299)entity.method_5864()));
            }
        });
    }

    public static void onVillageSiege(class_1937 level, class_243 attemptedSpawnPos, EventResultContainer container) {
        ITorchmasterConfig config = Services.PLATFORM.getConfig();
        if (!config.getBlockVillageSieges()) {
            return;
        }
        Torchmaster.LOG.debug("VillageSiegeEvent - Pos: {}", (Object)attemptedSpawnPos);
        if (!config.getAggressiveSpawnChecks() && container.getResult() == EventResult.ALLOW) {
            return;
        }
        Torchmaster.getRegistryForLevel(level).ifPresent(reg -> {
            if (reg.shouldBlockVillagePillagerSiege(attemptedSpawnPos)) {
                container.setResult(EventResult.DENY);
                Torchmaster.LOG.debug("Blocking village siege @ {}", (Object)attemptedSpawnPos);
            } else {
                Torchmaster.LOG.debug("Allowed village siege @ {}", (Object)attemptedSpawnPos);
            }
        });
    }

    public static void onServerLevelTickEnd(MinecraftServer server, BooleanSupplier haveTime) {
        for (class_3218 level : server.method_3738()) {
            Torchmaster.getRegistryForLevel((class_1937)level).ifPresent(reg -> reg.onGlobalTick((class_1937)level));
        }
    }
}

