/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.client.renderer.fancypainting;

import com.teamresourceful.resourcefullib.client.CloseablePoseStack;
import earth.terrarium.handcrafted.client.renderer.fancypainting.FancyPaintingModel;
import earth.terrarium.handcrafted.common.entities.FancyPainting;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1535;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;

public class FancyPaintingRenderer
extends class_897<FancyPainting> {
    private static final class_2960 FRAME_SMALL_TEXTURE = class_2960.method_60655((String)"handcrafted", (String)"textures/painting/small_painting_frame.png");
    private static final class_2960 FRAME_MEDIUM_TEXTURE = class_2960.method_60655((String)"handcrafted", (String)"textures/painting/medium_painting_frame.png");
    private static final class_2960 FRAME_LARGE_TEXTURE = class_2960.method_60655((String)"handcrafted", (String)"textures/painting/large_painting_frame.png");
    private static final class_2960 FRAME_TALL_TEXTURE = class_2960.method_60655((String)"handcrafted", (String)"textures/painting/tall_painting_frame.png");
    private static final class_2960 FRAME_WIDE_TEXTURE = class_2960.method_60655((String)"handcrafted", (String)"textures/painting/wide_painting_frame.png");
    private final class_630 small;
    private final class_630 medium;
    private final class_630 large;
    private final class_630 tall;
    private final class_630 wide;
    private final Map<class_1535, class_2960> textures = new HashMap<class_1535, class_2960>();

    public FancyPaintingRenderer(class_5617.class_5618 context) {
        super(context);
        this.small = context.method_32167(FancyPaintingModel.LAYER_LOCATION_SMALL).method_32086("main");
        this.medium = context.method_32167(FancyPaintingModel.LAYER_LOCATION_MEDIUM).method_32086("main");
        this.large = context.method_32167(FancyPaintingModel.LAYER_LOCATION_LARGE).method_32086("main");
        this.tall = context.method_32167(FancyPaintingModel.LAYER_LOCATION_TALL).method_32086("main");
        this.wide = context.method_32167(FancyPaintingModel.LAYER_LOCATION_WIDE).method_32086("main");
    }

    public void render(FancyPainting entity, float entityYaw, float partialTick, class_4587 poseStack, class_4597 buffer, int packedLight) {
        class_1535 variant = (class_1535)entity.method_43404().comp_349();
        class_2350 direction = entity.method_5735();
        class_4588 frameVertex = buffer.getBuffer(class_1921.method_23572((class_2960)this.getTextureLocation(entity)));
        int width = variant.comp_2670() * 16;
        int height = variant.comp_2671() * 16;
        try (CloseablePoseStack ignored = new CloseablePoseStack(poseStack);){
            poseStack.method_22905(0.8f, 0.8f, 0.8f);
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(direction.method_10144()));
            poseStack.method_46416(0.0f, 0.875f, 0.46125f);
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
            this.getFrame(variant).method_22698(poseStack, frameVertex, packedLight, class_4608.field_21444);
            class_2960 texture = this.textures.computeIfAbsent(variant, v -> class_2960.method_60655((String)"handcrafted", (String)("textures/painting/" + v.comp_2672().method_12832() + ".png")));
            class_4588 paintingVertex = buffer.getBuffer(class_1921.method_23578((class_2960)texture));
            poseStack.method_22904((double)((float)width / 2.0f / -16.0f), -0.125 + 0.5 * (double)((float)(32 - height) / 16.0f), 0.46125);
            poseStack.method_22905((float)width / 16.0f, (float)height / 16.0f, 1.0f);
            FancyPaintingRenderer.renderPainting(poseStack.method_23760(), paintingVertex, direction, packedLight);
        }
    }

    private class_630 getFrame(class_1535 variant) {
        int width = variant.comp_2670();
        int height = variant.comp_2671();
        if (width == 1 && height == 1) {
            return this.small;
        }
        if (width == 2 && height == 2) {
            return this.medium;
        }
        if (width == 3 && height == 2) {
            return this.large;
        }
        if (width == 1 && height == 2) {
            return this.tall;
        }
        if (width == 2 && height == 1) {
            return this.wide;
        }
        throw new IllegalStateException("Unknown painting variant: " + String.valueOf(variant));
    }

    private static void renderPainting(class_4587.class_4665 pose, class_4588 consumer, class_2350 dir, int light) {
        class_2382 normal = dir.method_10163();
        consumer.method_22918(pose.method_23761(), 0.0f, 0.0f, 0.0f).method_39415(-1).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(light).method_60831(pose, (float)normal.method_10263(), (float)normal.method_10264(), (float)normal.method_10260());
        consumer.method_22918(pose.method_23761(), 0.0f, 1.0f, 0.0f).method_39415(-1).method_22913(0.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(light).method_60831(pose, (float)normal.method_10263(), (float)normal.method_10264(), (float)normal.method_10260());
        consumer.method_22918(pose.method_23761(), 1.0f, 1.0f, 0.0f).method_39415(-1).method_22913(1.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(light).method_60831(pose, (float)normal.method_10263(), (float)normal.method_10264(), (float)normal.method_10260());
        consumer.method_22918(pose.method_23761(), 1.0f, 0.0f, 0.0f).method_39415(-1).method_22913(1.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(light).method_60831(pose, (float)normal.method_10263(), (float)normal.method_10264(), (float)normal.method_10260());
    }

    @NotNull
    public class_2960 getTextureLocation(FancyPainting entity) {
        int width = ((class_1535)entity.method_43404().comp_349()).comp_2670();
        int height = ((class_1535)entity.method_43404().comp_349()).comp_2671();
        if (width == 1 && height == 1) {
            return FRAME_SMALL_TEXTURE;
        }
        if (width == 2 && height == 2) {
            return FRAME_MEDIUM_TEXTURE;
        }
        if (width == 3 && height == 2) {
            return FRAME_LARGE_TEXTURE;
        }
        if (width == 1 && height == 2) {
            return FRAME_TALL_TEXTURE;
        }
        if (width == 2 && height == 1) {
            return FRAME_WIDE_TEXTURE;
        }
        throw new IllegalStateException("Unknown painting variant: " + String.valueOf(entity.method_43404().comp_349()));
    }
}

