/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.hunspell;

import guideme.internal.shaded.lucene.analysis.hunspell.DictEntry;
import guideme.internal.shaded.lucene.analysis.hunspell.Dictionary;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class AffixedWord {
    private final String word;
    private final DictEntry entry;
    private final List<Affix> prefixes;
    private final List<Affix> suffixes;

    AffixedWord(String word, DictEntry entry, List<Affix> prefixes, List<Affix> suffixes) {
        this.word = word;
        this.entry = entry;
        this.prefixes = Collections.unmodifiableList(prefixes);
        this.suffixes = Collections.unmodifiableList(suffixes);
    }

    public String getWord() {
        return this.word;
    }

    public DictEntry getDictEntry() {
        return this.entry;
    }

    public List<Affix> getPrefixes() {
        return this.prefixes;
    }

    public List<Affix> getSuffixes() {
        return this.suffixes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AffixedWord)) {
            return false;
        }
        AffixedWord that = (AffixedWord)o;
        return this.word.equals(that.word) && this.entry.equals(that.entry) && this.prefixes.equals(that.prefixes) && this.suffixes.equals(that.suffixes);
    }

    public int hashCode() {
        return Objects.hash(this.word, this.entry, this.prefixes, this.suffixes);
    }

    public String toString() {
        return "AffixedWord[word=" + this.word + ", entry=" + String.valueOf(this.entry) + ", prefixes=" + String.valueOf(this.prefixes) + ", suffixes=" + String.valueOf(this.suffixes) + "]";
    }

    public static final class Affix {
        final int affixId;
        private final String presentableFlag;

        Affix(Dictionary dictionary, int affixId) {
            this.affixId = affixId;
            char encodedFlag = dictionary.affixData(affixId, 0);
            this.presentableFlag = dictionary.flagParsingStrategy.printFlag(encodedFlag);
        }

        public String getFlag() {
            return this.presentableFlag;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (this == o) return true;
            if (!(o instanceof Affix)) return false;
            Affix a = (Affix)o;
            if (this.affixId != a.affixId) return false;
            return true;
        }

        public int hashCode() {
            return this.affixId;
        }

        public String toString() {
            return this.presentableFlag + "(id=" + this.affixId + ")";
        }
    }
}

