/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.facet.rangeonrange;

import guideme.internal.shaded.lucene.document.BinaryRangeDocValues;
import guideme.internal.shaded.lucene.document.RangeFieldQuery;
import guideme.internal.shaded.lucene.facet.FacetCountsWithFilterQuery;
import guideme.internal.shaded.lucene.facet.FacetResult;
import guideme.internal.shaded.lucene.facet.FacetsCollector;
import guideme.internal.shaded.lucene.facet.LabelAndValue;
import guideme.internal.shaded.lucene.index.DocValues;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.util.ArrayUtil;
import guideme.internal.shaded.lucene.util.PriorityQueue;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

abstract class RangeOnRangeFacetCounts
extends FacetCountsWithFilterQuery {
    private final String[] labels;
    private final int[] counts;
    private final String field;
    private int totCount;

    protected RangeOnRangeFacetCounts(String field, FacetsCollector hits, RangeFieldQuery.QueryType queryType, Query fastMatchQuery, int numEncodedValueBytes, byte[][] encodedRanges, String[] labels) throws IOException {
        super(fastMatchQuery);
        assert (encodedRanges.length == labels.length);
        assert (encodedRanges[0].length % (2 * numEncodedValueBytes) == 0);
        this.field = field;
        this.labels = labels;
        this.counts = new int[encodedRanges.length];
        this.count(field, hits.getMatchingDocs(), encodedRanges, numEncodedValueBytes, queryType);
    }

    protected void count(String field, List<FacetsCollector.MatchingDocs> matchingDocs, byte[][] encodedRanges, int numEncodedValueBytes, RangeFieldQuery.QueryType queryType) throws IOException {
        int dims = encodedRanges[0].length / (2 * numEncodedValueBytes);
        ArrayUtil.ByteArrayComparator comparator = ArrayUtil.getUnsignedComparator(numEncodedValueBytes);
        int missingCount = 0;
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            BinaryRangeDocValues binaryRangeDocValues = new BinaryRangeDocValues(DocValues.getBinary(hits.context().reader(), field), dims, numEncodedValueBytes);
            DocIdSetIterator it = this.createIterator(hits, new DocIdSetIterator[0]);
            if (it == null) continue;
            this.totCount += hits.totalHits();
            int doc = it.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (binaryRangeDocValues.advanceExact(doc)) {
                    boolean hasValidRange = false;
                    for (int range = 0; range < encodedRanges.length; ++range) {
                        byte[] encodedRange = encodedRanges[range];
                        byte[] packedRange = binaryRangeDocValues.getPackedValue();
                        assert (encodedRange.length == packedRange.length);
                        if (!queryType.matches(encodedRange, packedRange, dims, numEncodedValueBytes, comparator)) continue;
                        int n = range;
                        this.counts[n] = this.counts[n] + 1;
                        hasValidRange = true;
                    }
                    if (!hasValidRange) {
                        ++missingCount;
                    }
                } else {
                    ++missingCount;
                }
                doc = it.nextDoc();
            }
        }
        this.totCount -= missingCount;
    }

    @Override
    public FacetResult getAllChildren(String dim, String ... path) throws IOException {
        this.validateDimAndPathForGetChildren(dim, path);
        LabelAndValue[] labelValues = new LabelAndValue[this.counts.length];
        for (int i = 0; i < this.counts.length; ++i) {
            labelValues[i] = new LabelAndValue(this.labels[i], this.counts[i]);
        }
        return new FacetResult(dim, path, this.totCount, labelValues, labelValues.length);
    }

    @Override
    public FacetResult getTopChildren(int topN, String dim, String ... path) throws IOException {
        RangeOnRangeFacetCounts.validateTopN(topN);
        this.validateDimAndPathForGetChildren(dim, path);
        PriorityQueue<Entry> pq = new PriorityQueue<Entry>(this, Math.min(topN, this.counts.length)){

            @Override
            protected boolean lessThan(Entry a, Entry b) {
                int cmp = Integer.compare(a.count, b.count);
                if (cmp == 0) {
                    cmp = b.label.compareTo(a.label);
                }
                return cmp < 0;
            }
        };
        int childCount = 0;
        Entry e = null;
        for (int i = 0; i < this.counts.length; ++i) {
            if (this.counts[i] == 0) continue;
            ++childCount;
            if (e == null) {
                e = new Entry();
            }
            e.label = this.labels[i];
            e.count = this.counts[i];
            e = pq.insertWithOverflow(e);
        }
        LabelAndValue[] results = new LabelAndValue[pq.size()];
        while (pq.size() != 0) {
            Entry entry = (Entry)pq.pop();
            assert (entry != null);
            results[pq.size()] = new LabelAndValue(entry.label, entry.count);
        }
        return new FacetResult(dim, path, this.totCount, results, childCount);
    }

    @Override
    public Number getSpecificValue(String dim, String ... path) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<FacetResult> getAllDims(int topN) throws IOException {
        RangeOnRangeFacetCounts.validateTopN(topN);
        return Collections.singletonList(this.getTopChildren(topN, this.field, new String[0]));
    }

    private void validateDimAndPathForGetChildren(String dim, String ... path) {
        if (!dim.equals(this.field)) {
            throw new IllegalArgumentException("invalid dim \"" + dim + "\"; should be \"" + this.field + "\"");
        }
        if (path.length != 0) {
            throw new IllegalArgumentException("path.length should be 0");
        }
    }

    private static final class Entry {
        int count;
        String label;

        private Entry() {
        }
    }
}

