/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.index.StandardDirectoryReader;
import guideme.internal.shaded.lucene.store.Directory;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public abstract class IndexCommit
implements Comparable<IndexCommit> {
    public abstract String getSegmentsFileName();

    public abstract Collection<String> getFileNames() throws IOException;

    public abstract Directory getDirectory();

    public abstract void delete();

    public abstract boolean isDeleted();

    public abstract int getSegmentCount();

    protected IndexCommit() {
    }

    public boolean equals(Object other) {
        if (other instanceof IndexCommit) {
            IndexCommit otherCommit = (IndexCommit)other;
            return otherCommit.getDirectory() == this.getDirectory() && otherCommit.getGeneration() == this.getGeneration();
        }
        return false;
    }

    public int hashCode() {
        return this.getDirectory().hashCode() + Long.valueOf(this.getGeneration()).hashCode();
    }

    public abstract long getGeneration();

    public abstract Map<String, String> getUserData() throws IOException;

    @Override
    public int compareTo(IndexCommit commit) {
        if (this.getDirectory() != commit.getDirectory()) {
            throw new UnsupportedOperationException("cannot compare IndexCommits from different Directory instances");
        }
        long gen = this.getGeneration();
        long comgen = commit.getGeneration();
        return Long.compare(gen, comgen);
    }

    StandardDirectoryReader getReader() {
        return null;
    }
}

